/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.processor;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import javax.xml.transform.TransformerException;
import org.verapdf.core.VeraPDFException;
import org.verapdf.processor.BatchProcessingHandler;
import org.verapdf.processor.MrrHandler;
import org.verapdf.processor.reports.BatchSummary;
import org.verapdf.report.HTMLReport;

final class HTMLHandler
extends MrrHandler {
    private final File file;
    private final OutputStream reportStream;
    private final String wikiPath;

    private HTMLHandler(OutputStream reportStream, File file, String wikiPath) throws VeraPDFException, IOException {
        super(new PrintWriter(new FileOutputStream(file)), false);
        this.reportStream = reportStream;
        this.file = file;
        this.wikiPath = wikiPath;
    }

    static BatchProcessingHandler newInstance(OutputStream reportStream, String wikiPath) throws VeraPDFException {
        try {
            File file = File.createTempFile("veraPDF", "xmlReport");
            return new HTMLHandler(reportStream, file, wikiPath);
        }
        catch (IOException exception) {
            throw new VeraPDFException(exception.getMessage(), exception);
        }
    }

    @Override
    public void handleBatchEnd(BatchSummary summary) throws VeraPDFException {
        super.handleBatchEnd(summary);
        try (FileInputStream xmlStream = new FileInputStream(this.file);){
            HTMLReport.writeHTMLReport(xmlStream, this.reportStream, summary.isMultiJob(), this.wikiPath, true);
        }
        catch (IOException | TransformerException e) {
            throw new VeraPDFException(e.getMessage(), e);
        }
        this.file.deleteOnExit();
    }
}

