/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.model.tools.xmp.validators;

import java.util.HashMap;
import java.util.Map;
import org.verapdf.model.tools.xmp.ValidatorsContainer;
import org.verapdf.model.tools.xmp.validators.TypeValidator;
import org.verapdf.xmp.impl.VeraPDFXMPNode;

public class StructuredTypeValidator
implements TypeValidator {
    private String childNamespaceURI;
    private Map<String, String> childrenTypes;
    private ValidatorsContainer parentContainer;

    private StructuredTypeValidator(String childNamespaceURI, Map<String, String> childrenTypes, ValidatorsContainer parentContainer) {
        this.childNamespaceURI = childNamespaceURI;
        this.childrenTypes = childrenTypes;
        this.parentContainer = parentContainer;
    }

    public static StructuredTypeValidator fromValues(String childNamespaceURI, Map<String, String> childrenTypes, ValidatorsContainer parentContainer) {
        if (childNamespaceURI == null) {
            throw new IllegalArgumentException("Argument child namespace URI can not be null");
        }
        if (childrenTypes == null || childrenTypes.isEmpty()) {
            throw new IllegalArgumentException("Argument children types can not be null or empty");
        }
        if (parentContainer == null) {
            throw new IllegalArgumentException("Argument parent container can not be null");
        }
        return new StructuredTypeValidator(childNamespaceURI, new HashMap<String, String>(childrenTypes), parentContainer);
    }

    @Override
    public boolean isCorresponding(VeraPDFXMPNode node) {
        if (!node.getOptions().isStruct()) {
            return false;
        }
        for (VeraPDFXMPNode child : node.getChildren()) {
            if (this.childrenTypes.containsKey(child.getName()) && this.childNamespaceURI.equals(child.getNamespaceURI()) && this.parentContainer.validate(child, this.childrenTypes.get(child.getName()))) continue;
            return false;
        }
        return true;
    }
}

