/**
 * This file is part of veraPDF Library core, a module of the veraPDF project.
 * Copyright (c) 2015, veraPDF Consortium <info@verapdf.org>
 * All rights reserved.
 *
 * veraPDF Library core is free software: you can redistribute it and/or modify
 * it under the terms of either:
 *
 * The GNU General public license GPLv3+.
 * You should have received a copy of the GNU General Public License
 * along with veraPDF Library core as the LICENSE.GPL file in the root of the source
 * tree.  If not, see http://www.gnu.org/licenses/ or
 * https://www.gnu.org/licenses/gpl-3.0.en.html.
 *
 * The Mozilla Public License MPLv2+.
 * You should have received a copy of the Mozilla Public License along with
 * veraPDF Library core as the LICENSE.MPL file in the root of the source tree.
 * If a copy of the MPL was not distributed with this file, you can obtain one at
 * http://mozilla.org/MPL/2.0/.
 */
/**
 * 
 */
package org.verapdf.processor.reports;

import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

/**
 * Holds the count of validation jobs and their statuses for a batch job
 * summary.
 * 
 * @author <a href="mailto:carl@openpreservation.org">Carl Wilson</a>
 *         <a href="https://github.com/carlwilson">carlwilson AT github</a>
 * @version 0.1 Created 18 Apr 2017:16:53:46
 */
@XmlJavaTypeAdapter(ValidationBatchSummaryImpl.Adapter.class)
public interface ValidationBatchSummary extends BatchJobSummary {
	/**
	 * @return the number of compliant PDF/As in the batch, that is the number
	 *         of files that passed PDF/A validation.
	 */
	int getCompliantPdfaCount();

	/**
	 * @return the number of non-compliant PDF/As in the batch, that is the
	 *         number of files that failed PDF/A validation.
	 */
	int getNonCompliantPdfaCount();
}
