/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.component;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.verapdf.component.Log;
import org.verapdf.component.LogImpl;
import org.verapdf.component.LogsSummary;
import org.verapdf.core.utils.LogsFileHandler;

@XmlRootElement(name="logs")
public final class LogsSummaryImpl
implements LogsSummary {
    private static final Logger logger = Logger.getLogger(LogsSummaryImpl.class.getCanonicalName());
    private static final String logBeginning = "[log]";
    @XmlAttribute
    private final int logsCount;
    @XmlElement(name="logMessage")
    private final Set<Log> logs;

    private LogsSummaryImpl() {
        this(0, Collections.emptySet());
    }

    private LogsSummaryImpl(int logsCount, Set<Log> logs) {
        this.logsCount = logsCount;
        this.logs = logs;
    }

    @Override
    public int getLogsCount() {
        return this.logsCount;
    }

    @Override
    public Set<Log> getLogs() {
        return this.logs;
    }

    public static LogsSummary getSummary() {
        ArrayList<String> logs = new ArrayList<String>();
        try {
            List<String> loggerMessages = Files.readAllLines(Paths.get(LogsFileHandler.getLogFile(), new String[0]));
            int size = loggerMessages.size() - 1;
            for (int i = 0; i < size; ++i) {
                if (!loggerMessages.get(i).contains(logBeginning)) continue;
                ++i;
                StringBuilder log = new StringBuilder(loggerMessages.get(++i));
                while (i < size && !loggerMessages.get(i + 1).contains(logBeginning)) {
                    log.append('\n').append(loggerMessages.get(++i));
                }
                logs.add(log.toString());
            }
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Failed to get logger messages from file. Warnings report will be empty");
        }
        int logsCount = logs.size();
        if (logsCount == 0) {
            return new LogsSummaryImpl();
        }
        Map occurrencesMap = logs.stream().collect(Collectors.groupingBy(Function.identity(), Collectors.counting()));
        HashSet<Log> logsSet = new HashSet<Log>();
        for (Map.Entry log : occurrencesMap.entrySet()) {
            String[] message = ((String)log.getKey()).split(": ", 2);
            logsSet.add(LogImpl.fromValues(log.getValue().intValue(), message[0], message[1]));
        }
        return new LogsSummaryImpl(logsCount, logsSet);
    }

    static class Adapter
    extends XmlAdapter<LogsSummaryImpl, LogsSummary> {
        Adapter() {
        }

        public LogsSummary unmarshal(LogsSummaryImpl logs) {
            return logs;
        }

        public LogsSummaryImpl marshal(LogsSummary logs) {
            return (LogsSummaryImpl)logs;
        }
    }
}

