/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.features;

import java.util.EnumSet;
import java.util.Objects;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.verapdf.features.FeatureExtractorConfig;
import org.verapdf.features.FeatureObjectType;

@XmlRootElement(name="featuresConfig")
final class FeatureExtractorConfigImpl
implements FeatureExtractorConfig {
    private static final FeatureExtractorConfig DEFAULT = new FeatureExtractorConfigImpl(EnumSet.of(FeatureObjectType.INFORMATION_DICTIONARY));
    @XmlElementWrapper(name="enabledFeatures")
    @XmlElement(name="feature")
    private final EnumSet<FeatureObjectType> enabledFeatures;

    private FeatureExtractorConfigImpl() {
        this(EnumSet.noneOf(FeatureObjectType.class));
    }

    private FeatureExtractorConfigImpl(EnumSet<FeatureObjectType> enabledFeatures) {
        this.enabledFeatures = EnumSet.copyOf(enabledFeatures);
    }

    @Override
    public boolean isFeatureEnabled(FeatureObjectType type) {
        return this.enabledFeatures.contains((Object)type);
    }

    @Override
    public boolean isAnyFeatureEnabled(EnumSet<FeatureObjectType> types) {
        for (FeatureObjectType type : types) {
            if (!this.enabledFeatures.contains((Object)type)) continue;
            return true;
        }
        return false;
    }

    @Override
    public EnumSet<FeatureObjectType> getEnabledFeatures() {
        return this.enabledFeatures;
    }

    static FeatureExtractorConfig defaultInstance() {
        return DEFAULT;
    }

    static FeatureExtractorConfig fromFeatureSet(EnumSet<FeatureObjectType> enabledFeatures) {
        return new FeatureExtractorConfigImpl(enabledFeatures);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.enabledFeatures == null ? 0 : this.enabledFeatures.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FeatureExtractorConfigImpl other = (FeatureExtractorConfigImpl)obj;
        return Objects.equals(this.enabledFeatures, other.enabledFeatures);
    }

    static class Adapter
    extends XmlAdapter<FeatureExtractorConfigImpl, FeatureExtractorConfig> {
        Adapter() {
        }

        public FeatureExtractorConfig unmarshal(FeatureExtractorConfigImpl validationConfigImpl) {
            return validationConfigImpl;
        }

        public FeatureExtractorConfigImpl marshal(FeatureExtractorConfig validationResult) {
            return (FeatureExtractorConfigImpl)validationResult;
        }
    }
}

