/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.features.gf.objects;

import jakarta.xml.bind.DatatypeConverter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.verapdf.as.ASAtom;
import org.verapdf.as.io.ASInputStream;
import org.verapdf.cos.COSObject;
import org.verapdf.features.gf.tools.GFAdapterHelper;
import org.verapdf.features.objects.ColorSpaceFeaturesObjectAdapter;
import org.verapdf.pd.colors.PDCIEDictionaryBased;
import org.verapdf.pd.colors.PDCalGray;
import org.verapdf.pd.colors.PDCalRGB;
import org.verapdf.pd.colors.PDColorSpace;
import org.verapdf.pd.colors.PDDeviceN;
import org.verapdf.pd.colors.PDICCBased;
import org.verapdf.pd.colors.PDIndexed;
import org.verapdf.pd.colors.PDLab;
import org.verapdf.pd.colors.PDSeparation;

public class GFColorSpaceFeaturesObjectAdapter
implements ColorSpaceFeaturesObjectAdapter {
    private static final Logger LOGGER = Logger.getLogger(GFColorSpaceFeaturesObjectAdapter.class.getCanonicalName());
    private PDColorSpace colorSpace;
    private String id;
    private String iccProfileChild;
    private String colorSpaceChild;
    private String lookup;
    private List<String> errors;

    public GFColorSpaceFeaturesObjectAdapter(PDColorSpace colorSpace, String id, String iccProfileChild, String colorSpaceChild) {
        this.colorSpace = colorSpace;
        this.id = id;
        this.iccProfileChild = iccProfileChild;
        this.colorSpaceChild = colorSpaceChild;
        this.init(colorSpace);
    }

    private void init(PDColorSpace colorSpace) {
        ASAtom colorSpaceType = colorSpace.getType();
        if (ASAtom.INDEXED.equals((Object)colorSpaceType)) {
            PDIndexed index = (PDIndexed)colorSpace;
            try (ASInputStream stream = index.getLookup();){
                byte[] lookupData = GFAdapterHelper.inputStreamToByteArray((InputStream)stream);
                if (lookupData != null) {
                    this.lookup = DatatypeConverter.printHexBinary((byte[])lookupData);
                }
            }
            catch (IOException e) {
                LOGGER.log(Level.FINE, e.getMessage(), e);
                this.errors = new ArrayList<String>();
                this.errors.add("Problem during converting lookup value to hex string");
            }
        }
    }

    public String getId() {
        return this.id;
    }

    public String getFamily() {
        if (this.colorSpace == null || this.colorSpace.empty()) {
            return null;
        }
        return GFAdapterHelper.getStringFromASAtom(this.colorSpace.getType());
    }

    public String getColorSpaceChild() {
        return this.colorSpaceChild;
    }

    public String getICCProfileChild() {
        return this.iccProfileChild;
    }

    public double[] getWhitePoint() {
        if (this.colorSpace == null || this.colorSpace.empty()) {
            return null;
        }
        ASAtom colorSpaceType = this.colorSpace.getType();
        if (ASAtom.CALGRAY.equals((Object)colorSpaceType) || ASAtom.CALRGB.equals((Object)colorSpaceType) || ASAtom.LAB.equals((Object)colorSpaceType)) {
            PDCIEDictionaryBased cie = (PDCIEDictionaryBased)this.colorSpace;
            return cie.getWhitePoint();
        }
        return null;
    }

    public double[] getBlackPoint() {
        if (this.colorSpace == null || this.colorSpace.empty()) {
            return null;
        }
        ASAtom colorSpaceType = this.colorSpace.getType();
        if (ASAtom.CALGRAY.equals((Object)colorSpaceType) || ASAtom.CALRGB.equals((Object)colorSpaceType) || ASAtom.LAB.equals((Object)colorSpaceType)) {
            PDCIEDictionaryBased cie = (PDCIEDictionaryBased)this.colorSpace;
            return cie.getBlackPoint();
        }
        return null;
    }

    public Double getCalGrayGamma() {
        if (this.colorSpace == null || this.colorSpace.empty()) {
            return null;
        }
        ASAtom colorSpaceType = this.colorSpace.getType();
        if (ASAtom.CALGRAY.equals((Object)colorSpaceType)) {
            PDCalGray calGray = (PDCalGray)this.colorSpace;
            return calGray.getGamma();
        }
        return null;
    }

    public double[] getCalRGBGamma() {
        if (this.colorSpace == null || this.colorSpace.empty()) {
            return null;
        }
        ASAtom colorSpaceType = this.colorSpace.getType();
        if (ASAtom.CALRGB.equals((Object)colorSpaceType)) {
            PDCalRGB calRGB = (PDCalRGB)this.colorSpace;
            return calRGB.getGamma();
        }
        return null;
    }

    public double[] getMatrix() {
        if (this.colorSpace == null || this.colorSpace.empty()) {
            return null;
        }
        ASAtom colorSpaceType = this.colorSpace.getType();
        if (ASAtom.CALRGB.equals((Object)colorSpaceType)) {
            PDCalRGB calRGB = (PDCalRGB)this.colorSpace;
            return calRGB.getMatrix();
        }
        return null;
    }

    public double[] getLabRange() {
        ASAtom colorSpaceType = this.colorSpace.getType();
        if (ASAtom.LAB.equals((Object)colorSpaceType)) {
            PDLab lab = (PDLab)this.colorSpace;
            return lab.getRange();
        }
        return null;
    }

    public int getNumberOfComponents() {
        if (this.colorSpace == null || this.colorSpace.empty()) {
            return 0;
        }
        ASAtom colorSpaceType = this.colorSpace.getType();
        if (ASAtom.ICCBASED.equals((Object)colorSpaceType)) {
            PDICCBased iccBased = (PDICCBased)this.colorSpace;
            return iccBased.getNumberOfComponents();
        }
        return 0;
    }

    public Long getHival() {
        if (this.colorSpace == null || this.colorSpace.empty()) {
            return null;
        }
        ASAtom colorSpaceType = this.colorSpace.getType();
        if (ASAtom.INDEXED.equals((Object)colorSpaceType)) {
            PDIndexed indexed = (PDIndexed)this.colorSpace;
            return indexed.getHival();
        }
        return null;
    }

    public String getHexEncodedLookup() {
        return this.lookup;
    }

    public String getColorantName() {
        if (this.colorSpace == null || this.colorSpace.empty()) {
            return null;
        }
        ASAtom colorSpaceType = this.colorSpace.getType();
        if (ASAtom.SEPARATION.equals((Object)colorSpaceType)) {
            PDSeparation separation = (PDSeparation)this.colorSpace;
            return GFAdapterHelper.getStringFromCOSObject(separation.getColorantName());
        }
        return null;
    }

    public List<String> getColorantNames() {
        if (this.colorSpace == null || this.colorSpace.empty()) {
            return null;
        }
        ASAtom colorSpaceType = this.colorSpace.getType();
        if (ASAtom.DEVICEN.equals((Object)colorSpaceType)) {
            PDDeviceN deviceN = (PDDeviceN)this.colorSpace;
            List names = deviceN.getNames();
            ArrayList<String> res = new ArrayList<String>(names.size());
            for (COSObject name : names) {
                res.add(GFAdapterHelper.getStringFromCOSObject(name));
            }
            return Collections.unmodifiableList(res);
        }
        return Collections.emptyList();
    }

    public boolean isPDFObjectPresent() {
        return this.colorSpace != null && !this.colorSpace.empty();
    }

    public List<String> getErrors() {
        return this.errors == null ? Collections.emptyList() : Collections.unmodifiableList(this.errors);
    }
}

