/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdfparser;

import java.io.IOException;
import java.io.OutputStream;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSDocument;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSNull;
import org.apache.pdfbox.cos.COSNumber;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.cos.COSObjectKey;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.pdfparser.BaseParser;
import org.apache.pdfbox.pdfparser.EndstreamOutputStream;
import org.apache.pdfbox.pdfparser.PDFObjectStreamParser;
import org.apache.pdfbox.pdfparser.PDFXrefStreamParser;
import org.apache.pdfbox.pdfparser.XrefTrailerResolver;
import org.apache.pdfbox.pdmodel.encryption.SecurityHandler;
import org.apache.pdfbox.util.Charsets;

public class COSParser
extends BaseParser {
    private static final String PDF_HEADER = "%PDF-";
    private static final String FDF_HEADER = "%FDF-";
    private static final String PDF_DEFAULT_VERSION = "1.4";
    private static final String FDF_DEFAULT_VERSION = "1.0";
    private static final char[] XREF_TABLE = new char[]{'x', 'r', 'e', 'f'};
    private static final char[] XREF_STREAM = new char[]{'/', 'X', 'R', 'e', 'f'};
    private static final char[] STARTXREF = new char[]{'s', 't', 'a', 'r', 't', 'x', 'r', 'e', 'f'};
    private static final byte[] ENDSTREAM = new byte[]{101, 110, 100, 115, 116, 114, 101, 97, 109};
    private static final byte[] ENDOBJ = new byte[]{101, 110, 100, 111, 98, 106};
    private static final long MINIMUM_SEARCH_OFFSET = 6L;
    private static final int X = 120;
    private static final int STRMBUFLEN = 2048;
    private final byte[] strmBuf = new byte[2048];
    public static final String SYSPROP_PARSEMINIMAL = "org.apache.pdfbox.pdfparser.nonSequentialPDFParser.parseMinimal";
    public static final String SYSPROP_EOFLOOKUPRANGE = "org.apache.pdfbox.pdfparser.nonSequentialPDFParser.eofLookupRange";
    private static final int DEFAULT_TRAIL_BYTECOUNT = 2048;
    protected static final char[] EOF_MARKER = new char[]{'%', '%', 'E', 'O', 'F'};
    protected static final char[] OBJ_MARKER = new char[]{'o', 'b', 'j'};
    private final int LINEARIZATION_SIZE = 1024;
    private long trailerOffset;
    protected long fileLen;
    private boolean isLenient = true;
    protected boolean initialParseDone = false;
    private Map<COSObjectKey, Long> bfSearchCOSObjectKeyOffsets = null;
    private List<Long> bfSearchXRefTablesOffsets = null;
    private List<Long> bfSearchXRefStreamsOffsets = null;
    protected SecurityHandler securityHandler = null;
    private int readTrailBytes = 2048;
    private static final Log LOG = LogFactory.getLog(COSParser.class);
    protected XrefTrailerResolver xrefTrailerResolver = new XrefTrailerResolver();
    public static final String TMP_FILE_PREFIX = "tmpPDF";
    private boolean inGetLength = false;
    private static final int STREAMCOPYBUFLEN = 8192;
    private final byte[] streamCopyBuf = new byte[8192];

    public void setEOFLookupRange(int byteCount) {
        if (byteCount > 15) {
            this.readTrailBytes = byteCount;
        }
    }

    protected COSDictionary parseXref(long startXRefOffset) throws IOException {
        COSDictionary trailer;
        this.pdfSource.seek(startXRefOffset);
        long startXrefOffset = Math.max(0L, this.parseStartXref());
        long fixedOffset = this.checkXRefOffset(startXrefOffset += this.document.getHeaderOffset());
        if (fixedOffset > -1L) {
            startXrefOffset = fixedOffset;
        }
        this.document.setStartXref(startXrefOffset);
        long prev = startXrefOffset;
        while (prev > 0L) {
            this.pdfSource.seek(prev);
            this.skipSpaces();
            if (this.pdfSource.peek() == 120) {
                this.parseXrefTable(prev);
                this.trailerOffset = this.pdfSource.getPosition();
                while (this.isLenient && this.pdfSource.peek() != 116) {
                    if (this.pdfSource.getPosition() == this.trailerOffset) {
                        LOG.warn("Expected trailer object at position " + this.trailerOffset + ", keep trying");
                    }
                    this.readLine();
                }
                if (!this.parseTrailer()) {
                    throw new IOException("Expected trailer object at position: " + this.pdfSource.getPosition());
                }
                trailer = this.xrefTrailerResolver.getCurrentTrailer();
                if (trailer.containsKey(COSName.XREF_STM)) {
                    int streamOffset = trailer.getInt(COSName.XREF_STM);
                    fixedOffset = this.checkXRefStreamOffset(streamOffset, false);
                    if (fixedOffset > -1L && fixedOffset != (long)streamOffset) {
                        streamOffset = (int)fixedOffset;
                        trailer.setInt(COSName.XREF_STM, streamOffset);
                    }
                    if (streamOffset > 0) {
                        this.pdfSource.seek(streamOffset);
                        this.skipSpaces();
                        this.parseXrefObjStream(prev, false);
                    } else if (this.isLenient) {
                        LOG.error("Skipped XRef stream due to a corrupt offset:" + streamOffset);
                    } else {
                        throw new IOException("Skipped XRef stream due to a corrupt offset:" + streamOffset);
                    }
                }
                if ((prev = (long)trailer.getInt(COSName.PREV)) <= 0L || (fixedOffset = this.checkXRefOffset(prev)) <= -1L || fixedOffset == prev) continue;
                prev = fixedOffset;
                trailer.setLong(COSName.PREV, prev);
                continue;
            }
            if ((prev = this.parseXrefObjStream(prev, true)) <= 0L || (fixedOffset = this.checkXRefOffset(prev)) <= -1L || fixedOffset == prev) continue;
            prev = fixedOffset;
            trailer = this.xrefTrailerResolver.getCurrentTrailer();
            trailer.setLong(COSName.PREV, prev);
        }
        this.xrefTrailerResolver.setStartxref(startXrefOffset);
        trailer = this.xrefTrailerResolver.getTrailer();
        this.document.setTrailer(trailer);
        this.document.setIsXRefStream(XrefTrailerResolver.XRefType.STREAM == this.xrefTrailerResolver.getXrefType());
        if (this.validationParsing) {
            this.strictCheckXrefOffsets();
        } else {
            this.checkXrefOffsets();
        }
        this.document.addXRefTable(this.xrefTrailerResolver.getXrefTable());
        return trailer;
    }

    private long parseXrefObjStream(long objByteOffset, boolean isStandalone) throws IOException {
        this.readObjectNumber();
        this.readGenerationNumber();
        this.readExpectedString(OBJ_MARKER, true);
        COSDictionary dict = this.parseCOSDictionary();
        COSStream xrefStream = this.parseCOSStream(dict);
        this.parseXrefStream(xrefStream, (int)objByteOffset, isStandalone);
        xrefStream.close();
        return dict.getLong(COSName.PREV);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final long getStartxrefOffset() throws IOException {
        long skipBytes;
        byte[] buf;
        try {
            int readBytes;
            int trailByteCount = this.fileLen < (long)this.readTrailBytes ? (int)this.fileLen : this.readTrailBytes;
            buf = new byte[trailByteCount];
            skipBytes = this.fileLen - (long)trailByteCount;
            this.pdfSource.seek(skipBytes);
            for (int off = 0; off < trailByteCount; off += readBytes) {
                readBytes = this.pdfSource.read(buf, off, trailByteCount - off);
                if (readBytes >= 1) continue;
                throw new IOException("No more bytes to read for trailing buffer, but expected: " + (trailByteCount - off));
            }
        }
        finally {
            this.pdfSource.seek(0L);
        }
        int bufOff = this.lastIndexOf(EOF_MARKER, buf, buf.length);
        if (bufOff < 0) {
            if (this.validationParsing) {
                this.document.setPostEOFDataSize(-1);
            }
            if (this.isLenient) {
                bufOff = buf.length;
                LOG.debug("Missing end of file marker '" + new String(EOF_MARKER) + "'");
            } else if (!this.validationParsing) {
                throw new IOException("Missing end of file marker '" + new String(EOF_MARKER) + "'");
            }
        } else if (this.validationParsing) {
            int endOfEOF = bufOff + 5;
            int postEOFDateSize = buf.length - endOfEOF;
            if (postEOFDateSize > 0) {
                if (buf[endOfEOF] == 13) {
                    int nextEOL = endOfEOF + 1;
                    postEOFDateSize = nextEOL < buf.length && buf[nextEOL] == 10 ? (postEOFDateSize -= 2) : --postEOFDateSize;
                } else if (buf[endOfEOF] == 10) {
                    --postEOFDateSize;
                }
            }
            this.document.setPostEOFDataSize(postEOFDateSize);
        }
        bufOff = this.lastIndexOf(STARTXREF, buf, bufOff);
        long startXRefOffset = skipBytes + (long)bufOff;
        if (bufOff < 0) {
            if (this.isLenient) {
                LOG.debug("Can't find offset for startxref");
                return -1L;
            }
            throw new IOException("Missing 'startxref' marker.");
        }
        return startXRefOffset;
    }

    protected int lastIndexOf(char[] pattern, byte[] buf, int endOff) {
        int lastPatternChOff = pattern.length - 1;
        int bufOff = endOff;
        int patOff = lastPatternChOff;
        char lookupCh = pattern[patOff];
        while (--bufOff >= 0) {
            if (buf[bufOff] == lookupCh) {
                if (--patOff < 0) {
                    return bufOff;
                }
                lookupCh = pattern[patOff];
                continue;
            }
            if (patOff >= lastPatternChOff) continue;
            patOff = lastPatternChOff;
            lookupCh = pattern[patOff];
        }
        return -1;
    }

    public boolean isLenient() {
        return this.isLenient;
    }

    public void setLenient(boolean lenient) {
        if (this.initialParseDone) {
            throw new IllegalArgumentException("Cannot change leniency after parsing");
        }
        this.isLenient = lenient;
    }

    private long getObjectId(COSObject obj) {
        return obj.getObjectNumber() << 32 | (long)obj.getGenerationNumber();
    }

    private void addNewToList(Queue<COSBase> toBeParsedList, Collection<COSBase> newObjects, Set<Long> addedObjects) {
        for (COSBase newObject : newObjects) {
            this.addNewToList(toBeParsedList, newObject, addedObjects);
        }
    }

    private void addNewToList(Queue<COSBase> toBeParsedList, COSBase newObject, Set<Long> addedObjects) {
        long objId;
        if (newObject instanceof COSObject && !addedObjects.add(objId = this.getObjectId((COSObject)newObject))) {
            return;
        }
        toBeParsedList.add(newObject);
    }

    protected void parseDictObjects(COSDictionary dict, COSName ... excludeObjects) throws IOException {
        LinkedList<COSBase> toBeParsedList = new LinkedList<COSBase>();
        TreeMap<Long, List<COSObject>> objToBeParsed = new TreeMap<Long, List<COSObject>>();
        HashSet<Long> parsedObjects = new HashSet<Long>();
        HashSet<Long> addedObjects = new HashSet<Long>();
        this.addExcludedToList(excludeObjects, dict, parsedObjects);
        this.addNewToList(toBeParsedList, dict.getValues(), addedObjects);
        while (!toBeParsedList.isEmpty() || !objToBeParsed.isEmpty()) {
            COSBase baseObj;
            while ((baseObj = (COSBase)toBeParsedList.poll()) != null) {
                if (baseObj instanceof COSDictionary) {
                    this.addNewToList(toBeParsedList, ((COSDictionary)baseObj).getValues(), addedObjects);
                    continue;
                }
                if (baseObj instanceof COSArray) {
                    for (COSBase base : (COSArray)baseObj) {
                        this.addNewToList(toBeParsedList, base, addedObjects);
                    }
                    continue;
                }
                if (!(baseObj instanceof COSObject)) continue;
                COSObject obj = (COSObject)baseObj;
                long objId = this.getObjectId(obj);
                COSObjectKey objKey = new COSObjectKey(obj.getObjectNumber(), obj.getGenerationNumber());
                if (parsedObjects.contains(objId)) continue;
                Long fileOffset = this.xrefTrailerResolver.getXrefTable().get(objKey);
                if (fileOffset != null && fileOffset != 0L) {
                    if (fileOffset > 0L) {
                        objToBeParsed.put(fileOffset, Collections.singletonList(obj));
                        continue;
                    }
                    fileOffset = this.xrefTrailerResolver.getXrefTable().get(new COSObjectKey((int)(-fileOffset.longValue()), 0));
                    if (fileOffset == null || fileOffset <= 0L) {
                        throw new IOException("Invalid object stream xref object reference for key '" + objKey + "': " + fileOffset);
                    }
                    ArrayList<COSObject> stmObjects = (ArrayList<COSObject>)objToBeParsed.get(fileOffset);
                    if (stmObjects == null) {
                        stmObjects = new ArrayList<COSObject>();
                        objToBeParsed.put(fileOffset, stmObjects);
                    }
                    stmObjects.add(obj);
                    continue;
                }
                COSObject pdfObject = this.document.getObjectFromPool(objKey);
                pdfObject.setObject(COSNull.NULL);
            }
            if (objToBeParsed.isEmpty()) break;
            for (COSObject obj : (List)objToBeParsed.remove(objToBeParsed.firstKey())) {
                COSBase parsedObj = this.parseObjectDynamically(obj, false);
                obj.setObject(parsedObj);
                this.addNewToList(toBeParsedList, parsedObj, addedObjects);
                parsedObjects.add(this.getObjectId(obj));
            }
        }
    }

    private void addExcludedToList(COSName[] excludeObjects, COSDictionary dict, Set<Long> parsedObjects) {
        if (excludeObjects != null) {
            for (COSName objName : excludeObjects) {
                COSBase baseObj = dict.getItem(objName);
                if (!(baseObj instanceof COSObject)) continue;
                parsedObjects.add(this.getObjectId((COSObject)baseObj));
            }
        }
    }

    protected void parseSuspensionObjects() {
        for (COSObjectKey key : this.document.getXrefTable().keySet()) {
            try {
                long position = this.document.getXrefTable().get(key);
                if (position < 0L) {
                    position = this.xrefTrailerResolver.getXrefTable().get(new COSObjectKey(-position, key.getGeneration()));
                }
                this.pdfSource.seek(position + this.document.getHeaderOffset());
                COSObject suspensionObject = this.document.getObjectFromPool(key);
                this.parseObjectDynamically(suspensionObject, false);
            }
            catch (IOException e) {
                LOG.error(e);
            }
        }
    }

    protected final COSBase parseObjectDynamically(COSObject obj, boolean requireExistingNotCompressedObj) throws IOException {
        return this.parseObjectDynamically(obj.getObjectNumber(), obj.getGenerationNumber(), requireExistingNotCompressedObj);
    }

    protected COSBase parseObjectDynamically(long objNr, int objGenNr, boolean requireExistingNotCompressedObj) throws IOException {
        COSObjectKey objKey = new COSObjectKey(objNr, objGenNr);
        COSObject pdfObject = this.document.getObjectFromPool(objKey);
        if (pdfObject.getObject() == null) {
            Long offsetOrObjstmObNr = this.xrefTrailerResolver.getXrefTable().get(objKey);
            offsetOrObjstmObNr = offsetOrObjstmObNr + this.document.getHeaderOffset();
            if (requireExistingNotCompressedObj && (offsetOrObjstmObNr == null || offsetOrObjstmObNr <= 0L)) {
                throw new IOException("Object must be defined and must not be compressed object: " + objKey.getNumber() + ":" + objKey.getGeneration());
            }
            if (offsetOrObjstmObNr == null) {
                pdfObject.setObject(COSNull.NULL);
            } else if (offsetOrObjstmObNr > 0L) {
                this.parseFileObject(offsetOrObjstmObNr, objKey, objNr, objGenNr, pdfObject);
            } else {
                this.parseObjectStream((int)(-offsetOrObjstmObNr.longValue()));
            }
        }
        return pdfObject.getObject();
    }

    private void parseFileObject(Long offsetOrObjstmObNr, COSObjectKey objKey, long objNr, int objGenNr, COSObject pdfObject) throws IOException {
        String endObjectKey;
        this.pdfSource.seek(offsetOrObjstmObNr);
        if (this.validationParsing) {
            this.skipSpaces();
            this.pdfSource.seek(this.pdfSource.getPosition() - 1L);
            if (!this.isEOL(this.pdfSource.read())) {
                pdfObject.setHeaderOfObjectComplyPDFA(Boolean.FALSE);
            }
        }
        long readObjNr = this.readObjectNumber();
        if (this.validationParsing && (this.pdfSource.read() != 32 || this.skipSpaces() > 0)) {
            pdfObject.setHeaderFormatComplyPDFA(Boolean.FALSE);
        }
        int readObjGen = this.readGenerationNumber();
        if (this.validationParsing && (this.pdfSource.read() != 32 || this.skipSpaces() > 0)) {
            pdfObject.setHeaderFormatComplyPDFA(Boolean.FALSE);
        }
        this.readExpectedString(OBJ_MARKER, !this.validationParsing);
        if (readObjNr != objKey.getNumber() || readObjGen != objKey.getGeneration()) {
            String message = "XREF for " + objKey.getNumber() + ":" + objKey.getGeneration() + " points to wrong object: " + readObjNr + ":" + readObjGen;
            if (this.validationParsing) {
                LOG.error(message);
                pdfObject.setObject(COSNull.NULL);
                return;
            }
            throw new IOException(message);
        }
        if (this.validationParsing && !this.isEOL()) {
            pdfObject.setHeaderOfObjectComplyPDFA(Boolean.FALSE);
        }
        COSBase pb = this.parseDirObject();
        int eolMarker = 0;
        if (this.validationParsing) {
            this.skipSpaces();
            this.pdfSource.seek(this.pdfSource.getPosition() - 1L);
            eolMarker = this.pdfSource.read();
        }
        if ((endObjectKey = this.readString()).equals("stream")) {
            COSStream stream;
            this.pdfSource.rewind(endObjectKey.getBytes(Charsets.ISO_8859_1).length);
            if (pb instanceof COSDictionary) {
                stream = this.parseCOSStream((COSDictionary)pb);
                if (this.securityHandler != null) {
                    this.securityHandler.decryptStream(stream, objNr, objGenNr);
                }
            } else {
                throw new IOException("Stream not preceded by dictionary (offset: " + offsetOrObjstmObNr + ").");
            }
            pb = stream;
            this.skipSpaces();
            if (this.validationParsing) {
                this.pdfSource.rewind(1);
                eolMarker = this.pdfSource.read();
                endObjectKey = this.readLineWithoutWhitespacesSkip();
            } else {
                endObjectKey = this.readLine();
            }
            if (!endObjectKey.startsWith("endobj") && endObjectKey.startsWith("endstream") && (endObjectKey = endObjectKey.substring(9).trim()).length() == 0) {
                if (this.validationParsing) {
                    this.skipSpaces();
                    endObjectKey = this.readLineWithoutWhitespacesSkip();
                    eolMarker = this.pdfSource.read();
                } else {
                    endObjectKey = this.readLine();
                }
            }
        } else if (this.securityHandler != null) {
            this.securityHandler.decrypt(pb, objNr, objGenNr);
        }
        if (this.validationParsing && !this.isEOL(eolMarker)) {
            pdfObject.setEndOfObjectComplyPDFA(Boolean.FALSE);
        }
        pdfObject.setObject(pb);
        if (!endObjectKey.startsWith("endobj")) {
            if (this.isLenient) {
                LOG.warn("Object (" + readObjNr + ":" + readObjGen + ") at offset " + offsetOrObjstmObNr + " does not end with 'endobj' but with '" + endObjectKey + "'");
            } else {
                throw new IOException("Object (" + readObjNr + ":" + readObjGen + ") at offset " + offsetOrObjstmObNr + " does not end with 'endobj' but with '" + endObjectKey + "'");
            }
        }
        if (!this.isEOL(eolMarker = this.pdfSource.read())) {
            pdfObject.setEndOfObjectComplyPDFA(Boolean.FALSE);
            this.pdfSource.rewind(1);
        }
    }

    private void parseObjectStream(int objstmObjNr) throws IOException {
        COSBase objstmBaseObj = this.parseObjectDynamically(objstmObjNr, 0, true);
        if (objstmBaseObj instanceof COSStream) {
            PDFObjectStreamParser parser = new PDFObjectStreamParser((COSStream)objstmBaseObj, this.document);
            parser.parse();
            Set<Long> refObjNrs = this.xrefTrailerResolver.getContainedObjectNumbers(objstmObjNr);
            for (COSObject next : parser.getObjects()) {
                COSObjectKey stmObjKey = new COSObjectKey(next);
                if (!refObjNrs.contains(stmObjKey.getNumber())) continue;
                COSObject stmObj = this.document.getObjectFromPool(stmObjKey);
                stmObj.setObject(next.getObject());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private COSNumber getLength(COSBase lengthBaseObj) throws IOException {
        COSNumber retVal;
        block10: {
            if (lengthBaseObj == null) {
                return null;
            }
            if (this.inGetLength) {
                throw new IOException("Loop while reading length from " + lengthBaseObj);
            }
            retVal = null;
            try {
                this.inGetLength = true;
                if (lengthBaseObj instanceof COSNumber) {
                    retVal = (COSNumber)lengthBaseObj;
                    break block10;
                }
                if (lengthBaseObj instanceof COSObject) {
                    COSObject lengthObj = (COSObject)lengthBaseObj;
                    if (lengthObj.getObject() == null) {
                        long curFileOffset = this.pdfSource.getPosition();
                        this.parseObjectDynamically(lengthObj, true);
                        this.pdfSource.seek(curFileOffset);
                        if (lengthObj.getObject() == null) {
                            throw new IOException("Length object content was not read.");
                        }
                    }
                    if (!(lengthObj.getObject() instanceof COSNumber)) {
                        throw new IOException("Wrong type of referenced length object " + lengthObj + ": " + lengthObj.getObject().getClass().getSimpleName());
                    }
                    retVal = (COSNumber)lengthObj.getObject();
                    break block10;
                }
                throw new IOException("Wrong type of length object: " + lengthBaseObj.getClass().getSimpleName());
            }
            finally {
                this.inGetLength = false;
            }
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected COSStream parseCOSStream(COSDictionary dic) throws IOException {
        COSStream stream = this.document.createCOSStream(dic);
        OutputStream out = null;
        try {
            String endStream;
            this.readString();
            if (this.validationParsing) {
                this.checkStreamSpacings(stream);
                stream.setOriginLength(this.pdfSource.getPosition());
            }
            this.skipWhiteSpaces();
            COSNumber streamLengthObj = this.getLength(dic.getItem(COSName.LENGTH));
            if (streamLengthObj == null) {
                if (this.isLenient) {
                    LOG.warn("The stream doesn't provide any stream length, using fallback readUntilEnd, at offset " + this.pdfSource.getPosition());
                } else {
                    throw new IOException("Missing length for stream.");
                }
            }
            if (streamLengthObj != null && this.validateStreamLength(streamLengthObj.longValue())) {
                out = stream.createFilteredStream(streamLengthObj);
                this.readValidStream(out, streamLengthObj);
            } else {
                out = stream.createFilteredStream();
                this.readUntilEndStream(new EndstreamOutputStream(out));
            }
            if (this.validationParsing) {
                this.checkEndStreamSpacings(stream, streamLengthObj.longValue());
            }
            if ((endStream = this.readString()).equals("endobj") && this.isLenient) {
                LOG.warn("stream ends with 'endobj' instead of 'endstream' at offset " + this.pdfSource.getPosition());
                if (this.validationParsing) {
                    stream.setEndstreamKeywordEOLCompliant(Boolean.FALSE);
                }
                this.pdfSource.rewind(ENDOBJ.length);
            } else if (endStream.length() > 9 && this.isLenient && endStream.substring(0, 9).equals("endstream")) {
                LOG.warn("stream ends with '" + endStream + "' instead of 'endstream' at offset " + this.pdfSource.getPosition());
                if (this.validationParsing) {
                    stream.setEndstreamKeywordEOLCompliant(Boolean.FALSE);
                }
                this.pdfSource.rewind(endStream.substring(9).getBytes(Charsets.ISO_8859_1).length);
            } else if (!endStream.equals("endstream")) {
                throw new IOException("Error reading stream, expected='endstream' actual='" + endStream + "' at offset " + this.pdfSource.getPosition());
            }
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
        return stream;
    }

    private void checkStreamSpacings(COSStream stream) throws IOException {
        int whiteSpace = this.pdfSource.read();
        if (whiteSpace == 13) {
            whiteSpace = this.pdfSource.read();
            if (whiteSpace != 10) {
                stream.setStreamKeywordCRLFCompliant(Boolean.FALSE);
                this.pdfSource.rewind(1);
            }
        } else if (whiteSpace != 10) {
            LOG.warn("Stream at " + this.pdfSource.getPosition() + " offset has no EOL marker.");
            stream.setStreamKeywordCRLFCompliant(Boolean.FALSE);
            this.pdfSource.rewind(1);
        }
    }

    private void checkEndStreamSpacings(COSStream stream, long expectedLength) throws IOException {
        this.skipSpaces();
        byte eolCount = 0;
        long approximateLength = this.pdfSource.getPosition() - stream.getOriginLength();
        long diff = approximateLength - expectedLength;
        this.pdfSource.rewind(2);
        int firstSymbol = this.pdfSource.read();
        int secondSymbol = this.pdfSource.read();
        if (secondSymbol == 10) {
            eolCount = firstSymbol == 13 ? (byte)(diff == 1L ? 1 : 2) : (byte)1;
        } else if (secondSymbol == 13) {
            eolCount = 1;
        } else {
            LOG.warn("End of stream at " + this.pdfSource.getPosition() + " offset has no contain EOL marker.");
            stream.setEndstreamKeywordEOLCompliant(Boolean.FALSE);
        }
        stream.setOriginLength(approximateLength - (long)eolCount);
    }

    private void readUntilEndStream(OutputStream out) throws IOException {
        int bufSize;
        int charMatchCount = 0;
        byte[] keyw = ENDSTREAM;
        int quickTestOffset = 5;
        while ((bufSize = this.pdfSource.read(this.strmBuf, charMatchCount, 2048 - charMatchCount)) > 0) {
            int contentBytes;
            int bIdx;
            int maxQuicktestIdx = (bufSize += charMatchCount) - 5;
            for (bIdx = charMatchCount; bIdx < bufSize; ++bIdx) {
                byte ch;
                int quickTestIdx = bIdx + 5;
                if (charMatchCount == 0 && quickTestIdx < maxQuicktestIdx && ((ch = this.strmBuf[quickTestIdx]) > 116 || ch < 97)) {
                    bIdx = quickTestIdx;
                    continue;
                }
                ch = this.strmBuf[bIdx];
                if (ch == keyw[charMatchCount]) {
                    if (++charMatchCount != keyw.length) continue;
                    ++bIdx;
                    break;
                }
                if (charMatchCount == 3 && ch == ENDOBJ[charMatchCount]) {
                    keyw = ENDOBJ;
                    ++charMatchCount;
                    continue;
                }
                charMatchCount = ch == 101 ? 1 : (ch == 110 && charMatchCount == 7 ? 2 : 0);
                keyw = ENDSTREAM;
            }
            if ((contentBytes = Math.max(0, bIdx - charMatchCount)) > 0) {
                out.write(this.strmBuf, 0, contentBytes);
            }
            if (charMatchCount == keyw.length) {
                this.pdfSource.rewind(bufSize - contentBytes);
                break;
            }
            System.arraycopy(keyw, 0, this.strmBuf, 0, charMatchCount);
        }
        out.flush();
    }

    private void readValidStream(OutputStream out, COSNumber streamLengthObj) throws IOException {
        int readBytes;
        for (long remainBytes = streamLengthObj.longValue(); remainBytes > 0L; remainBytes -= (long)readBytes) {
            int chunk = remainBytes > 8192L ? 8192 : (int)remainBytes;
            readBytes = this.pdfSource.read(this.streamCopyBuf, 0, chunk);
            if (readBytes <= 0) {
                throw new IOException("read error at offset " + this.pdfSource.getPosition() + ": expected " + chunk + " bytes, but read() returns " + readBytes);
            }
            out.write(this.streamCopyBuf, 0, readBytes);
        }
    }

    private boolean validateStreamLength(long streamLength) throws IOException {
        boolean streamLengthIsValid = true;
        long originOffset = this.pdfSource.getPosition();
        long expectedEndOfStream = originOffset + streamLength;
        if (expectedEndOfStream > this.fileLen) {
            streamLengthIsValid = false;
            LOG.warn("The end of the stream is out of range, using workaround to read the stream, stream start position: " + originOffset + ", length: " + streamLength + ", expected end position: " + expectedEndOfStream);
        } else {
            this.pdfSource.seek(expectedEndOfStream);
            this.skipSpaces();
            if (!this.isString(ENDSTREAM)) {
                streamLengthIsValid = false;
                LOG.warn("The end of the stream doesn't point to the correct offset, using workaround to read the stream, stream start position: " + originOffset + ", length: " + streamLength + ", expected end position: " + expectedEndOfStream);
            }
            this.pdfSource.seek(originOffset);
        }
        return streamLengthIsValid;
    }

    private long checkXRefOffset(long startXRefOffset) throws IOException {
        long fixedOffset;
        if (!this.isLenient) {
            return startXRefOffset;
        }
        this.pdfSource.seek(startXRefOffset);
        if (this.pdfSource.peek() == 120 && this.isString(XREF_TABLE)) {
            return startXRefOffset;
        }
        if (startXRefOffset > 0L && (fixedOffset = this.checkXRefStreamOffset(startXRefOffset, true)) > -1L) {
            return fixedOffset;
        }
        return this.calculateXRefFixedOffset(startXRefOffset, false);
    }

    private long checkXRefStreamOffset(long startXRefOffset, boolean checkOnly) throws IOException {
        if (!this.isLenient || startXRefOffset == 0L) {
            return startXRefOffset;
        }
        this.pdfSource.seek(startXRefOffset - 1L);
        int nextValue = this.pdfSource.read();
        if (this.isWhitespace(nextValue) && this.isDigit()) {
            try {
                this.readObjectNumber();
                this.readGenerationNumber();
                this.readExpectedString(OBJ_MARKER, true);
                this.pdfSource.seek(startXRefOffset);
                return startXRefOffset;
            }
            catch (IOException exception) {
                this.pdfSource.seek(startXRefOffset);
            }
        }
        return checkOnly ? -1L : this.calculateXRefFixedOffset(startXRefOffset, true);
    }

    private long calculateXRefFixedOffset(long objectOffset, boolean streamsOnly) throws IOException {
        if (objectOffset < 0L) {
            LOG.error("Invalid object offset " + objectOffset + " when searching for a xref table/stream");
            return 0L;
        }
        long newOffset = this.bfSearchForXRef(objectOffset, streamsOnly);
        if (newOffset > -1L) {
            LOG.debug("Fixed reference for xref table/stream " + objectOffset + " -> " + newOffset);
            return newOffset;
        }
        LOG.error("Can't find the object axref table/stream at offset " + objectOffset);
        return 0L;
    }

    private void checkXrefOffsets() throws IOException {
        if (!this.isLenient) {
            return;
        }
        Map<COSObjectKey, Long> xrefOffset = this.xrefTrailerResolver.getXrefTable();
        if (xrefOffset != null) {
            boolean bruteForceSearch = false;
            for (Map.Entry<COSObjectKey, Long> objectEntry : xrefOffset.entrySet()) {
                COSObjectKey objectKey = objectEntry.getKey();
                Long objectOffset = objectEntry.getValue();
                if (objectOffset == null || objectOffset < 0L || this.checkObjectKeys(objectKey, objectOffset)) continue;
                LOG.debug("Stop checking xref offsets as at least one couldn't be dereferenced");
                bruteForceSearch = true;
                break;
            }
            if (bruteForceSearch) {
                this.bfSearchForObjects();
                if (this.bfSearchCOSObjectKeyOffsets != null && !this.bfSearchCOSObjectKeyOffsets.isEmpty()) {
                    LOG.debug("Replaced read xref table with the results of a brute force search");
                    xrefOffset.putAll(this.bfSearchCOSObjectKeyOffsets);
                }
            }
        }
    }

    private void strictCheckXrefOffsets() throws IOException {
        Map<COSObjectKey, Long> xrefOffset = this.xrefTrailerResolver.getXrefTable();
        if (xrefOffset != null) {
            ArrayList<COSObjectKey> objectsToRemove = new ArrayList<COSObjectKey>();
            for (Map.Entry<COSObjectKey, Long> objectEntry : xrefOffset.entrySet()) {
                COSObjectKey objectKey = objectEntry.getKey();
                Long objectOffset = objectEntry.getValue();
                if ((objectOffset = Long.valueOf(objectOffset + this.document.getHeaderOffset())) == null || objectOffset < 0L || this.checkObjectKeys(objectKey, objectOffset)) continue;
                objectsToRemove.add(objectKey);
                LOG.warn("Object " + objectKey + " has invalid offset");
            }
            for (COSObjectKey key : objectsToRemove) {
                xrefOffset.remove(key);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkObjectKeys(COSObjectKey objectKey, long offset) throws IOException {
        if (offset < 6L) {
            return false;
        }
        long objectNr = objectKey.getNumber();
        int objectGen = objectKey.getGeneration();
        long originOffset = this.pdfSource.getPosition();
        this.pdfSource.seek(offset);
        String objectString = this.createObjectString(objectNr, objectGen);
        try {
            if (this.validationParsing ? this.isObjHeader(objectString) : this.isString(objectString.getBytes(Charsets.ISO_8859_1))) {
                this.pdfSource.seek(originOffset);
                boolean bl = true;
                return bl;
            }
        }
        catch (IOException iOException) {
        }
        finally {
            this.pdfSource.seek(originOffset);
        }
        return false;
    }

    private String createObjectString(long objectID, int genID) {
        return Long.toString(objectID) + " " + Integer.toString(genID) + " obj";
    }

    private void bfSearchForObjects() throws IOException {
        if (this.bfSearchCOSObjectKeyOffsets == null) {
            this.bfSearchCOSObjectKeyOffsets = new HashMap<COSObjectKey, Long>();
            long originOffset = this.pdfSource.getPosition();
            long currentOffset = 6L;
            String objString = " obj";
            char[] string = objString.toCharArray();
            do {
                this.pdfSource.seek(currentOffset);
                if (this.isString(string)) {
                    long tempOffset = currentOffset - 1L;
                    this.pdfSource.seek(tempOffset);
                    int genID = this.pdfSource.peek();
                    if (COSParser.isDigit(genID)) {
                        genID -= 48;
                        this.pdfSource.seek(--tempOffset);
                        if (this.isSpace()) {
                            while (tempOffset > 6L && this.isSpace()) {
                                this.pdfSource.seek(--tempOffset);
                            }
                            int length = 0;
                            while (tempOffset > 6L && this.isDigit()) {
                                this.pdfSource.seek(--tempOffset);
                                ++length;
                            }
                            if (length > 0) {
                                Long objectID;
                                this.pdfSource.read();
                                byte[] objIDBytes = this.pdfSource.readFully(length);
                                String objIdString = new String(objIDBytes, 0, objIDBytes.length, Charsets.ISO_8859_1);
                                try {
                                    objectID = Long.valueOf(objIdString);
                                }
                                catch (NumberFormatException exception) {
                                    objectID = null;
                                }
                                if (objectID != null) {
                                    this.bfSearchCOSObjectKeyOffsets.put(new COSObjectKey(objectID, genID), tempOffset + 1L);
                                }
                            }
                        }
                    }
                }
                ++currentOffset;
            } while (!this.pdfSource.isEOF());
            this.pdfSource.seek(originOffset);
        }
    }

    private long bfSearchForXRef(long xrefOffset, boolean streamsOnly) throws IOException {
        long newOffset = -1L;
        long newOffsetTable = -1L;
        long newOffsetStream = -1L;
        if (!streamsOnly) {
            this.bfSearchForXRefTables();
        }
        this.bfSearchForXRefStreams();
        if (!streamsOnly && this.bfSearchXRefTablesOffsets != null) {
            newOffsetTable = this.searchNearestValue(this.bfSearchXRefTablesOffsets, xrefOffset);
        }
        if (this.bfSearchXRefStreamsOffsets != null) {
            newOffsetStream = this.searchNearestValue(this.bfSearchXRefStreamsOffsets, xrefOffset);
        }
        if (newOffsetTable > -1L && newOffsetStream > -1L) {
            long differenceTable = xrefOffset - newOffsetTable;
            long differenceStream = xrefOffset - newOffsetStream;
            if (Math.abs(differenceTable) > Math.abs(differenceStream)) {
                newOffset = differenceStream;
                this.bfSearchXRefStreamsOffsets.remove(newOffsetStream);
            } else {
                newOffset = differenceTable;
                this.bfSearchXRefTablesOffsets.remove(newOffsetTable);
            }
        } else if (newOffsetTable > -1L) {
            newOffset = newOffsetTable;
            this.bfSearchXRefTablesOffsets.remove(newOffsetTable);
        } else if (newOffsetStream > -1L) {
            newOffset = newOffsetStream;
            this.bfSearchXRefStreamsOffsets.remove(newOffsetStream);
        }
        return newOffset;
    }

    private long searchNearestValue(List<Long> values, long offset) {
        long newValue = -1L;
        long currentDifference = -1L;
        int currentOffsetIndex = -1;
        int numberOfOffsets = values.size();
        for (int i = 0; i < numberOfOffsets; ++i) {
            long newDifference = offset - values.get(i);
            if (currentDifference != -1L && Math.abs(currentDifference) <= Math.abs(newDifference)) continue;
            currentDifference = newDifference;
            currentOffsetIndex = i;
        }
        if (currentOffsetIndex > -1) {
            newValue = values.get(currentOffsetIndex);
        }
        return newValue;
    }

    private void bfSearchForXRefTables() throws IOException {
        if (this.bfSearchXRefTablesOffsets == null) {
            this.bfSearchXRefTablesOffsets = new Vector<Long>();
            long originOffset = this.pdfSource.getPosition();
            this.pdfSource.seek(6L);
            while (!this.pdfSource.isEOF()) {
                if (this.isString(XREF_TABLE)) {
                    long newOffset = this.pdfSource.getPosition();
                    this.pdfSource.seek(newOffset - 1L);
                    if (this.isWhitespace()) {
                        this.bfSearchXRefTablesOffsets.add(newOffset);
                    }
                    this.pdfSource.seek(newOffset + 4L);
                }
                this.pdfSource.read();
            }
            this.pdfSource.seek(originOffset);
        }
    }

    private void bfSearchForXRefStreams() throws IOException {
        if (this.bfSearchXRefStreamsOffsets == null) {
            this.bfSearchXRefStreamsOffsets = new Vector<Long>();
            long originOffset = this.pdfSource.getPosition();
            this.pdfSource.seek(6L);
            String objString = " obj";
            char[] string = objString.toCharArray();
            while (!this.pdfSource.isEOF()) {
                if (this.isString(XREF_STREAM)) {
                    long newOffset = -1L;
                    long xrefOffset = this.pdfSource.getPosition();
                    boolean objFound = false;
                    block1: for (int i = 1; i < 30 && !objFound; ++i) {
                        long currentOffset = xrefOffset - (long)(i * 10);
                        if (currentOffset <= 0L) continue;
                        this.pdfSource.seek(currentOffset);
                        for (int j = 0; j < 10; ++j) {
                            if (this.isString(string)) {
                                long tempOffset = currentOffset - 1L;
                                this.pdfSource.seek(tempOffset);
                                int genID = this.pdfSource.peek();
                                if (COSParser.isDigit(genID)) {
                                    genID -= 48;
                                    this.pdfSource.seek(--tempOffset);
                                    if (this.isSpace()) {
                                        int length = 0;
                                        this.pdfSource.seek(--tempOffset);
                                        while (tempOffset > 6L && this.isDigit()) {
                                            this.pdfSource.seek(--tempOffset);
                                            ++length;
                                        }
                                        if (length > 0) {
                                            this.pdfSource.read();
                                            newOffset = this.pdfSource.getPosition();
                                        }
                                    }
                                }
                                LOG.debug("Fixed reference for xref stream " + xrefOffset + " -> " + newOffset);
                                objFound = true;
                                continue block1;
                            }
                            ++currentOffset;
                            this.pdfSource.read();
                        }
                    }
                    if (newOffset > -1L) {
                        this.bfSearchXRefStreamsOffsets.add(newOffset);
                    }
                    this.pdfSource.seek(xrefOffset + 5L);
                }
                this.pdfSource.read();
            }
            this.pdfSource.seek(originOffset);
        }
    }

    protected final COSDictionary rebuildTrailer() throws IOException {
        COSDictionary trailer = null;
        this.bfSearchForObjects();
        if (this.bfSearchCOSObjectKeyOffsets != null) {
            this.xrefTrailerResolver.nextXrefObj(0L, XrefTrailerResolver.XRefType.TABLE);
            for (COSObjectKey objectKey : this.bfSearchCOSObjectKeyOffsets.keySet()) {
                this.xrefTrailerResolver.setXRef(objectKey, this.bfSearchCOSObjectKeyOffsets.get(objectKey));
            }
            this.xrefTrailerResolver.setStartxref(0L);
            trailer = this.xrefTrailerResolver.getTrailer();
            this.getDocument().setTrailer(trailer);
            for (COSObjectKey key : this.bfSearchCOSObjectKeyOffsets.keySet()) {
                Long offset = this.bfSearchCOSObjectKeyOffsets.get(key);
                this.pdfSource.seek(offset);
                this.readObjectNumber();
                this.readGenerationNumber();
                this.readExpectedString(OBJ_MARKER, true);
                try {
                    COSDictionary dictionary = this.parseCOSDictionary();
                    if (dictionary == null) continue;
                    if (COSName.CATALOG.equals(dictionary.getCOSName(COSName.TYPE))) {
                        trailer.setItem(COSName.ROOT, (COSBase)this.document.getObjectFromPool(key));
                        continue;
                    }
                    if (!dictionary.containsKey(COSName.TITLE) && !dictionary.containsKey(COSName.AUTHOR) && !dictionary.containsKey(COSName.SUBJECT) && !dictionary.containsKey(COSName.KEYWORDS) && !dictionary.containsKey(COSName.CREATOR) && !dictionary.containsKey(COSName.PRODUCER) && !dictionary.containsKey(COSName.CREATION_DATE)) continue;
                    trailer.setItem(COSName.INFO, (COSBase)this.document.getObjectFromPool(key));
                }
                catch (IOException exception) {
                    LOG.debug("Skipped object " + key + ", either it's corrupt or not a dictionary");
                }
            }
        }
        return trailer;
    }

    private long parseStartXref() throws IOException {
        long startXref = -1L;
        if (this.isString(STARTXREF)) {
            this.readString();
            this.skipSpaces();
            startXref = this.readLong();
        }
        return startXref;
    }

    private boolean isString(byte[] string) throws IOException {
        boolean bytesMatching = false;
        if (this.pdfSource.peek() == string[0]) {
            int numberOfBytes;
            int readMore;
            int length = string.length;
            byte[] bytesRead = new byte[length];
            for (numberOfBytes = this.pdfSource.read(bytesRead, 0, length); numberOfBytes < length && (readMore = this.pdfSource.read(bytesRead, numberOfBytes, length - numberOfBytes)) >= 0; numberOfBytes += readMore) {
            }
            if (Arrays.equals(string, bytesRead)) {
                bytesMatching = true;
            }
            this.pdfSource.rewind(numberOfBytes);
        }
        return bytesMatching;
    }

    private boolean isObjHeader(String expectedObjHeader) throws IOException {
        long objN = this.readObjectNumber();
        int genN = this.readGenerationNumber();
        this.readExpectedString(OBJ_MARKER, true);
        String actualObjHeader = this.createObjectString(objN, genN);
        return actualObjHeader.equals(expectedObjHeader);
    }

    private boolean isString(char[] string) throws IOException {
        boolean bytesMatching = true;
        long originOffset = this.pdfSource.getPosition();
        for (char c : string) {
            if (this.pdfSource.read() == c) continue;
            bytesMatching = false;
        }
        this.pdfSource.seek(originOffset);
        return bytesMatching;
    }

    private boolean parseTrailer() throws IOException {
        if (this.pdfSource.peek() != 116) {
            return false;
        }
        long currentOffset = this.pdfSource.getPosition();
        String nextLine = this.readLine();
        if (!nextLine.trim().equals("trailer")) {
            if (nextLine.startsWith("trailer")) {
                int len = "trailer".length();
                this.pdfSource.seek(currentOffset + (long)len);
            } else {
                return false;
            }
        }
        this.skipSpaces();
        COSDictionary parsedTrailer = this.parseCOSDictionary();
        this.xrefTrailerResolver.setTrailer(parsedTrailer);
        this.skipSpaces();
        return true;
    }

    protected boolean parsePDFHeader() throws IOException {
        return this.parseHeader(PDF_HEADER, PDF_DEFAULT_VERSION);
    }

    protected boolean parseFDFHeader() throws IOException {
        return this.parseHeader(FDF_HEADER, FDF_DEFAULT_VERSION);
    }

    private boolean parseHeader(String headerMarker, String defaultVersion) throws IOException {
        String header = this.readLine();
        if (!header.contains(headerMarker)) {
            header = this.readLine();
            while (!(header.contains(headerMarker) || header.contains(headerMarker.substring(1)) || header.length() > 0 && Character.isDigit(header.charAt(0)))) {
                header = this.readLine();
            }
        }
        do {
            this.pdfSource.rewind(1);
        } while (this.isEOL());
        this.pdfSource.read();
        int headerStart = header.indexOf(headerMarker);
        long headerOffset = this.pdfSource.getPosition() - (long)header.length() + (long)headerStart;
        this.document.setHeaderOffset(headerOffset);
        this.document.setHeader(header);
        this.skipWhiteSpaces();
        if (!header.contains(headerMarker)) {
            this.pdfSource.seek(0L);
            if (!this.validationParsing) {
                return false;
            }
        }
        if (headerStart > 0) {
            header = header.substring(headerStart, header.length());
        }
        if (header.startsWith(headerMarker) && !header.matches(headerMarker + "\\d.\\d")) {
            if (header.length() < headerMarker.length() + 3) {
                header = headerMarker + defaultVersion;
                LOG.warn("No version found, set to " + defaultVersion + " as default.");
            } else if (this.validationParsing) {
                Integer pos = null;
                if (header.indexOf(37) > -1) {
                    pos = header.indexOf(37);
                } else if (header.contains("PDF-")) {
                    pos = header.indexOf("PDF-");
                }
                if (pos != null) {
                    Integer length = Math.min(8, header.substring(pos).length());
                    header = header.substring(pos, pos + length);
                }
            } else {
                String headerGarbage = header.substring(headerMarker.length() + 3, header.length()) + "\n";
                header = header.substring(0, headerMarker.length() + 3);
                this.pdfSource.rewind(headerGarbage.getBytes(Charsets.ISO_8859_1).length);
            }
        }
        float headerVersion = 1.4f;
        try {
            String[] headerParts = header.split("-");
            if (headerParts.length == 2) {
                headerVersion = Float.parseFloat(headerParts[1]);
            }
        }
        catch (NumberFormatException exception) {
            LOG.warn("Can't parse the header version.", exception);
        }
        this.document.setVersion(headerVersion);
        if (this.validationParsing) {
            this.checkComment();
        }
        this.pdfSource.seek(0L);
        return true;
    }

    private void checkComment() throws IOException {
        String comment = this.readLine();
        boolean isValidComment = true;
        if (comment != null && !comment.isEmpty()) {
            int pos;
            if (comment.charAt(0) != '%') {
                isValidComment = false;
            }
            int n = pos = comment.indexOf(37) > -1 ? comment.indexOf(37) + 1 : 0;
            if (comment.substring(pos).length() < 4) {
                isValidComment = false;
            }
        } else {
            isValidComment = false;
        }
        if (isValidComment) {
            this.setBinaryHeaderBytes(comment.charAt(1), comment.charAt(2), comment.charAt(3), comment.charAt(4));
        } else {
            this.setBinaryHeaderBytes(-1, -1, -1, -1);
        }
    }

    private void setBinaryHeaderBytes(int first, int second, int third, int fourth) {
        this.document.setHeaderCommentByte1(first);
        this.document.setHeaderCommentByte2(second);
        this.document.setHeaderCommentByte3(third);
        this.document.setHeaderCommentByte4(fourth);
    }

    protected boolean parseXrefTable(long startByteOffset) throws IOException {
        int space;
        if (this.pdfSource.peek() != 120) {
            return false;
        }
        String xref = this.readString();
        if (!xref.trim().equals("xref")) {
            return false;
        }
        if (this.validationParsing) {
            space = this.pdfSource.read();
            if (space == 13) {
                if (this.pdfSource.peek() == 10) {
                    this.pdfSource.read();
                }
                if (!this.isDigit()) {
                    this.document.setXrefEOLMarkersComplyPDFA(Boolean.FALSE);
                }
            } else if (space != 10 || !this.isDigit()) {
                this.document.setXrefEOLMarkersComplyPDFA(Boolean.FALSE);
            }
        }
        String str = this.readString();
        byte[] b = str.getBytes(Charsets.ISO_8859_1);
        this.pdfSource.rewind(b.length);
        this.xrefTrailerResolver.nextXrefObj(startByteOffset, XrefTrailerResolver.XRefType.TABLE);
        if (str.startsWith("trailer")) {
            LOG.warn("skipping empty xref table");
            return false;
        }
        do {
            long currObjID = this.readObjectNumber();
            if (this.validationParsing && ((space = this.pdfSource.read()) != 32 || !this.isDigit())) {
                this.document.setSubsectionHeaderSpaceSeparated(Boolean.FALSE);
            }
            long count = this.readLong();
            this.skipSpaces();
            int i = 0;
            while ((long)i < count && !this.pdfSource.isEOF() && !this.isEndOfName((char)this.pdfSource.peek()) && this.pdfSource.peek() != 116) {
                String currentLine = this.readLine();
                String[] splitString = currentLine.split("\\s");
                if (splitString.length < 3) {
                    LOG.warn("invalid xref line: " + currentLine);
                    break;
                }
                if (splitString[splitString.length - 1].equals("n")) {
                    try {
                        int currOffset = Integer.parseInt(splitString[0]);
                        int currGenID = Integer.parseInt(splitString[1]);
                        COSObjectKey objKey = new COSObjectKey(currObjID, currGenID);
                        this.xrefTrailerResolver.setXRef(objKey, currOffset);
                    }
                    catch (NumberFormatException e) {
                        throw new IOException(e);
                    }
                } else if (!splitString[2].equals("f")) {
                    throw new IOException("Corrupt XRefTable Entry - ObjID:" + currObjID);
                }
                ++currObjID;
                this.skipSpaces();
                ++i;
            }
            this.skipSpaces();
        } while (this.isDigit());
        return true;
    }

    private void parseXrefStream(COSStream stream, long objByteOffset, boolean isStandalone) throws IOException {
        if (isStandalone) {
            this.xrefTrailerResolver.nextXrefObj(objByteOffset, XrefTrailerResolver.XRefType.STREAM);
            this.xrefTrailerResolver.setTrailer(stream);
        }
        PDFXrefStreamParser parser = new PDFXrefStreamParser(stream, this.document, this.xrefTrailerResolver);
        parser.parse();
    }

    public COSDocument getDocument() throws IOException {
        if (this.document == null) {
            throw new IOException("You must call parse() before calling getDocument()");
        }
        return this.document;
    }

    protected COSBase parseTrailerValuesDynamically(COSDictionary trailer) throws IOException {
        for (COSBase trailerEntry : trailer.getValues()) {
            if (!(trailerEntry instanceof COSObject)) continue;
            COSObject tmpObj = (COSObject)trailerEntry;
            this.parseObjectDynamically(tmpObj, false);
        }
        COSObject root = (COSObject)trailer.getItem(COSName.ROOT);
        if (root == null) {
            throw new IOException("Missing root object specification in trailer.");
        }
        return this.parseObjectDynamically(root, false);
    }

    public COSDictionary getFirstTrailer() {
        return this.xrefTrailerResolver.getFirstTrailer();
    }

    public COSDictionary getLastTrailer() {
        return this.xrefTrailerResolver.getLastTrailer();
    }

    protected void isLinearized(Long fileLen) throws IOException {
        COSNumber length;
        COSDictionary linearized;
        Map.Entry<COSObjectKey, Long> object = this.getFirstDictionary();
        COSObject pdfObject = new COSObject(null);
        if (object == null) {
            LOG.warn("Linearization dictionary is missed in document");
            return;
        }
        this.parseFileObject(object.getValue(), object.getKey(), object.getKey().getNumber(), object.getKey().getGeneration(), pdfObject);
        if (pdfObject.getObject() != null && pdfObject.getObject() instanceof COSDictionary && (linearized = (COSDictionary)pdfObject.getObject()).getItem(COSName.getPDFName("Linearized")) != null && (length = (COSNumber)linearized.getItem(COSName.L)) != null) {
            Boolean isLinearized = length.longValue() == fileLen.longValue() && this.pdfSource.getPosition() < 1024L;
            this.document.setIsLinearized(isLinearized);
        }
    }

    private Map.Entry<COSObjectKey, Long> getFirstDictionary() throws IOException {
        this.pdfSource.seek(0L);
        this.skipSpaces();
        int bound = Math.min(this.pdfSource.available(), 1024);
        Long offset = this.pdfSource.getPosition();
        while (offset < (long)bound) {
            try {
                this.pdfSource.seek(offset);
                Long objNr = this.readObjectNumber();
                Integer genNr = this.readGenerationNumber();
                this.readExpectedString(OBJ_MARKER, Boolean.TRUE);
                return new AbstractMap.SimpleEntry<COSObjectKey, Long>(new COSObjectKey(objNr, genNr), offset);
            }
            catch (IOException iOException) {
                Long l = offset;
                Long l2 = offset = Long.valueOf(offset + 1L);
            }
        }
        return null;
    }
}

