/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.graphics.image;

import java.io.IOException;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.common.PDStream;
import org.apache.pdfbox.pdmodel.graphics.PDXObject;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorSpace;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceGray;

public class PDImageXObjectProxy
extends PDXObject {
    private PDColorSpace colorSpace;
    private PDResources resources;

    public PDImageXObjectProxy(PDStream stream, PDResources resources) {
        super(stream, COSName.IMAGE);
        this.resources = resources;
    }

    public boolean getInterpolate() {
        return this.getCOSStream().getBoolean(COSName.INTERPOLATE, false);
    }

    public boolean isStencil() {
        return this.getCOSStream().getBoolean(COSName.IMAGE_MASK, false);
    }

    public PDColorSpace getColorSpace() throws IOException {
        if (this.colorSpace == null) {
            COSBase cosBase = this.getCOSStream().getDictionaryObject(COSName.COLORSPACE, COSName.CS);
            if (cosBase != null) {
                this.colorSpace = PDColorSpace.create(cosBase, this.resources);
            } else {
                if (this.isStencil()) {
                    return PDDeviceGray.INSTANCE;
                }
                throw new IOException("could not determine color space");
            }
        }
        return this.colorSpace;
    }

    public PDResources getResources() {
        return this.resources;
    }
}

