/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.cli;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.ParameterException;
import java.io.IOException;
import org.verapdf.ReleaseDetails;
import org.verapdf.cli.VeraPdfCliProcessor;
import org.verapdf.cli.commands.VeraCliArgParser;
import org.verapdf.pdfa.validation.ProfileDirectory;
import org.verapdf.pdfa.validation.Profiles;
import org.verapdf.pdfa.validation.ValidationProfile;

public final class VeraPdfCli {
    private static final String APP_NAME = "veraPDF";
    private static final ReleaseDetails RELEASE_DETAILS = ReleaseDetails.getInstance();
    private static final String FLAVOURS_HEADING = "veraPDF supported PDF/A profiles:";
    private static final ProfileDirectory PROFILES = Profiles.getVeraProfileDirectory();

    private VeraPdfCli() {
    }

    public static void main(String[] args) {
        VeraCliArgParser cliArgParser = new VeraCliArgParser();
        JCommander jCommander = new JCommander(cliArgParser);
        jCommander.setProgramName(APP_NAME);
        try {
            jCommander.parse(args);
        }
        catch (ParameterException e) {
            System.err.println(e.getMessage());
            VeraPdfCli.showVersionInfo();
            jCommander.usage();
            System.exit(1);
        }
        if (cliArgParser.isHelp()) {
            VeraPdfCli.showVersionInfo();
            jCommander.usage();
            System.exit(0);
        }
        VeraPdfCli.messagesFromParser(cliArgParser);
        if (VeraPdfCli.isProcess(cliArgParser)) {
            try {
                VeraPdfCliProcessor processor = VeraPdfCliProcessor.createProcessorFromArgs(cliArgParser);
                processor.processPaths(cliArgParser.getPdfPaths());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static void messagesFromParser(VeraCliArgParser parser) {
        if (parser.listProfiles()) {
            VeraPdfCli.listProfiles();
        }
        if (parser.showVersion()) {
            VeraPdfCli.showVersionInfo();
        }
    }

    private static void listProfiles() {
        System.out.println(FLAVOURS_HEADING);
        for (ValidationProfile profile : PROFILES.getValidationProfiles()) {
            System.out.println("  " + profile.getPDFAFlavour().getId() + " - " + profile.getDetails().getName());
        }
        System.out.println();
    }

    private static void showVersionInfo() {
        System.out.println("Version: " + RELEASE_DETAILS.getVersion());
        System.out.println("Built: " + RELEASE_DETAILS.getBuildDate());
        System.out.println(RELEASE_DETAILS.getRights());
        System.out.println();
    }

    private static boolean isProcess(VeraCliArgParser parser) {
        return !parser.getPdfPaths().isEmpty() || !parser.isHelp() && !parser.listProfiles() && !parser.showVersion();
    }
}

