/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.features;

import java.util.Calendar;
import org.verapdf.features.FeaturesData;

public class EmbeddedFileFeaturesData
extends FeaturesData {
    private final String name;
    private final String description;
    private final String subtype;
    private final Calendar creationDate;
    private final Calendar modDate;
    private final String checkSum;
    private final Integer size;

    EmbeddedFileFeaturesData(byte[] stream, Integer size, String checkSum, Calendar modDate, Calendar creationDate, String subtype, String description, String name) {
        super(stream);
        this.size = size;
        this.checkSum = checkSum;
        this.modDate = modDate == null ? null : (Calendar)modDate.clone();
        this.creationDate = creationDate == null ? null : (Calendar)creationDate.clone();
        this.subtype = subtype;
        this.description = description;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getSubtype() {
        return this.subtype;
    }

    public Calendar getCreationDate() {
        return (Calendar)this.creationDate.clone();
    }

    public Calendar getModDate() {
        return (Calendar)this.modDate.clone();
    }

    public String getCheckSum() {
        return this.checkSum;
    }

    public Integer getSize() {
        return this.size;
    }

    public static final class Builder {
        private byte[] stream = null;
        private String name = null;
        private String description = null;
        private String subtype = null;
        private Calendar creationDate = null;
        private Calendar modDate = null;
        private String checkSum = null;
        private Integer size = null;

        public Builder(byte[] stream) {
            this.stream = stream;
        }

        public EmbeddedFileFeaturesData build() {
            if (this.stream == null) {
                throw new IllegalArgumentException("Embedded file stream can not be null");
            }
            return new EmbeddedFileFeaturesData(this.stream, this.size, this.checkSum, this.modDate, this.creationDate, this.subtype, this.description, this.name);
        }

        public Builder stream(byte[] streamBuild) {
            this.stream = streamBuild;
            return this;
        }

        public Builder name(String nameBuild) {
            this.name = nameBuild;
            return this;
        }

        public Builder description(String descriptionBuild) {
            this.description = descriptionBuild;
            return this;
        }

        public Builder subtype(String subtypeBuild) {
            this.subtype = subtypeBuild;
            return this;
        }

        public Builder creationDate(Calendar creationDateBuild) {
            this.creationDate = creationDateBuild;
            return this;
        }

        public Builder modDate(Calendar modDateBuild) {
            this.modDate = modDateBuild;
            return this;
        }

        public Builder checkSum(String checkSumBuild) {
            this.checkSum = checkSumBuild;
            return this;
        }

        public Builder size(Integer sizeBuild) {
            this.size = sizeBuild;
            return this;
        }
    }
}

