/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.features;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.apache.log4j.Logger;
import org.verapdf.features.FeaturesExtractor;
import org.verapdf.features.FeaturesReporter;

public class FeaturesPluginsLoader {
    private static final Logger LOGGER = Logger.getLogger(FeaturesPluginsLoader.class);

    private FeaturesPluginsLoader() {
    }

    static void loadExtractors(Path pluginsFolder) {
        File dir;
        File file = dir = pluginsFolder == null ? null : pluginsFolder.toFile();
        if (dir != null && dir.isDirectory() && dir.canRead()) {
            List<FeaturesExtractor> extractors = FeaturesPluginsLoader.getAllExtractors(dir);
            for (FeaturesExtractor ext : extractors) {
                FeaturesReporter.registerFeaturesExtractor(ext);
            }
        } else {
            LOGGER.warn("Plugins folder does not exist.");
        }
    }

    private static List<FeaturesExtractor> getAllExtractors(File dir) {
        List<File> jars = FeaturesPluginsLoader.getAllJars(dir);
        List<FeaturesExtractor> extractors = FeaturesPluginsLoader.loadAllExtractors(jars);
        return extractors;
    }

    private static List<File> getAllJars(File dir) {
        ArrayList<File> jars = new ArrayList<File>();
        File[] files = dir.listFiles();
        if (files != null) {
            for (File f : files) {
                if (!f.isDirectory()) continue;
                FeaturesPluginsLoader.addJar(f, jars);
            }
        }
        return jars;
    }

    private static void addJar(File dir, List<File> jars) {
        File[] files = dir.listFiles();
        if (files == null) {
            return;
        }
        for (File f : files) {
            if (!f.isFile() || !f.getName().endsWith(".jar")) continue;
            jars.add(f);
            return;
        }
    }

    private static List<FeaturesExtractor> loadAllExtractors(List<File> jars) {
        ArrayList<FeaturesExtractor> extractors = new ArrayList<FeaturesExtractor>();
        HashSet<String> extractorsIds = new HashSet<String>();
        for (File jar : jars) {
            try {
                List<String> classNames = FeaturesPluginsLoader.getAllClassNamesFromJAR(jar);
                FeaturesPluginsLoader.loadAllExtractorsWithUniqueIDsByClassNames(extractors, extractorsIds, jar, classNames);
            }
            catch (IOException e) {
                LOGGER.error("Can not load extractors from file with path " + jar.getPath(), e);
            }
        }
        return extractors;
    }

    private static List<String> getAllClassNamesFromJAR(File jar) throws IOException {
        ArrayList<String> classNames = new ArrayList<String>();
        try (JarInputStream jarStream = new JarInputStream(new FileInputStream(jar));){
            JarEntry jarEntry = jarStream.getNextJarEntry();
            while (jarEntry != null) {
                if (jarEntry.getName().endsWith(".class")) {
                    String className = jarEntry.getName().replaceAll("/", ".");
                    String myClass = className.substring(0, className.lastIndexOf(46));
                    classNames.add(myClass);
                }
                jarEntry = jarStream.getNextJarEntry();
            }
        }
        return classNames;
    }

    private static void loadAllExtractorsWithUniqueIDsByClassNames(List<FeaturesExtractor> toAdd, Set<String> uniqueIds, File jar, List<String> classNames) throws MalformedURLException {
        URL url = jar.toURI().toURL();
        URL[] urls = new URL[]{url};
        URLClassLoader cl = new URLClassLoader(urls);
        Class<?> extractorClass = null;
        for (String className : classNames) {
            try {
                Class<?> cls = cl.loadClass(className);
                if (!FeaturesExtractor.class.isAssignableFrom(cls)) continue;
                if (extractorClass == null) {
                    extractorClass = cls;
                    continue;
                }
                LOGGER.error("JAR file " + jar.getAbsolutePath() + " contains more than one extractor.");
                return;
            }
            catch (ClassNotFoundException e) {
                LOGGER.error("Can not load class " + className + " from jar " + jar.getAbsolutePath(), e);
            }
        }
        if (extractorClass != null) {
            try {
                Object obj = extractorClass.newInstance();
                FeaturesExtractor extractor = (FeaturesExtractor)obj;
                String extractorID = extractor.getID();
                if (!uniqueIds.contains(extractorID)) {
                    uniqueIds.add(extractorID);
                    extractor.initialize(jar.getParentFile().toPath());
                    toAdd.add(extractor);
                } else {
                    LOGGER.error("Founded extractor with the same ID as already loaded extractor. Extractor name: " + extractorClass.getName() + ", jar file:" + jar.getAbsolutePath());
                }
            }
            catch (IllegalAccessException | InstantiationException e) {
                LOGGER.error("Can not create an instance of the class " + extractorClass.getName() + " from jar " + jar.getPath(), e);
            }
        }
    }
}

