/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.features;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.verapdf.core.FeatureParsingException;
import org.verapdf.features.FeaturesData;
import org.verapdf.features.FeaturesExtractor;
import org.verapdf.features.FeaturesObjectTypesEnum;
import org.verapdf.features.FeaturesPluginsLoader;
import org.verapdf.features.IFeaturesObject;
import org.verapdf.features.tools.FeatureTreeNode;
import org.verapdf.features.tools.FeaturesCollection;

public class FeaturesReporter {
    public static final String CUSTOM_FEATURES_ROOT_NODE_NAME = "customFeatures";
    private static Map<FeaturesObjectTypesEnum, List<FeaturesExtractor>> featuresExtractors = new HashMap<FeaturesObjectTypesEnum, List<FeaturesExtractor>>();
    private static Path pluginsFolder = null;
    private final FeaturesCollection collection = new FeaturesCollection();
    private boolean isPluginsEnabled;

    public FeaturesReporter(boolean isPluginsEnabled, Path pluginsFolder) {
        this.isPluginsEnabled = isPluginsEnabled;
        if (this.isPluginsEnabled && (FeaturesReporter.pluginsFolder == null || !FeaturesReporter.pluginsFolder.equals(pluginsFolder))) {
            FeaturesReporter.pluginsFolder = pluginsFolder;
            featuresExtractors.clear();
            FeaturesPluginsLoader.loadExtractors(FeaturesReporter.pluginsFolder);
        }
    }

    static void registerFeaturesExtractor(FeaturesExtractor extractor) {
        if (featuresExtractors.get((Object)extractor.getType()) == null) {
            featuresExtractors.put(extractor.getType(), new ArrayList());
        }
        featuresExtractors.get((Object)extractor.getType()).add(extractor);
    }

    public void report(IFeaturesObject obj) {
        try {
            FeaturesData objData;
            FeatureTreeNode root = obj.reportFeatures(this.collection);
            if (featuresExtractors.get((Object)obj.getType()) != null && (objData = obj.getData()) != null) {
                FeatureTreeNode custom = FeatureTreeNode.createChildNode(CUSTOM_FEATURES_ROOT_NODE_NAME, root);
                for (FeaturesExtractor ext : featuresExtractors.get((Object)obj.getType())) {
                    List<FeatureTreeNode> cust = ext.getFeatures(objData);
                    if (cust == null) continue;
                    FeatureTreeNode custRoot = FeatureTreeNode.createChildNode("pluginFeatures", custom);
                    custRoot.setAttribute("pluginId", ext.getID());
                    custRoot.setAttribute("description", ext.getDescription());
                    for (FeatureTreeNode ftn : cust) {
                        if (ftn == null) continue;
                        custRoot.addChild(ftn);
                    }
                }
            }
        }
        catch (FeatureParsingException ignore) {
            throw new IllegalStateException("FeaturesReporter.report() illegal state.", ignore);
        }
    }

    public FeaturesCollection getCollection() {
        return this.collection;
    }
}

