/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.features;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.verapdf.features.FeaturesData;

public final class ICCProfileFeaturesData
extends FeaturesData {
    private final byte[] metadata;
    private final Integer n;
    private final List<Double> range;

    private ICCProfileFeaturesData(byte[] metadata, byte[] stream, Integer n, List<Double> range) {
        super(stream);
        this.metadata = metadata == null ? null : Arrays.copyOf(metadata, metadata.length);
        this.n = n;
        this.range = range == null ? null : new ArrayList<Double>(range);
    }

    public static ICCProfileFeaturesData newInstance(byte[] metadata, byte[] stream, Integer n, List<Double> range) {
        if (stream == null) {
            throw new IllegalArgumentException("ICCProfile stream can not be null");
        }
        return new ICCProfileFeaturesData(metadata, stream, n, range);
    }

    public byte[] getMetadata() {
        return this.metadata == null ? null : Arrays.copyOf(this.metadata, this.metadata.length);
    }

    public Integer getN() {
        return this.n;
    }

    public List<Double> getRange() {
        return this.range == null ? null : Collections.unmodifiableList(this.range);
    }
}

