/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.features.pb.objects;

import java.io.IOException;
import org.apache.log4j.Logger;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.pdmodel.encryption.AccessPermission;
import org.apache.pdfbox.pdmodel.encryption.PDEncryption;
import org.verapdf.core.FeatureParsingException;
import org.verapdf.features.FeaturesData;
import org.verapdf.features.FeaturesObjectTypesEnum;
import org.verapdf.features.IFeaturesObject;
import org.verapdf.features.pb.tools.PBCreateNodeHelper;
import org.verapdf.features.tools.ErrorsHelper;
import org.verapdf.features.tools.FeatureTreeNode;
import org.verapdf.features.tools.FeaturesCollection;

public class PBDocSecurityFeaturesObject
implements IFeaturesObject {
    private static final Logger LOGGER = Logger.getLogger(PBDocSecurityFeaturesObject.class);
    private PDEncryption encryption;

    public PBDocSecurityFeaturesObject(PDEncryption encryption) {
        this.encryption = encryption;
    }

    @Override
    public FeaturesObjectTypesEnum getType() {
        return FeaturesObjectTypesEnum.DOCUMENT_SECURITY;
    }

    @Override
    public FeatureTreeNode reportFeatures(FeaturesCollection collection) throws FeatureParsingException {
        if (this.encryption != null) {
            FeatureTreeNode root = FeatureTreeNode.createRootNode("documentSecurity");
            PBCreateNodeHelper.addNotEmptyNode("filter", this.encryption.getFilter(), root);
            PBCreateNodeHelper.addNotEmptyNode("subFilter", this.encryption.getSubFilter(), root);
            PBCreateNodeHelper.addNotEmptyNode("version", String.valueOf(this.encryption.getVersion()), root);
            PBCreateNodeHelper.addNotEmptyNode("length", String.valueOf(this.encryption.getLength()), root);
            try {
                String ownerKey = new COSString(this.encryption.getOwnerKey()).toHexString();
                PBCreateNodeHelper.addNotEmptyNode("ownerKey", ownerKey, root);
            }
            catch (IOException e) {
                LOGGER.debug("PDFBox error getting owner key data", e);
                FeatureTreeNode ownerKey = FeatureTreeNode.createChildNode("ownerKey", root);
                ErrorsHelper.addErrorIntoCollection(collection, ownerKey, e.getMessage());
            }
            try {
                String userKey = new COSString(this.encryption.getUserKey()).toHexString();
                PBCreateNodeHelper.addNotEmptyNode("userKey", userKey, root);
            }
            catch (IOException e) {
                LOGGER.debug("PDFBox error getting user key data", e);
                FeatureTreeNode userKey = FeatureTreeNode.createChildNode("userKey", root);
                ErrorsHelper.addErrorIntoCollection(collection, userKey, e.getMessage());
            }
            PBCreateNodeHelper.addNotEmptyNode("encryptMetadata", String.valueOf(this.encryption.isEncryptMetaData()), root);
            try {
                if (this.encryption.getSecurityHandler() != null) {
                    AccessPermission accessPermissions = new AccessPermission(this.encryption.getPermissions());
                    PBCreateNodeHelper.addNotEmptyNode("printAllowed", String.valueOf(accessPermissions.canPrint()), root);
                    PBCreateNodeHelper.addNotEmptyNode("printDegradedAllowed", String.valueOf(accessPermissions.canPrintDegraded()), root);
                    PBCreateNodeHelper.addNotEmptyNode("changesAllowed", String.valueOf(accessPermissions.canModify()), root);
                    PBCreateNodeHelper.addNotEmptyNode("modifyAnnotationsAllowed", String.valueOf(accessPermissions.canModifyAnnotations()), root);
                    PBCreateNodeHelper.addNotEmptyNode("fillingSigningAllowed", String.valueOf(accessPermissions.canFillInForm()), root);
                    PBCreateNodeHelper.addNotEmptyNode("documentAssemblyAllowed", String.valueOf(accessPermissions.canAssembleDocument()), root);
                    PBCreateNodeHelper.addNotEmptyNode("extractContentAllowed", String.valueOf(accessPermissions.canExtractContent()), root);
                    PBCreateNodeHelper.addNotEmptyNode("extractAccessibilityAllowed", String.valueOf(accessPermissions.canExtractForAccessibility()), root);
                }
            }
            catch (IOException e) {
                LOGGER.debug("PDFBox reports no matching security handle.", e);
                FeatureTreeNode.createChildNode("securityHandler", root).setValue("No security handler");
            }
            collection.addNewFeatureTree(FeaturesObjectTypesEnum.DOCUMENT_SECURITY, root);
            return root;
        }
        return null;
    }

    @Override
    public FeaturesData getData() {
        return null;
    }
}

