/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.features.pb.objects;

import java.io.IOException;
import org.apache.log4j.Logger;
import org.apache.pdfbox.pdmodel.common.PDMetadata;
import org.verapdf.core.FeatureParsingException;
import org.verapdf.features.FeaturesData;
import org.verapdf.features.FeaturesObjectTypesEnum;
import org.verapdf.features.IFeaturesObject;
import org.verapdf.features.MetadataFeaturesData;
import org.verapdf.features.pb.tools.PBCreateNodeHelper;
import org.verapdf.features.tools.FeatureTreeNode;
import org.verapdf.features.tools.FeaturesCollection;

public class PBMetadataFeaturesObject
implements IFeaturesObject {
    private static final Logger LOGGER = Logger.getLogger(PBMetadataFeaturesObject.class);
    private PDMetadata metadata;

    public PBMetadataFeaturesObject(PDMetadata metadata) {
        this.metadata = metadata;
    }

    @Override
    public FeaturesObjectTypesEnum getType() {
        return FeaturesObjectTypesEnum.METADATA;
    }

    @Override
    public FeatureTreeNode reportFeatures(FeaturesCollection collection) throws FeatureParsingException {
        if (this.metadata != null) {
            FeatureTreeNode root = FeatureTreeNode.createRootNode("metadata");
            PBCreateNodeHelper.parseMetadata(this.metadata, "xmpPackage", root, collection);
            collection.addNewFeatureTree(FeaturesObjectTypesEnum.METADATA, root);
            return root;
        }
        return null;
    }

    @Override
    public FeaturesData getData() {
        if (this.metadata == null) {
            return null;
        }
        try {
            byte[] meta = this.metadata.getByteArray();
            return MetadataFeaturesData.newInstance(meta);
        }
        catch (IOException e) {
            LOGGER.error("Error while obtaining unfiltered metadata stream", e);
            return null;
        }
    }
}

