/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.features.pb.tools;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.Set;
import javax.xml.bind.DatatypeConverter;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.log4j.Logger;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.pdmodel.common.PDMetadata;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.graphics.color.PDColor;
import org.verapdf.core.FeatureParsingException;
import org.verapdf.features.tools.ErrorsHelper;
import org.verapdf.features.tools.FeatureTreeNode;
import org.verapdf.features.tools.FeaturesCollection;

public final class PBCreateNodeHelper {
    private static final Logger LOGGER = Logger.getLogger(PBCreateNodeHelper.class);
    private static final String LLX = "llx";
    private static final String LLY = "lly";
    private static final String URX = "urx";
    private static final String URY = "ury";
    private static final int GRAY_COLOR_COMPONENTS_NUMBER = 1;
    private static final int RGB_COLOR_COMPONENTS_NUMBER = 3;
    private static final int CMYK_COLOR_COMPONENTS_NUMBER = 4;
    private static final int GRAY_COMPONENT_NUMBER = 0;
    private static final int RED_COMPONENT_NUMBER = 0;
    private static final int GREEN_COMPONENT_NUMBER = 1;
    private static final int BLUE_COMPONENT_NUMBER = 2;
    private static final int CYAN_COMPONENT_NUMBER = 0;
    private static final int MAGENTA_COMPONENT_NUMBER = 1;
    private static final int YELLOW_COMPONENT_NUMBER = 2;
    private static final int BLACK_COMPONENT_NUMBER = 3;

    private PBCreateNodeHelper() {
    }

    private static String getXMLFormat(Calendar calendar) throws DatatypeConfigurationException {
        GregorianCalendar greg = new GregorianCalendar(Locale.US);
        greg.setTime(calendar.getTime());
        greg.setTimeZone(calendar.getTimeZone());
        XMLGregorianCalendar xmlCalendar = DatatypeFactory.newInstance().newXMLGregorianCalendar(greg);
        return xmlCalendar.toXMLFormat();
    }

    public static FeatureTreeNode createDateNode(String nodeName, FeatureTreeNode parent, Calendar date, FeaturesCollection collection) throws FeatureParsingException {
        FeatureTreeNode modificationDate = null;
        if (date != null) {
            modificationDate = FeatureTreeNode.createChildNode(nodeName, parent);
            try {
                modificationDate.setValue(PBCreateNodeHelper.getXMLFormat(date));
            }
            catch (DatatypeConfigurationException e) {
                LOGGER.debug("DatatypeFactory implementation not available or can't be instantiated", e);
                ErrorsHelper.addErrorIntoCollection(collection, modificationDate, e.getMessage());
            }
        }
        return modificationDate;
    }

    public static String getStringFromBase(COSBase baseParam) {
        COSBase base = baseParam;
        while (base instanceof COSObject) {
            base = ((COSObject)base).getObject();
        }
        if (base instanceof COSString) {
            COSString str = (COSString)base;
            return str.isHex() ? str.toHexString() : str.getString();
        }
        return null;
    }

    public static FeatureTreeNode addBoxFeature(String name, PDRectangle box, FeatureTreeNode parent) throws FeatureParsingException {
        FeatureTreeNode boxNode = null;
        if (box != null) {
            boxNode = FeatureTreeNode.createChildNode(name, parent);
            boxNode.setAttribute(LLX, String.valueOf(box.getLowerLeftX()));
            boxNode.setAttribute(LLY, String.valueOf(box.getLowerLeftY()));
            boxNode.setAttribute(URX, String.valueOf(box.getUpperRightX()));
            boxNode.setAttribute(URY, String.valueOf(box.getUpperRightY()));
        }
        return boxNode;
    }

    public static FeatureTreeNode addNotEmptyNode(String name, String value, FeatureTreeNode parent) throws FeatureParsingException {
        if (name != null && value != null) {
            FeatureTreeNode node = FeatureTreeNode.createChildNode(name, parent);
            node.setValue(value);
            return node;
        }
        return null;
    }

    public static FeatureTreeNode addDeviceColorSpaceNode(String name, PDColor color, FeatureTreeNode parent, FeaturesCollection collection) throws FeatureParsingException {
        if (name != null && color != null) {
            FeatureTreeNode colorNode = FeatureTreeNode.createChildNode(name, parent);
            float[] numbers = color.getComponents();
            switch (numbers.length) {
                case 1: {
                    PBCreateNodeHelper.createGray(color.getComponents(), colorNode);
                    break;
                }
                case 3: {
                    PBCreateNodeHelper.createRGB(color.getComponents(), colorNode);
                    break;
                }
                case 4: {
                    PBCreateNodeHelper.createCMYK(color.getComponents(), colorNode);
                    break;
                }
                default: {
                    ErrorsHelper.addErrorIntoCollection(collection, colorNode, "Can not define color type");
                }
            }
            return colorNode;
        }
        return null;
    }

    public static void parseIDSet(Set<String> set, String elementName, String setName, FeatureTreeNode root) throws FeatureParsingException {
        if (set != null && !set.isEmpty()) {
            FeatureTreeNode setNode = setName == null ? root : FeatureTreeNode.createChildNode(setName, root);
            for (String entry : set) {
                if (entry == null) continue;
                FeatureTreeNode entryNode = FeatureTreeNode.createChildNode(elementName, setNode);
                entryNode.setAttribute("id", entry);
            }
        }
    }

    public static byte[] inputStreamToByteArray(InputStream is) throws IOException {
        int length;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] bytes = new byte[1024];
        while ((length = is.read(bytes)) != -1) {
            baos.write(bytes, 0, length);
        }
        return baos.toByteArray();
    }

    public static FeatureTreeNode parseMetadata(PDMetadata metadata, String nodeName, FeatureTreeNode parent, FeaturesCollection collection) throws FeatureParsingException {
        if (metadata == null) {
            return null;
        }
        FeatureTreeNode node = FeatureTreeNode.createChildMetadataNode(nodeName, parent);
        try {
            byte[] bStream = metadata.getByteArray();
            if (bStream != null) {
                String hexString = DatatypeConverter.printHexBinary((byte[])bStream);
                node.setValue(hexString);
            }
        }
        catch (IOException e) {
            LOGGER.debug("Error while obtaining unfiltered metadata stream", e);
            ErrorsHelper.addErrorIntoCollection(collection, node, e.getMessage());
        }
        return node;
    }

    private static void createGray(float[] components, FeatureTreeNode parent) {
        parent.setAttribute("gray", String.valueOf(components[0]));
    }

    private static void createRGB(float[] components, FeatureTreeNode parent) {
        parent.setAttribute("red", String.valueOf(components[0]));
        parent.setAttribute("green", String.valueOf(components[1]));
        parent.setAttribute("blue", String.valueOf(components[2]));
    }

    private static void createCMYK(float[] components, FeatureTreeNode parent) {
        parent.setAttribute("cyan", String.valueOf(components[0]));
        parent.setAttribute("magenta", String.valueOf(components[1]));
        parent.setAttribute("yellow", String.valueOf(components[2]));
        parent.setAttribute("black", String.valueOf(components[3]));
    }
}

