/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.features.tools;

import org.apache.log4j.Logger;
import org.verapdf.core.FeatureParsingException;
import org.verapdf.features.FeaturesObjectTypesEnum;
import org.verapdf.features.tools.FeatureTreeNode;
import org.verapdf.features.tools.FeaturesCollection;

public final class ErrorsHelper {
    private static final Logger LOGGER = Logger.getLogger(ErrorsHelper.class);
    public static final String ERRORID = "errorId";
    public static final String ID = "id";

    private ErrorsHelper() {
    }

    public static String addErrorIntoCollection(FeaturesCollection collection, FeatureTreeNode element, String errorMessageArg) {
        if (collection == null) {
            throw new IllegalArgumentException("Collection can not be null");
        }
        String errorMessage = errorMessageArg;
        if (errorMessage == null) {
            errorMessage = "Exception with null message.";
        }
        try {
            String id = null;
            for (FeatureTreeNode errNode : collection.getFeatureTreesForType(FeaturesObjectTypesEnum.ERROR)) {
                if (!errorMessage.equals(errNode.getValue())) continue;
                id = errNode.getAttributes().get(ID);
                break;
            }
            if (id == null) {
                id = "error" + collection.getFeatureTreesForType(FeaturesObjectTypesEnum.ERROR).size();
                FeatureTreeNode error = FeatureTreeNode.createRootNode("error");
                error.setValue(errorMessage);
                error.setAttribute(ID, id);
                collection.addNewFeatureTree(FeaturesObjectTypesEnum.ERROR, error);
            }
            if (element != null) {
                String elementErrorID = id;
                if (element.getAttributes().get(ERRORID) != null) {
                    elementErrorID = element.getAttributes().get(ERRORID) + ", " + elementErrorID;
                }
                element.setAttribute(ERRORID, elementErrorID);
            }
            return id;
        }
        catch (FeatureParsingException ignore) {
            String message = "FeatureTreeNode root instance logic failure";
            LOGGER.fatal(message, ignore);
            throw new IllegalStateException(message, ignore);
        }
    }
}

