/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.features.tools;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.verapdf.core.FeatureParsingException;

public final class FeatureTreeNode {
    private String name;
    private String value;
    private boolean isMetadataNode = false;
    private FeatureTreeNode parent;
    private Map<String, String> attributes = new HashMap<String, String>();
    private List<FeatureTreeNode> children = new ArrayList<FeatureTreeNode>();

    private FeatureTreeNode(String name) throws FeatureParsingException {
        this(name, null);
    }

    private FeatureTreeNode(String name, FeatureTreeNode parent) throws FeatureParsingException {
        this.name = name;
        this.parent = parent;
        if (parent != null) {
            parent.addChild(this);
        }
    }

    public static FeatureTreeNode createRootNode(String name) throws FeatureParsingException {
        return new FeatureTreeNode(name);
    }

    public static FeatureTreeNode createChildNode(String name, FeatureTreeNode parent) throws FeatureParsingException {
        return new FeatureTreeNode(name, parent);
    }

    public static FeatureTreeNode createRootMetadataNode(String name) throws FeatureParsingException {
        FeatureTreeNode node = new FeatureTreeNode(name);
        node.isMetadataNode = true;
        return node;
    }

    public static FeatureTreeNode createChildMetadataNode(String name, FeatureTreeNode parent) throws FeatureParsingException {
        FeatureTreeNode node = new FeatureTreeNode(name, parent);
        node.isMetadataNode = true;
        return node;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public List<FeatureTreeNode> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    public void addChild(FeatureTreeNode child) throws FeatureParsingException {
        if (this.isMetadataNode) {
            throw new FeatureParsingException("You can not add a child for metadata nodes. Node name " + this.name + ", value: " + this.value + ".");
        }
        if (child != null) {
            if (this.value == null) {
                this.children.add(child);
                child.parent = this;
            } else {
                throw new FeatureParsingException("You can not add a child for nodes with defined values. Node name " + this.name + ", value: " + this.value + ".");
            }
        }
    }

    public void setValue(String value) throws FeatureParsingException {
        if (this.isMetadataNode && value != null && !value.matches("\\p{XDigit}*")) {
            throw new FeatureParsingException("A value for metadata node should be a hex String.");
        }
        if (value != null && !this.children.isEmpty()) {
            throw new FeatureParsingException("You can not add value for nodes with childrens. Node name " + this.name + ".");
        }
        this.value = value;
    }

    public boolean isMetadataNode() {
        return this.isMetadataNode;
    }

    public Map<String, String> getAttributes() {
        return Collections.unmodifiableMap(this.attributes);
    }

    public void setAttribute(String attributeName, String attributeValue) {
        this.attributes.put(attributeName, attributeValue);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.attributes == null ? 0 : this.attributes.hashCode());
        result = 31 * result + (this.children == null ? 0 : this.children.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        result = 31 * result + (this.isMetadataNode ? 1 : 0);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FeatureTreeNode other = (FeatureTreeNode)obj;
        if (this.isMetadataNode != other.isMetadataNode) {
            return false;
        }
        if (this.attributes == null ? other.attributes != null : !this.attributes.equals(other.attributes)) {
            return false;
        }
        if (this.children == null ? other.children != null : !FeatureTreeNode.isChildrenMatch(this, other)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public String toString() {
        return "FeatureTreeNode [name=" + this.name + ", value=" + this.value + ", isMetadataNode=" + this.isMetadataNode + ", parent=" + this.parent + ", attributes=" + this.attributes + "]";
    }

    private static boolean isChildrenMatch(FeatureTreeNode aThis, FeatureTreeNode other) {
        return aThis.children == other.children || aThis.children == null == (other.children == null) && aThis.children.size() == other.children.size() && aThis.children.containsAll(other.children);
    }
}

