/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gui;

import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.border.EmptyBorder;
import javax.xml.bind.JAXBException;
import org.apache.log4j.Logger;
import org.verapdf.gui.AboutPanel;
import org.verapdf.gui.CheckerPanel;
import org.verapdf.gui.MiniLogoPanel;
import org.verapdf.gui.SettingsPanel;
import org.verapdf.processor.config.Config;
import org.verapdf.processor.config.ConfigIO;

public class PDFValidationApplication
extends JFrame {
    private static final long serialVersionUID = -5569669411392145783L;
    private static final Logger LOGGER = Logger.getLogger(PDFValidationApplication.class);
    private AboutPanel aboutPanel;
    private transient Config config;
    private SettingsPanel settingsPanel;
    private CheckerPanel checkerPanel;

    private PDFValidationApplication() {
        this.addWindowListener(new ExitWindowAdapter());
        this.setDefaultCloseOperation(3);
        this.setBounds(100, 100, 600, 350);
        this.setResizable(false);
        this.setTitle("PDF/A Conformance Checker");
        try {
            this.config = ConfigIO.readConfig();
        }
        catch (IOException e) {
            LOGGER.error("Can not read config file", e);
            this.config = new Config();
        }
        catch (JAXBException e) {
            LOGGER.error("Cannot parse config XML", e);
            this.config = new Config();
        }
        JMenuBar menuBar = new JMenuBar();
        menuBar.setLayout(new FlowLayout(0, 0, 0));
        this.setJMenuBar(menuBar);
        this.aboutPanel = null;
        try {
            this.aboutPanel = new AboutPanel();
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this, "Error in reading logo image.", "Error", 0);
            LOGGER.error("Exception in reading logo image", e);
        }
        try {
            this.settingsPanel = new SettingsPanel();
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this, "Error initialising settings panel.", "Error", 0);
            LOGGER.error("Exception in initialising settings panel", e);
        }
        JMenuItem sett = new JMenuItem("Settings");
        sett.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (PDFValidationApplication.this.settingsPanel != null && PDFValidationApplication.this.settingsPanel.showDialog(PDFValidationApplication.this, "Settings", PDFValidationApplication.this.config)) {
                    PDFValidationApplication.this.config.setShowPassedRules(PDFValidationApplication.this.settingsPanel.isDispPassedRules());
                    PDFValidationApplication.this.config.setPluginsEnabled(PDFValidationApplication.this.settingsPanel.isPluginsEnabled());
                    PDFValidationApplication.this.config.setMaxNumberOfFailedChecks(PDFValidationApplication.this.settingsPanel.getFailedChecksNumber());
                    PDFValidationApplication.this.config.setMaxNumberOfDisplayedFailedChecks(PDFValidationApplication.this.settingsPanel.getFailedChecksDisplayNumber());
                    PDFValidationApplication.this.config.setFixMetadataPathFolder(PDFValidationApplication.this.settingsPanel.getFixMetadataDirectory());
                    PDFValidationApplication.this.config.setMetadataFixerPrefix(PDFValidationApplication.this.settingsPanel.getFixMetadataPrefix());
                    PDFValidationApplication.this.config.setProfileWikiPath(PDFValidationApplication.this.settingsPanel.getProfilesWikiPath());
                    PDFValidationApplication.this.config.setFixMetadata(PDFValidationApplication.this.config.isFixMetadata());
                    PDFValidationApplication.this.config.setProcessingType(PDFValidationApplication.this.config.getProcessingType());
                    PDFValidationApplication.this.config.setPluginsEnabled(PDFValidationApplication.this.settingsPanel.isPluginsEnabled());
                    ConfigIO.writeConfig(PDFValidationApplication.this.config);
                }
            }
        });
        menuBar.add(sett);
        JMenuItem about = new JMenuItem("About");
        about.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (PDFValidationApplication.this.aboutPanel != null) {
                    PDFValidationApplication.this.aboutPanel.showDialog(PDFValidationApplication.this, "About veraPDF");
                }
            }
        });
        menuBar.add(about);
        JPanel contentPane = new JPanel();
        contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        contentPane.setLayout(new BoxLayout(contentPane, 1));
        this.setContentPane(contentPane);
        MiniLogoPanel logoPanel = null;
        try {
            logoPanel = new MiniLogoPanel("veraPDF-logo.jpg");
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this, "Error in creating mini logo.", "Error", 0);
            LOGGER.error("Exception in creating mini logo", e);
        }
        contentPane.add(logoPanel);
        this.checkerPanel = null;
        try {
            this.checkerPanel = new CheckerPanel(this.config);
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this, "Error in loading xml or html image.", "Error", 0);
            LOGGER.error("Exception in loading xml or html image", e);
        }
        contentPane.add(this.checkerPanel);
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException e) {
                    LOGGER.error("Exception in configuring UI manager", e);
                }
                try {
                    PDFValidationApplication frame = new PDFValidationApplication();
                    frame.setVisible(true);
                }
                catch (Exception e) {
                    LOGGER.error("Exception", e);
                }
            }
        });
    }

    class ExitWindowAdapter
    extends WindowAdapter {
        ExitWindowAdapter() {
        }

        @Override
        public void windowClosing(WindowEvent e) {
            PDFValidationApplication.this.config.setFixMetadata(PDFValidationApplication.this.checkerPanel.isFixMetadata());
            PDFValidationApplication.this.config.setProcessingType(PDFValidationApplication.this.checkerPanel.getProcessingType());
            ConfigIO.writeConfig(PDFValidationApplication.this.config);
        }
    }
}

