/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gui;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.swing.JOptionPane;
import javax.swing.SwingWorker;
import javax.xml.transform.TransformerException;
import org.apache.log4j.Logger;
import org.verapdf.gui.CheckerPanel;
import org.verapdf.processor.ProcessingResult;
import org.verapdf.processor.ProcessorImpl;
import org.verapdf.processor.config.Config;
import org.verapdf.report.HTMLReport;
import org.verapdf.report.ItemDetails;

class ValidateWorker
extends SwingWorker<ProcessingResult, Integer> {
    private static final Logger LOGGER = Logger.getLogger(ValidateWorker.class);
    private static final String ERROR_IN_OPEN_STREAMS = "Can't open stream from PDF file or can't open stream to temporary XML report file";
    private static final String ERROR_IN_CREATING_TEMP_FILE = "Can't create temporary file for XML report";
    private File pdf;
    private CheckerPanel parent;
    private Config settings;
    private File xmlReport = null;
    private File htmlReport = null;
    private ProcessingResult processingResult = null;

    ValidateWorker(CheckerPanel parent, File pdf, Config settings) {
        if (pdf == null || !pdf.isFile() || !pdf.canRead()) {
            throw new IllegalArgumentException("PDF file doesn't exist or it can not be read");
        }
        this.parent = parent;
        this.pdf = pdf;
        this.settings = settings;
    }

    @Override
    protected ProcessingResult doInBackground() {
        try {
            this.xmlReport = File.createTempFile("veraPDF-tempXMLReport", ".xml");
            this.xmlReport.deleteOnExit();
            this.htmlReport = null;
        }
        catch (IOException e) {
            LOGGER.error(ERROR_IN_CREATING_TEMP_FILE, e);
            this.parent.errorInValidatingOccur("Can't create temporary file for XML report: ", e);
        }
        try (FileInputStream toProcess = new FileInputStream(this.pdf);
             FileOutputStream mrrReport = new FileOutputStream(this.xmlReport);){
            ProcessorImpl processor = new ProcessorImpl();
            this.processingResult = processor.validate(toProcess, ItemDetails.fromFile(this.pdf), this.settings, mrrReport);
        }
        catch (IOException e) {
            LOGGER.error(ERROR_IN_OPEN_STREAMS, e);
            this.parent.errorInValidatingOccur("Can't open stream from PDF file or can't open stream to temporary XML report file: ", e);
        }
        for (String errorMessage : this.processingResult.getErrorMessages()) {
            JOptionPane.showMessageDialog(this.parent, errorMessage, "Error", 0);
        }
        if (this.processingResult.getReportSummary() == ProcessingResult.ReportSummary.REPORT_SUCCEED) {
            this.writeHtmlReport();
        }
        return this.processingResult;
    }

    @Override
    protected void done() {
        this.parent.validationEnded(this.xmlReport, this.htmlReport);
    }

    private void writeHtmlReport() {
        try {
            this.htmlReport = File.createTempFile("veraPDF-tempHTMLReport", ".html");
            this.htmlReport.deleteOnExit();
            try (FileInputStream xmlStream = new FileInputStream(this.xmlReport);
                 FileOutputStream htmlStream = new FileOutputStream(this.htmlReport);){
                HTMLReport.writeHTMLReport(xmlStream, htmlStream, this.settings.getProfileWikiPath());
            }
            catch (IOException | TransformerException e) {
                JOptionPane.showMessageDialog(this.parent, "Some error in saving the HTML report: " + e.getMessage(), "Error", 0);
                LOGGER.error("Exception saving the HTML report", e);
                this.htmlReport = null;
            }
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this.parent, "Some error in saving the HTML report: " + e.getMessage(), "Error", 0);
            LOGGER.error("Exception saving the HTML report", e);
            this.htmlReport = null;
        }
    }
}

