/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.metadata.fixer.utils;

import java.io.File;

public class FileGenerator {
    private FileGenerator() {
    }

    public static File createOutputFile(String sourcePath) {
        return FileGenerator.createOutputFile(new File(sourcePath));
    }

    public static File createOutputFile(File source) {
        return FileGenerator.createOutputFile(source, "veraPDF_");
    }

    public static File createOutputFile(File source, String prefix) {
        if (source == null) {
            throw new IllegalArgumentException("Incorrect source file");
        }
        return FileGenerator.createOutputFile(source.getAbsoluteFile().getParentFile(), source.getName(), prefix);
    }

    public static File createOutputFile(File folderFile, String fileName, String prefix) {
        if (folderFile == null) {
            throw new IllegalArgumentException("Incorrect path to folder.");
        }
        if (fileName == null || fileName.trim().isEmpty()) {
            throw new IllegalArgumentException("Incorrect file name");
        }
        if (prefix == null) {
            throw new IllegalArgumentException("Incorrect prefix is used");
        }
        StringBuilder resultPath = new StringBuilder();
        resultPath.append(folderFile.getAbsoluteFile().getAbsolutePath()).append(File.separator).append(prefix);
        String extension = FileGenerator.getExtension(fileName, resultPath);
        return FileGenerator.createOutputFile(resultPath.toString(), extension, 0);
    }

    private static String getExtension(String name, StringBuilder resultPath) {
        String[] split = name.split("[.]");
        if (split.length > 1) {
            resultPath.append(split[0]);
            for (int i = 1; i < split.length - 1; ++i) {
                resultPath.append('.').append(split[i]);
            }
            return '.' + split[split.length - 1];
        }
        return "";
    }

    private static File createOutputFile(String path, String extension, int index) {
        String resPath;
        File resultFile;
        while ((resultFile = new File(resPath = path + (index != 0 ? "(" + index + ")" : "") + extension)).exists()) {
            ++index;
        }
        return resultFile;
    }
}

