/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.metadata.fixer.utils;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import org.verapdf.metadata.fixer.utils.ValidationStatus;
import org.verapdf.metadata.fixer.utils.model.ProcessedObjects;
import org.verapdf.metadata.fixer.utils.parser.ProcessedObjectsParser;
import org.verapdf.metadata.fixer.utils.parser.XMLProcessedObjectsParser;
import org.verapdf.pdfa.results.TestAssertion;
import org.verapdf.pdfa.validation.Rule;
import org.verapdf.pdfa.validation.ValidationProfile;
import org.xml.sax.SAXException;

public class ProcessedObjectsInspector {
    private ProcessedObjectsInspector() {
    }

    public static ValidationStatus validationStatus(Set<TestAssertion> assertions, ValidationProfile profile) throws URISyntaxException, IOException, ParserConfigurationException, SAXException {
        ProcessedObjectsParser parser = XMLProcessedObjectsParser.getInstance();
        return ProcessedObjectsInspector.validationStatus(assertions, profile, parser);
    }

    public static ValidationStatus validationStatus(Set<TestAssertion> assertions, ValidationProfile profile, ProcessedObjectsParser parser) throws IOException, URISyntaxException, ParserConfigurationException, SAXException {
        return ProcessedObjectsInspector.validationStatus(assertions, profile, parser.getProcessedObjects(profile.getPDFAFlavour()));
    }

    public static ValidationStatus validationStatus(Set<TestAssertion> assertions, ValidationProfile profile, ProcessedObjects objects) throws IOException, URISyntaxException, ParserConfigurationException, SAXException {
        ValidationStatus status = ValidationStatus.VALID;
        for (TestAssertion assertion : assertions) {
            if (assertion.getStatus() != TestAssertion.Status.FAILED) continue;
            status = ProcessedObjectsInspector.checkCurrentRule(profile, objects, assertion, status);
        }
        return status;
    }

    private static ValidationStatus checkCurrentRule(ValidationProfile profile, ProcessedObjects objects, TestAssertion rule, ValidationStatus status) {
        Rule profileRule = profile.getRuleByRuleId(rule.getRuleId());
        String objectType = profileRule.getObject();
        if (objects.contains(objectType, profileRule.getTest())) {
            return ValidationStatus.INVALID_METADATA.getStatus(status);
        }
        return ValidationStatus.INVALID_STRUCTURE.getStatus(status);
    }
}

