/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.model.impl.axl;

import com.adobe.xmp.impl.VeraPDFXMPNode;
import java.util.ArrayList;
import java.util.List;
import org.verapdf.model.baselayer.Object;
import org.verapdf.model.impl.axl.AXLExtensionSchemaField;
import org.verapdf.model.impl.axl.AXLExtensionSchemaObject;
import org.verapdf.model.tools.xmp.ValidatorsContainer;
import org.verapdf.model.tools.xmp.validators.SimpleTypeValidator;
import org.verapdf.model.tools.xmp.validators.URITypeValidator;
import org.verapdf.model.xmplayer.ExtensionSchemaValueType;
import org.verapdf.pdfa.flavours.PDFAFlavour;

public class AXLExtensionSchemaValueType
extends AXLExtensionSchemaObject
implements ExtensionSchemaValueType {
    public static final String EXTENSION_SCHEMA_VALUE_TYPE = "ExtensionSchemaValueType";
    public static final String EXTENSION_SCHEMA_FIELDS = "ExtensionSchemaFields";
    private static final String NAMESPACE_URI = "namespaceURI";
    private static final String PREFIX = "prefix";
    private static final String FIELD = "field";
    private static final String DESCRIPTION = "description";
    private static final String TYPE = "type";

    public AXLExtensionSchemaValueType(VeraPDFXMPNode xmpNode, ValidatorsContainer containerForPDFA_1, ValidatorsContainer containerForPDFA_2_3, PDFAFlavour flavour) {
        super(EXTENSION_SCHEMA_VALUE_TYPE, xmpNode, containerForPDFA_1, containerForPDFA_2_3, flavour);
    }

    @Override
    public List<? extends Object> getLinkedObjects(String link) {
        switch (link) {
            case "ExtensionSchemaFields": {
                return this.getExtensionSchemaFields();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<AXLExtensionSchemaField> getExtensionSchemaFields() {
        ArrayList<AXLExtensionSchemaField> res = new ArrayList<AXLExtensionSchemaField>();
        if (this.xmpNode == null) {
            return res;
        }
        for (VeraPDFXMPNode child : this.xmpNode.getChildren()) {
            if (!"http://www.aiim.org/pdfa/ns/type#".equals(child.getNamespaceURI()) || !FIELD.equals(child.getName())) continue;
            if (!child.getOptions().isArray()) break;
            for (VeraPDFXMPNode node : child.getChildren()) {
                res.add(new AXLExtensionSchemaField(node, this.containerForPDFA_1, this.containerForPDFA_2_3, this.flavour));
            }
        }
        return res;
    }

    @Override
    public Boolean getcontainsUndefinedFields() {
        boolean undef = false;
        for (VeraPDFXMPNode child : this.xmpNode.getChildren()) {
            if (!undef && "http://www.aiim.org/pdfa/ns/type#".equals(child.getNamespaceURI())) {
                switch (child.getName()) {
                    case "namespaceURI": 
                    case "prefix": 
                    case "field": 
                    case "description": 
                    case "type": {
                        break;
                    }
                    default: {
                        undef = true;
                        break;
                    }
                }
                continue;
            }
            undef = true;
            break;
        }
        return undef;
    }

    @Override
    public Boolean getisDescriptionValidText() {
        for (VeraPDFXMPNode child : this.xmpNode.getChildren()) {
            if (!"http://www.aiim.org/pdfa/ns/type#".equals(child.getNamespaceURI()) || !DESCRIPTION.equals(child.getName())) continue;
            return SimpleTypeValidator.fromValue(SimpleTypeValidator.SimpleTypeEnum.TEXT).isCorresponding(child);
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean getisFieldValidSeq() {
        for (VeraPDFXMPNode child : this.xmpNode.getChildren()) {
            if (!"http://www.aiim.org/pdfa/ns/type#".equals(child.getNamespaceURI()) || !FIELD.equals(child.getName())) continue;
            return child.getOptions().isArrayOrdered();
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean getisNamespaceURIValidURI() {
        for (VeraPDFXMPNode child : this.xmpNode.getChildren()) {
            if (!"http://www.aiim.org/pdfa/ns/type#".equals(child.getNamespaceURI()) || !NAMESPACE_URI.equals(child.getName())) continue;
            return new URITypeValidator().isCorresponding(child);
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean getisPrefixValidText() {
        for (VeraPDFXMPNode child : this.xmpNode.getChildren()) {
            if (!"http://www.aiim.org/pdfa/ns/type#".equals(child.getNamespaceURI()) || !PREFIX.equals(child.getName())) continue;
            return SimpleTypeValidator.fromValue(SimpleTypeValidator.SimpleTypeEnum.TEXT).isCorresponding(child);
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean getisTypeValidText() {
        for (VeraPDFXMPNode child : this.xmpNode.getChildren()) {
            if (!"http://www.aiim.org/pdfa/ns/type#".equals(child.getNamespaceURI()) || !TYPE.equals(child.getName())) continue;
            return SimpleTypeValidator.fromValue(SimpleTypeValidator.SimpleTypeEnum.TEXT).isCorresponding(child);
        }
        return Boolean.TRUE;
    }

    @Override
    public String getdescriptionPrefix() {
        for (VeraPDFXMPNode child : this.xmpNode.getChildren()) {
            if (!"http://www.aiim.org/pdfa/ns/type#".equals(child.getNamespaceURI()) || !DESCRIPTION.equals(child.getName())) continue;
            return child.getPrefix();
        }
        return null;
    }

    @Override
    public String getfieldPrefix() {
        for (VeraPDFXMPNode child : this.xmpNode.getChildren()) {
            if (!"http://www.aiim.org/pdfa/ns/type#".equals(child.getNamespaceURI()) || !FIELD.equals(child.getName())) continue;
            return child.getPrefix();
        }
        return null;
    }

    @Override
    public String getnamespaceURIPrefix() {
        for (VeraPDFXMPNode child : this.xmpNode.getChildren()) {
            if (!"http://www.aiim.org/pdfa/ns/type#".equals(child.getNamespaceURI()) || !NAMESPACE_URI.equals(child.getName())) continue;
            return child.getPrefix();
        }
        return null;
    }

    @Override
    public String getprefixPrefix() {
        for (VeraPDFXMPNode child : this.xmpNode.getChildren()) {
            if (!"http://www.aiim.org/pdfa/ns/type#".equals(child.getNamespaceURI()) || !PREFIX.equals(child.getName())) continue;
            return child.getPrefix();
        }
        return null;
    }

    @Override
    public String gettypePrefix() {
        for (VeraPDFXMPNode child : this.xmpNode.getChildren()) {
            if (!"http://www.aiim.org/pdfa/ns/type#".equals(child.getNamespaceURI()) || !TYPE.equals(child.getName())) continue;
            return child.getPrefix();
        }
        return null;
    }
}

