/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.model.impl.pb.external;

import java.io.IOException;
import java.io.InputStream;
import org.apache.log4j.Logger;
import org.verapdf.model.external.JPEG2000;
import org.verapdf.model.impl.pb.external.PBoxExternal;

public class PBoxJPEG2000
extends PBoxExternal
implements JPEG2000 {
    private static final Logger LOGGER = Logger.getLogger(PBoxJPEG2000.class);
    public static final String JPEG_2000_TYPE = "JPEG2000";
    private static final Long DEFAULT_NR_COLOR_CHANNELS = 0L;
    private static final Long DEFAULT_NR_COLOR_SPACE_SPECS = 0L;
    private static final Long DEFAULT_NR_COLOR_SPACES_WITH_APPROX_FIELD = 0L;
    private static final Long DEFAULT_COLR_METHOD = 0L;
    private static final Long DEFAULT_COLR_ENUM_CS = null;
    private static final Long DEFAULT_BIT_DEPTH = 0L;
    private static final Boolean DEFAULT_BPCC_BOX_PRESENT = Boolean.FALSE;
    private static final byte[] sign = new byte[]{0, 0, 0, 12, 106, 80, 32, 32, 13, 10, -121, 10};
    private static final byte[] header = new byte[]{106, 112, 50, 104};
    private static final byte[] ihdr = new byte[]{105, 104, 100, 114};
    private static final byte[] bpcc = new byte[]{98, 112, 99, 99};
    private static final byte[] colr = new byte[]{99, 111, 108, 114};
    private final Long nrColorChannels;
    private final Long nrColorSpaceSpecs;
    private final Long nrColorSpacesWithApproxField;
    private final Long colrMethod;
    private final Long colrEnumCS;
    private final Long bitDepth;
    private final Boolean bpccBoxPresent;

    private PBoxJPEG2000(Long nrColorChannels, Long nrColorSpaceSpecs, Long nrColorSpacesWithApproxField, Long colrMethod, Long colrEnumCS, Long bitDepth, Boolean bpccBoxPresent) {
        super(JPEG_2000_TYPE);
        this.nrColorChannels = nrColorChannels;
        this.nrColorSpaceSpecs = nrColorSpaceSpecs;
        this.nrColorSpacesWithApproxField = nrColorSpacesWithApproxField;
        this.colrMethod = colrMethod;
        this.colrEnumCS = colrEnumCS;
        this.bitDepth = bitDepth;
        this.bpccBoxPresent = bpccBoxPresent;
    }

    public static PBoxJPEG2000 fromStream(InputStream stream) {
        Builder builder = new Builder();
        byte[] sign = new byte[12];
        try {
            if (stream.read(sign) != 12 || !PBoxJPEG2000.isValidSignature(sign)) {
                LOGGER.warn("File contains wrong signature");
                return builder.build();
            }
            long headerLeft = PBoxJPEG2000.findHeader(stream);
            if (headerLeft >= 0L) {
                PBoxJPEG2000.parseHeader(stream, headerLeft, builder);
            }
        }
        catch (IOException e) {
            LOGGER.debug(e);
        }
        return builder.build();
    }

    private static void parseHeader(InputStream stream, long headerLeft, Builder builder) throws IOException {
        long length;
        long leftInHeader = headerLeft;
        boolean isHeaderReachEnd = leftInHeader == 0L;
        Long nrColorSpaceSpecs = null;
        Long nrColorSpacesWithApproxField = null;
        Long firstColrMethod = null;
        Long firstColrEnumCS = null;
        Long colrMethod = null;
        Long colrEnumCS = null;
        do {
            byte[] lbox = new byte[4];
            byte[] tbox = new byte[4];
            if (stream.read(lbox) != 4 || stream.read(tbox) != 4) break;
            int skipped = 8;
            length = PBoxJPEG2000.convertArrayToLong(lbox);
            if (length == 1L) {
                byte[] xlbox = new byte[8];
                if (stream.read(xlbox) != 8) break;
                length = PBoxJPEG2000.convertArrayToLong(xlbox);
                skipped = 16;
            }
            if (length < 0L || !isHeaderReachEnd && (length == 0L || length > leftInHeader)) break;
            long leftInBox = length - (long)skipped;
            if (PBoxJPEG2000.matches(tbox, ihdr)) {
                if (leftInBox != 14L && length != 0L) {
                    LOGGER.warn("Image header content does not contain 14 bytes");
                    break;
                }
                PBoxJPEG2000.skipBytes(stream, 8L);
                byte[] nc = new byte[2];
                if (stream.read(nc) != 2) {
                    LOGGER.warn("Can not read number of components");
                    break;
                }
                long ncColorChannels = PBoxJPEG2000.convertArrayToLong(nc);
                builder.setNrColorChannels(ncColorChannels);
                byte[] bpc = new byte[1];
                if (stream.read(bpc) != 1) {
                    LOGGER.warn("Can not read bitDepth");
                    break;
                }
                long bitDepth = bpc[0] + 1;
                builder.setBitDepth(bitDepth);
                PBoxJPEG2000.skipBytes(stream, 3L);
                continue;
            }
            if (PBoxJPEG2000.matches(tbox, bpcc)) {
                builder.setBpccBoxPresent(Boolean.TRUE);
                PBoxJPEG2000.skipBytes(stream, leftInBox);
                continue;
            }
            if (PBoxJPEG2000.matches(tbox, colr)) {
                if (leftInBox < 3L) {
                    LOGGER.warn("Founded 'colr' box with length less than 3");
                    break;
                }
                nrColorSpaceSpecs = nrColorSpaceSpecs == null ? Long.valueOf(1L) : Long.valueOf(nrColorSpaceSpecs + 1L);
                byte[] meth = new byte[1];
                if (stream.read(meth) != 1) {
                    LOGGER.warn("Can not read METH");
                    break;
                }
                long methValue = PBoxJPEG2000.convertArrayToLong(meth);
                if (firstColrMethod == null) {
                    firstColrMethod = methValue;
                }
                PBoxJPEG2000.skipBytes(stream, 1L);
                byte[] approx = new byte[1];
                if (stream.read(approx) != 1) {
                    LOGGER.warn("Can not read APPROX");
                    break;
                }
                long approxValue = PBoxJPEG2000.convertArrayToLong(approx);
                if (approxValue == 1L) {
                    nrColorSpacesWithApproxField = nrColorSpacesWithApproxField == null ? Long.valueOf(1L) : Long.valueOf(nrColorSpacesWithApproxField + 1L);
                    if (colrMethod == null) {
                        colrMethod = methValue;
                    }
                }
                long read = 3L;
                if (methValue == 1L) {
                    if (leftInBox < 7L) {
                        LOGGER.warn("Founded 'colr' box with meth value 1 and length less than 7");
                        break;
                    }
                    byte[] enumCS = new byte[4];
                    if (stream.read(enumCS) != 4) {
                        LOGGER.warn("Can not read EnumCS");
                        break;
                    }
                    read += 4L;
                    long enumCSValue = PBoxJPEG2000.convertArrayToLong(enumCS);
                    if (firstColrEnumCS == null) {
                        firstColrEnumCS = enumCSValue;
                    }
                    if (approxValue == 1L && colrEnumCS == null) {
                        colrEnumCS = enumCSValue;
                    }
                }
                PBoxJPEG2000.skipBytes(stream, leftInBox - read);
                continue;
            }
            PBoxJPEG2000.skipBytes(stream, leftInBox);
        } while ((!isHeaderReachEnd || length != 0L) && (isHeaderReachEnd || (leftInHeader -= length) != 0L));
        if (nrColorSpaceSpecs != null) {
            builder.setNrColorSpaceSpecs(nrColorSpaceSpecs);
        }
        if (nrColorSpacesWithApproxField != null) {
            builder.setNrColorSpacesWithApproxField(nrColorSpacesWithApproxField);
        }
        if (nrColorSpacesWithApproxField != null) {
            if (colrMethod != null) {
                builder.setColrMethod(colrMethod);
            }
            if (colrEnumCS != null) {
                builder.setColrEnumCS(colrEnumCS);
            }
        } else if (Long.valueOf(1L).equals(nrColorSpaceSpecs)) {
            if (firstColrMethod != null) {
                builder.setColrMethod(firstColrMethod);
            }
            if (firstColrEnumCS != null) {
                builder.setColrEnumCS(firstColrEnumCS);
            }
        }
    }

    private static long findHeader(InputStream stream) throws IOException {
        while (true) {
            byte[] lbox = new byte[4];
            byte[] tbox = new byte[4];
            if (stream.read(lbox) != 4 || stream.read(tbox) != 4) {
                return -1L;
            }
            int skipped = 8;
            long length = PBoxJPEG2000.convertArrayToLong(lbox);
            if (length == 1L) {
                byte[] xlbox = new byte[8];
                if (stream.read(xlbox) != 8) {
                    return -1L;
                }
                length = PBoxJPEG2000.convertArrayToLong(xlbox);
                skipped = 16;
            }
            long left = length - (long)skipped;
            if (PBoxJPEG2000.matches(tbox, header)) {
                if (length == 0L) {
                    return 0L;
                }
                return left <= 0L ? -1L : left;
            }
            if (length == 0L || left < 0L) {
                return -1L;
            }
            PBoxJPEG2000.skipBytes(stream, left);
        }
    }

    private static void skipBytes(InputStream stream, long skipNumber) throws IOException {
        long skippedBytes = stream.skip(skipNumber);
        if (skippedBytes != skipNumber && stream.available() != 0) {
            throw new IllegalStateException("Skipped less bytes that needed.");
        }
    }

    private static long convertArrayToLong(byte[] toConvert) {
        if (toConvert.length < 1 || toConvert.length > 8) {
            throw new IllegalArgumentException("Length of the converting byte array can not be greater than 8");
        }
        long res = 0L;
        for (byte aToConvert : toConvert) {
            res <<= 8;
            res += (long)(aToConvert & 0xFF);
        }
        return res;
    }

    private static boolean isValidSignature(byte[] signature) {
        return PBoxJPEG2000.matches(signature, sign);
    }

    private static boolean matches(byte[] source, byte[] match) {
        if (match.length != source.length) {
            return false;
        }
        for (int i = 0; i < match.length; ++i) {
            if (source[i] == match[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public Long getnrColorChannels() {
        return this.nrColorChannels;
    }

    @Override
    public Long getnrColorSpaceSpecs() {
        return this.nrColorSpaceSpecs;
    }

    @Override
    public Long getnrColorSpacesWithApproxField() {
        return this.nrColorSpacesWithApproxField;
    }

    @Override
    public Long getcolrMethod() {
        return this.colrMethod;
    }

    @Override
    public Long getcolrEnumCS() {
        return this.colrEnumCS;
    }

    @Override
    public Long getbitDepth() {
        return this.bitDepth;
    }

    @Override
    public Boolean getbpccBoxPresent() {
        return this.bpccBoxPresent;
    }

    static /* synthetic */ Long access$100() {
        return DEFAULT_NR_COLOR_CHANNELS;
    }

    static /* synthetic */ Long access$200() {
        return DEFAULT_NR_COLOR_SPACE_SPECS;
    }

    static /* synthetic */ Long access$300() {
        return DEFAULT_NR_COLOR_SPACES_WITH_APPROX_FIELD;
    }

    static /* synthetic */ Long access$400() {
        return DEFAULT_COLR_METHOD;
    }

    static /* synthetic */ Long access$500() {
        return DEFAULT_COLR_ENUM_CS;
    }

    static /* synthetic */ Long access$600() {
        return DEFAULT_BIT_DEPTH;
    }

    static /* synthetic */ Boolean access$700() {
        return DEFAULT_BPCC_BOX_PRESENT;
    }

    private static class Builder {
        private Long nrColorChannels = PBoxJPEG2000.access$100();
        private Long nrColorSpaceSpecs = PBoxJPEG2000.access$200();
        private Long nrColorSpacesWithApproxField = PBoxJPEG2000.access$300();
        private Long colrMethod = PBoxJPEG2000.access$400();
        private Long colrEnumCS = PBoxJPEG2000.access$500();
        private Long bitDepth = PBoxJPEG2000.access$600();
        private Boolean bpccBoxPresent = PBoxJPEG2000.access$700();

        private Builder() {
        }

        public PBoxJPEG2000 build() {
            return new PBoxJPEG2000(this.nrColorChannels, this.nrColorSpaceSpecs, this.nrColorSpacesWithApproxField, this.colrMethod, this.colrEnumCS, this.bitDepth, this.bpccBoxPresent);
        }

        public Long getNrColorChannels() {
            return this.nrColorChannels;
        }

        public Builder setNrColorChannels(Long nrColorChannels) {
            this.nrColorChannels = nrColorChannels;
            return this;
        }

        public Long getNrColorSpaceSpecs() {
            return this.nrColorSpaceSpecs;
        }

        public Builder setNrColorSpaceSpecs(Long nrColorSpaceSpecs) {
            this.nrColorSpaceSpecs = nrColorSpaceSpecs;
            return this;
        }

        public Long getNrColorSpacesWithApproxField() {
            return this.nrColorSpacesWithApproxField;
        }

        public Builder setNrColorSpacesWithApproxField(Long nrColorSpacesWithApproxField) {
            this.nrColorSpacesWithApproxField = nrColorSpacesWithApproxField;
            return this;
        }

        public Long getColrMethod() {
            return this.colrMethod;
        }

        public Builder setColrMethod(Long colrMethod) {
            this.colrMethod = colrMethod;
            return this;
        }

        public Long getColrEnumCS() {
            return this.colrEnumCS;
        }

        public Builder setColrEnumCS(Long colrEnumCS) {
            this.colrEnumCS = colrEnumCS;
            return this;
        }

        public Long getBitDepth() {
            return this.bitDepth;
        }

        public Builder setBitDepth(Long bitDepth) {
            this.bitDepth = bitDepth;
            return this;
        }

        public Boolean getBpccBoxPresent() {
            return this.bpccBoxPresent;
        }

        public Builder setBpccBoxPresent(Boolean bpccBoxPresent) {
            this.bpccBoxPresent = bpccBoxPresent;
            return this;
        }
    }
}

