/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.model.impl.pb.operator.textshow;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSNumber;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.verapdf.model.baselayer.Object;
import org.verapdf.model.coslayer.CosReal;
import org.verapdf.model.factory.operator.GraphicState;
import org.verapdf.model.impl.pb.cos.PBCosReal;
import org.verapdf.model.impl.pb.operator.textshow.PBOpStringTextShow;
import org.verapdf.model.operator.Op_DoubleQuote;
import org.verapdf.model.tools.resources.PDInheritableResources;
import org.verapdf.pdfa.flavours.PDFAFlavour;

public class PBOp_DoubleQuote
extends PBOpStringTextShow
implements Op_DoubleQuote {
    public static final String OP_DOUBLIE_QUOTE_TYPE = "Op_DoubleQuote";
    public static final String WORD_SPACING = "wordSpacing";
    public static final String CHARACTER_SPACING = "characterSpacing";
    public static final int WORD_SPACING_POSITION = 0;
    public static final int CHARACTER_SPACING_POSITION = 1;
    public static final int COUNT_OF_OPERATOR_OPERANDS = 3;

    public PBOp_DoubleQuote(List<COSBase> arguments, GraphicState state, PDInheritableResources resources, PDDocument document, PDFAFlavour flavour) {
        super(arguments, state, resources, OP_DOUBLIE_QUOTE_TYPE, document, flavour);
    }

    @Override
    public List<? extends Object> getLinkedObjects(String link) {
        switch (link) {
            case "wordSpacing": {
                return this.getWordSpacing();
            }
            case "characterSpacing": {
                return this.getCharacterSpacing();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<CosReal> getWordSpacing() {
        return this.getSpecialReal(0);
    }

    private List<CosReal> getCharacterSpacing() {
        return this.getSpecialReal(1);
    }

    private List<CosReal> getSpecialReal(int operandNumber) {
        int index;
        COSBase base;
        int size = this.arguments.size();
        if (size >= 3 && (base = (COSBase)this.arguments.get(index = size - 3 + operandNumber)) instanceof COSNumber) {
            ArrayList<PBCosReal> real = new ArrayList<PBCosReal>(1);
            real.add(new PBCosReal((COSNumber)base));
            return Collections.unmodifiableList(real);
        }
        return Collections.emptyList();
    }
}

