/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.model.impl.pb.pd;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSNumber;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.graphics.form.PDGroup;
import org.apache.pdfbox.pdmodel.interactive.action.PDAction;
import org.apache.pdfbox.pdmodel.interactive.action.PDActionFactory;
import org.apache.pdfbox.pdmodel.interactive.action.PDAnnotationAdditionalActions;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotation;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAppearanceDictionary;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAppearanceEntry;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAppearanceStream;
import org.verapdf.model.coslayer.CosReal;
import org.verapdf.model.impl.pb.cos.PBCosReal;
import org.verapdf.model.impl.pb.pd.PBoxPDContentStream;
import org.verapdf.model.impl.pb.pd.PBoxPDObject;
import org.verapdf.model.impl.pb.pd.actions.PBoxPDAction;
import org.verapdf.model.pdlayer.PDAnnot;
import org.verapdf.model.pdlayer.PDContentStream;
import org.verapdf.model.tools.resources.PDInheritableResources;
import org.verapdf.pdfa.flavours.PDFAFlavour;

public class PBoxPDAnnot
extends PBoxPDObject
implements PDAnnot {
    public static final String ANNOTATION_TYPE = "PDAnnot";
    public static final String DICT = "Dict";
    public static final String STREAM = "Stream";
    public static final String APPEARANCE = "appearance";
    public static final String C = "C";
    public static final String IC = "IC";
    public static final String A = "A";
    public static final String ADDITIONAL_ACTION = "AA";
    public static final int MAX_COUNT_OF_ACTIONS = 10;
    public static final int X_AXIS = 0;
    public static final int Y_AXIS = 1;
    private final PDInheritableResources resources;
    private final boolean isFKeyPresent;
    private final String subtype;
    private final String ap;
    private final int annotationFlag;
    private final Double ca;
    private final String nType;
    private final String ft;
    private final Double width;
    private final Double height;
    private final PDDocument document;
    private final PDFAFlavour flavour;
    private List<PDContentStream> appearance = null;
    private boolean containsTransparency = false;

    public PBoxPDAnnot(PDAnnotation annot, PDInheritableResources resources, PDDocument document, PDFAFlavour flavour) {
        super(annot, ANNOTATION_TYPE);
        this.resources = resources;
        this.subtype = annot.getSubtype();
        this.ap = this.getAP(annot);
        COSDictionary annotDict = annot.getCOSObject();
        this.isFKeyPresent = annotDict.containsKey(COSName.F);
        this.annotationFlag = annot.getAnnotationFlags();
        this.ca = this.getCA(annot);
        this.nType = this.getN_type(annot);
        this.ft = this.getFT(annot);
        this.width = this.getWidth(annot);
        this.height = this.getHeight(annot);
        this.document = document;
        this.flavour = flavour;
    }

    private String getAP(PDAnnotation annot) {
        COSBase apLocal = annot.getCOSObject().getDictionaryObject(COSName.AP);
        if (apLocal != null && apLocal instanceof COSDictionary) {
            StringBuilder result = new StringBuilder();
            for (COSName key : ((COSDictionary)apLocal).keySet()) {
                result.append(key.getName());
                result.append(' ');
            }
            return result.length() <= 0 ? result.toString() : result.substring(0, result.length() - 1);
        }
        return null;
    }

    private Double getCA(PDAnnotation annot) {
        COSBase caLocal = annot.getCOSObject().getDictionaryObject(COSName.CA);
        return !(caLocal instanceof COSNumber) ? null : Double.valueOf(((COSNumber)caLocal).doubleValue());
    }

    private String getN_type(PDAnnotation annot) {
        PDAppearanceDictionary appearanceDictionary = annot.getAppearance();
        if (appearanceDictionary != null) {
            PDAppearanceEntry normalAppearance = appearanceDictionary.getNormalAppearance();
            if (normalAppearance == null) {
                return null;
            }
            if (normalAppearance.isSubDictionary()) {
                return DICT;
            }
            return STREAM;
        }
        return null;
    }

    private String getFT(PDAnnotation annot) {
        COSBase ftLocal = annot.getCOSObject().getDictionaryObject(COSName.FT);
        return ftLocal instanceof COSName ? ((COSName)ftLocal).getName() : null;
    }

    private Double getWidth(PDAnnotation annot) {
        return this.getDifference(annot, 0);
    }

    private Double getHeight(PDAnnotation annot) {
        return this.getDifference(annot, 1);
    }

    private Double getDifference(PDAnnotation annot, int shift) {
        COSBase array = annot.getCOSObject().getDictionaryObject(COSName.RECT);
        if (array instanceof COSArray && ((COSArray)array).size() == 4) {
            COSBase less = ((COSArray)array).getObject(shift);
            COSBase great = ((COSArray)array).getObject(2 + shift);
            if (less instanceof COSNumber && great instanceof COSNumber) {
                return ((COSNumber)great).doubleValue() - ((COSNumber)less).doubleValue();
            }
        }
        return null;
    }

    @Override
    public String getSubtype() {
        return this.subtype;
    }

    @Override
    public String getAP() {
        return this.ap;
    }

    @Override
    public Long getF() {
        return this.isFKeyPresent ? Long.valueOf(this.annotationFlag) : null;
    }

    @Override
    public Double getCA() {
        return this.ca;
    }

    @Override
    public String getN_type() {
        return this.nType;
    }

    @Override
    public String getFT() {
        return this.ft;
    }

    @Override
    public Double getwidth() {
        return this.width;
    }

    @Override
    public Double getheight() {
        return this.height;
    }

    @Override
    public List<? extends org.verapdf.model.baselayer.Object> getLinkedObjects(String link) {
        switch (link) {
            case "AA": {
                return this.getAdditionalActions();
            }
            case "A": {
                return this.getA();
            }
            case "IC": {
                return this.getIC();
            }
            case "C": {
                return this.getC();
            }
            case "appearance": {
                return this.getAppearance();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<org.verapdf.model.pdlayer.PDAction> getAdditionalActions() {
        COSBase actionDictionary = ((PDAnnotation)this.simplePDObject).getCOSObject().getDictionaryObject(COSName.AA);
        if (actionDictionary instanceof COSDictionary) {
            ArrayList<org.verapdf.model.pdlayer.PDAction> actions = new ArrayList<org.verapdf.model.pdlayer.PDAction>(10);
            PDAnnotationAdditionalActions additionalActions = new PDAnnotationAdditionalActions((COSDictionary)actionDictionary);
            PDAction buffer = additionalActions.getBl();
            this.addAction(actions, buffer);
            buffer = additionalActions.getD();
            this.addAction(actions, buffer);
            buffer = additionalActions.getE();
            this.addAction(actions, buffer);
            buffer = additionalActions.getFo();
            this.addAction(actions, buffer);
            buffer = additionalActions.getPC();
            this.addAction(actions, buffer);
            buffer = additionalActions.getPI();
            this.addAction(actions, buffer);
            buffer = additionalActions.getPO();
            this.addAction(actions, buffer);
            buffer = additionalActions.getPV();
            this.addAction(actions, buffer);
            buffer = additionalActions.getU();
            this.addAction(actions, buffer);
            buffer = additionalActions.getX();
            this.addAction(actions, buffer);
            return Collections.unmodifiableList(actions);
        }
        return Collections.emptyList();
    }

    private List<org.verapdf.model.pdlayer.PDAction> getA() {
        PDAction action;
        org.verapdf.model.pdlayer.PDAction result;
        COSBase actionDictionary = ((PDAnnotation)this.simplePDObject).getCOSObject().getDictionaryObject(COSName.A);
        if (actionDictionary instanceof COSDictionary && (result = PBoxPDAction.getAction(action = PDActionFactory.createAction((COSDictionary)actionDictionary))) != null) {
            ArrayList<org.verapdf.model.pdlayer.PDAction> actions = new ArrayList<org.verapdf.model.pdlayer.PDAction>(1);
            actions.add(result);
            return Collections.unmodifiableList(actions);
        }
        return Collections.emptyList();
    }

    private List<CosReal> getIC() {
        return this.getRealsFromArray(COSName.IC);
    }

    private List<CosReal> getC() {
        return this.getRealsFromArray(COSName.C);
    }

    private List<CosReal> getRealsFromArray(COSName arrayName) {
        COSBase colorArray = ((PDAnnotation)this.simplePDObject).getCOSObject().getDictionaryObject(arrayName);
        if (colorArray instanceof COSArray) {
            ArrayList<PBCosReal> color = new ArrayList<PBCosReal>(((COSArray)colorArray).size());
            for (COSBase colorValue : (COSArray)colorArray) {
                if (!(colorValue instanceof COSNumber)) continue;
                color.add(new PBCosReal((COSNumber)colorValue));
            }
            return Collections.unmodifiableList(color);
        }
        return Collections.emptyList();
    }

    private List<PDContentStream> getAppearance() {
        if (this.appearance == null) {
            this.parseAppearance();
        }
        return this.appearance;
    }

    boolean isContainsTransparency() {
        if (this.appearance == null) {
            this.parseAppearance();
        }
        return this.containsTransparency;
    }

    private void parseAppearance() {
        PDAppearanceDictionary appearanceDictionary = ((PDAnnotation)this.simplePDObject).getAppearance();
        if (appearanceDictionary != null) {
            PDAppearanceEntry normalAppearance = appearanceDictionary.getNormalAppearance();
            if (normalAppearance != null) {
                ArrayList<PDContentStream> appearances;
                if (normalAppearance.isStream()) {
                    appearances = new ArrayList<PDContentStream>(1);
                    this.addAppearance(appearances, normalAppearance.getAppearanceStream());
                } else {
                    Map<COSName, PDAppearanceStream> subDictionary = normalAppearance.getSubDictionary();
                    appearances = new ArrayList(subDictionary.size());
                    for (PDAppearanceStream stream : subDictionary.values()) {
                        this.addAppearance(appearances, stream);
                    }
                }
                this.appearance = Collections.unmodifiableList(appearances);
            }
        } else {
            this.appearance = Collections.emptyList();
        }
    }

    private void addAppearance(List<PDContentStream> list, PDAppearanceStream toAdd) {
        PBoxPDContentStream stream = new PBoxPDContentStream(toAdd, this.resources, this.document, this.flavour);
        this.containsTransparency |= stream.isContainsTransparency();
        PDGroup group = toAdd.getGroup();
        this.containsTransparency |= group != null && COSName.TRANSPARENCY.equals(group.getSubType());
        list.add(stream);
    }
}

