/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.model.impl.pb.pd;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorSpace;
import org.apache.pdfbox.pdmodel.interactive.action.PDAction;
import org.apache.pdfbox.pdmodel.interactive.action.PDPageAdditionalActions;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotation;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAppearanceStream;
import org.verapdf.model.coslayer.CosBBox;
import org.verapdf.model.factory.colors.ColorSpaceFactory;
import org.verapdf.model.impl.pb.cos.PBCosBBox;
import org.verapdf.model.impl.pb.pd.PBoxPDAnnot;
import org.verapdf.model.impl.pb.pd.PBoxPDContentStream;
import org.verapdf.model.impl.pb.pd.PBoxPDGroup;
import org.verapdf.model.impl.pb.pd.PBoxPDObject;
import org.verapdf.model.pdlayer.PDAnnot;
import org.verapdf.model.pdlayer.PDContentStream;
import org.verapdf.model.pdlayer.PDGroup;
import org.verapdf.model.pdlayer.PDPage;
import org.verapdf.model.tools.resources.PDInheritableResources;
import org.verapdf.pdfa.flavours.PDFAFlavour;

public class PBoxPDPage
extends PBoxPDObject
implements PDPage {
    private static final Logger LOGGER = Logger.getLogger(PBoxPDPage.class);
    public static final String PAGE_TYPE = "PDPage";
    public static final String ANNOTS = "annots";
    public static final String ACTION = "AA";
    public static final String CONTENT_STREAM = "contentStream";
    public static final String GROUP = "Group";
    public static final String MEDIA_BOX = "MediaBox";
    public static final String CROP_BOX = "CropBox";
    public static final String BLEED_BOX = "BleedBox";
    public static final String TRIM_BOX = "TrimBox";
    public static final String ART_BOX = "ArtBox";
    public static final String PRESENTATION_STEPS = "PresSteps";
    public static final String GROUP_CS = "groupCS";
    public static final int MAX_NUMBER_OF_ACTIONS = 2;
    private boolean containsTransparency = false;
    private List<PDContentStream> contentStreams = null;
    private List<PDAnnot> annotations = null;
    private final PDDocument document;
    private final PDFAFlavour flavour;

    public PBoxPDPage(org.apache.pdfbox.pdmodel.PDPage simplePDObject, PDDocument document, PDFAFlavour flavour) {
        super(simplePDObject, PAGE_TYPE);
        this.document = document;
        this.flavour = flavour;
    }

    @Override
    public Boolean getcontainsPresSteps() {
        COSBase presSteps = ((org.apache.pdfbox.pdmodel.PDPage)this.simplePDObject).getCOSObject().getDictionaryObject(COSName.getPDFName(PRESENTATION_STEPS));
        if (presSteps != null) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    @Override
    public Boolean getcontainsTransparency() {
        if (this.contentStreams == null) {
            this.parseContentStream();
        }
        if (this.annotations == null) {
            this.annotations = this.parseAnnotataions();
        }
        return this.containsTransparency;
    }

    @Override
    public List<? extends org.verapdf.model.baselayer.Object> getLinkedObjects(String link) {
        switch (link) {
            case "Group": {
                return this.getGroup();
            }
            case "annots": {
                return this.getAnnotations();
            }
            case "AA": {
                return this.getActions();
            }
            case "contentStream": {
                return this.getContentStream();
            }
            case "MediaBox": {
                return this.getMediaBox();
            }
            case "CropBox": {
                return this.getCropBox();
            }
            case "BleedBox": {
                return this.getBleedBox();
            }
            case "TrimBox": {
                return this.getTrimBox();
            }
            case "ArtBox": {
                return this.getArtBox();
            }
            case "groupCS": {
                return this.getGroupCS();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<org.verapdf.model.pdlayer.PDColorSpace> getGroupCS() {
        COSDictionary dictionary = ((org.apache.pdfbox.pdmodel.PDPage)this.simplePDObject).getCOSObject();
        COSBase groupDictionary = dictionary.getDictionaryObject(COSName.GROUP);
        if (groupDictionary instanceof COSDictionary) {
            org.apache.pdfbox.pdmodel.graphics.form.PDGroup group = new org.apache.pdfbox.pdmodel.graphics.form.PDGroup((COSDictionary)groupDictionary);
            try {
                PDColorSpace colorSpace = group.getColorSpace();
                if (colorSpace != null) {
                    ArrayList<org.verapdf.model.pdlayer.PDColorSpace> colorSpaces = new ArrayList<org.verapdf.model.pdlayer.PDColorSpace>(1);
                    colorSpaces.add(ColorSpaceFactory.getColorSpace(colorSpace, this.document, this.flavour));
                    return Collections.unmodifiableList(colorSpaces);
                }
            }
            catch (IOException e) {
                LOGGER.debug("Can not obtain group colorSpace", e);
                return Collections.emptyList();
            }
        }
        return Collections.emptyList();
    }

    private List<PDGroup> getGroup() {
        COSDictionary dictionary = ((org.apache.pdfbox.pdmodel.PDPage)this.simplePDObject).getCOSObject();
        COSBase groupDictionary = dictionary.getDictionaryObject(COSName.GROUP);
        if (groupDictionary instanceof COSDictionary) {
            ArrayList<PBoxPDGroup> groups = new ArrayList<PBoxPDGroup>(1);
            org.apache.pdfbox.pdmodel.graphics.form.PDGroup group = new org.apache.pdfbox.pdmodel.graphics.form.PDGroup((COSDictionary)groupDictionary);
            groups.add(new PBoxPDGroup(group, this.document, this.flavour));
            return Collections.unmodifiableList(groups);
        }
        return Collections.emptyList();
    }

    private List<PDContentStream> getContentStream() {
        if (this.contentStreams == null) {
            this.parseContentStream();
        }
        return this.contentStreams;
    }

    private void parseContentStream() {
        this.contentStreams = new ArrayList<PDContentStream>(1);
        org.apache.pdfbox.pdmodel.PDPage stream = (org.apache.pdfbox.pdmodel.PDPage)this.simplePDObject;
        PDInheritableResources resources = PDInheritableResources.getInstance(stream.getResources(), PDInheritableResources.EMPTY_RESOURCES);
        PBoxPDContentStream contentStream = new PBoxPDContentStream(stream, resources, this.document, this.flavour);
        this.contentStreams.add(contentStream);
        this.containsTransparency = contentStream.isContainsTransparency();
    }

    private List<org.verapdf.model.pdlayer.PDAction> getActions() {
        PDPageAdditionalActions pbActions = ((org.apache.pdfbox.pdmodel.PDPage)this.simplePDObject).getActions();
        if (pbActions != null) {
            ArrayList<org.verapdf.model.pdlayer.PDAction> actions = new ArrayList<org.verapdf.model.pdlayer.PDAction>(2);
            PDAction action = pbActions.getC();
            this.addAction(actions, action);
            action = pbActions.getO();
            this.addAction(actions, action);
            return Collections.unmodifiableList(actions);
        }
        return Collections.emptyList();
    }

    private List<PDAnnot> getAnnotations() {
        if (this.annotations == null) {
            this.annotations = this.parseAnnotataions();
        }
        return this.annotations;
    }

    private List<PDAnnot> parseAnnotataions() {
        try {
            List<PDAnnotation> pdfboxAnnotations = ((org.apache.pdfbox.pdmodel.PDPage)this.simplePDObject).getAnnotations();
            if (pdfboxAnnotations != null) {
                ArrayList<PDAnnot> annotations = new ArrayList<PDAnnot>(pdfboxAnnotations.size());
                this.addAllAnnotations(annotations, pdfboxAnnotations);
                return Collections.unmodifiableList(annotations);
            }
        }
        catch (IOException e) {
            LOGGER.error("Problems in obtaining pdfbox PDAnnotations. " + e.getMessage(), e);
        }
        return Collections.emptyList();
    }

    private void addAllAnnotations(List<PDAnnot> annotations, List<PDAnnotation> pdfboxAnnotations) {
        PDResources pageResources = ((org.apache.pdfbox.pdmodel.PDPage)this.simplePDObject).getResources();
        for (PDAnnotation annotation : pdfboxAnnotations) {
            if (annotation == null) continue;
            PDAppearanceStream stream = annotation.getNormalAppearanceStream();
            PDResources resources = stream != null ? stream.getResources() : PDInheritableResources.EMPTY_RESOURCES;
            PDInheritableResources extRes = PDInheritableResources.getInstance(pageResources, resources);
            PBoxPDAnnot annot = new PBoxPDAnnot(annotation, extRes, this.document, this.flavour);
            this.containsTransparency |= annot.isContainsTransparency();
            annotations.add(annot);
        }
    }

    private List<CosBBox> getMediaBox() {
        return this.getCosBBox(COSName.MEDIA_BOX);
    }

    private List<CosBBox> getCropBox() {
        return this.getCosBBox(COSName.CROP_BOX);
    }

    private List<CosBBox> getBleedBox() {
        return this.getCosBBox(COSName.BLEED_BOX);
    }

    private List<CosBBox> getTrimBox() {
        return this.getCosBBox(COSName.TRIM_BOX);
    }

    private List<CosBBox> getArtBox() {
        return this.getCosBBox(COSName.ART_BOX);
    }

    private List<CosBBox> getCosBBox(COSName key) {
        COSBase array = ((org.apache.pdfbox.pdmodel.PDPage)this.simplePDObject).getCOSObject().getDictionaryObject(key);
        if (array instanceof COSArray) {
            ArrayList<PBCosBBox> list = new ArrayList<PBCosBBox>(1);
            list.add(new PBCosBBox((COSArray)array, this.document, this.flavour));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }
}

