/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.model.impl.pb.pd.colors;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorSpace;
import org.apache.pdfbox.pdmodel.graphics.color.PDSeparation;
import org.verapdf.model.baselayer.Object;
import org.verapdf.model.coslayer.CosUnicodeName;
import org.verapdf.model.factory.colors.ColorSpaceFactory;
import org.verapdf.model.impl.pb.cos.PBCosUnicodeName;
import org.verapdf.model.impl.pb.pd.colors.PBoxPDColorSpace;
import org.verapdf.pdfa.flavours.PDFAFlavour;

public class PBoxPDSeparation
extends PBoxPDColorSpace
implements org.verapdf.model.pdlayer.PDSeparation {
    public static final String SEPARATION_TYPE = "PDSeparation";
    public static final String ALTERNATE = "alternate";
    public static final String COLORANT_NAME = "colorantName";
    public static final int COLORANT_NAME_POSITION = 1;
    private final PDDocument document;
    private final PDFAFlavour flavour;

    public PBoxPDSeparation(PDSeparation simplePDObject, PDDocument document, PDFAFlavour flavour) {
        super(simplePDObject, SEPARATION_TYPE);
        this.document = document;
        this.flavour = flavour;
    }

    @Override
    public Boolean getareTintAndAlternateConsistent() {
        return Boolean.FALSE;
    }

    @Override
    public List<? extends Object> getLinkedObjects(String link) {
        switch (link) {
            case "alternate": {
                return this.getAlternate();
            }
            case "colorantName": {
                return this.getColorantName();
            }
        }
        return super.getLinkedObjects(link);
    }

    public List<org.verapdf.model.pdlayer.PDColorSpace> getAlternate() {
        PDColorSpace space = ((PDSeparation)this.simplePDObject).getAlternateColorSpace();
        org.verapdf.model.pdlayer.PDColorSpace currentSpace = ColorSpaceFactory.getColorSpace(space, this.document, this.flavour);
        if (currentSpace != null) {
            ArrayList<org.verapdf.model.pdlayer.PDColorSpace> colorSpace = new ArrayList<org.verapdf.model.pdlayer.PDColorSpace>(1);
            colorSpace.add(currentSpace);
            return Collections.unmodifiableList(colorSpace);
        }
        return Collections.emptyList();
    }

    private List<CosUnicodeName> getColorantName() {
        COSBase object;
        COSArray array = (COSArray)this.simplePDObject.getCOSObject();
        if (array.size() > 1 && (object = array.getObject(1)) instanceof COSName) {
            ArrayList<PBCosUnicodeName> list = new ArrayList<PBCosUnicodeName>(1);
            list.add(new PBCosUnicodeName((COSName)object));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }
}

