/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.model.tools;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSObject;
import org.verapdf.model.impl.pb.pd.PBoxPDStructElem;
import org.verapdf.model.pdlayer.PDStructElem;

public class TaggedPDFHelper {
    private static final int MAX_NUMBER_OF_ELEMENTS = 1;

    private TaggedPDFHelper() {
    }

    public static List<PDStructElem> getChildren(COSDictionary parent, Logger logger) {
        COSBase children = parent.getDictionaryObject(COSName.K);
        if (children == null) {
            return Collections.emptyList();
        }
        if (children instanceof COSDictionary) {
            ArrayList<PBoxPDStructElem> list = new ArrayList<PBoxPDStructElem>(1);
            list.add(new PBoxPDStructElem((COSDictionary)children));
            return Collections.unmodifiableList(list);
        }
        if (children instanceof COSArray) {
            return TaggedPDFHelper.getChildrenFromArray((COSArray)children, logger);
        }
        logger.warn("Children type of Structure Tree Root or Structure Element must be 'COSDictionary' or 'COSArray' but got: " + children.getClass().getSimpleName());
        return Collections.emptyList();
    }

    public static List<PDStructElem> getChildrenFromArray(COSArray children, Logger logger) {
        if (children.size() > 0) {
            ArrayList<PBoxPDStructElem> list = new ArrayList<PBoxPDStructElem>(children.size());
            for (COSBase element : children) {
                COSBase directElement;
                if (element instanceof COSDictionary) {
                    list.add(new PBoxPDStructElem((COSDictionary)element));
                    continue;
                }
                if (element instanceof COSObject && (directElement = ((COSObject)element).getObject()) instanceof COSDictionary) {
                    list.add(new PBoxPDStructElem((COSDictionary)directElement));
                    continue;
                }
                logger.warn("Children type of Structure Tree Root or Structure Element in array must be 'COSDictionary' but got: " + children.getClass().getSimpleName());
            }
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }
}

