/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.pdfa.results;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Set;
import javax.xml.bind.JAXBException;
import org.verapdf.pdfa.flavours.PDFAFlavour;
import org.verapdf.pdfa.results.Location;
import org.verapdf.pdfa.results.LocationImpl;
import org.verapdf.pdfa.results.TestAssertion;
import org.verapdf.pdfa.results.TestAssertionImpl;
import org.verapdf.pdfa.results.ValidationResult;
import org.verapdf.pdfa.results.ValidationResultImpl;
import org.verapdf.pdfa.validation.RuleId;

public class ValidationResults {
    private static final String NOT_NULL_MESSAGE = " cannot be null.";
    private static final String FLAVOUR_NOT_NULL_MESSAGE = "Flavour  cannot be null.";
    private static final String ASSERTIONS_NOT_NULL_MESSAGE = "Assertions  cannot be null.";

    private ValidationResults() {
        throw new AssertionError((Object)"Should never enter ValidationResults().");
    }

    public static ValidationResult resultFromValues(PDFAFlavour flavour, Set<TestAssertion> assertions, boolean isCompliant) {
        if (flavour == null) {
            throw new NullPointerException(FLAVOUR_NOT_NULL_MESSAGE);
        }
        if (assertions == null) {
            throw new NullPointerException(ASSERTIONS_NOT_NULL_MESSAGE);
        }
        return ValidationResultImpl.fromValues(flavour, assertions, isCompliant, assertions.size());
    }

    public static ValidationResult resultFromValues(PDFAFlavour flavour, Set<TestAssertion> assertions, boolean isCompliant, int totalAssertions) {
        if (flavour == null) {
            throw new NullPointerException(FLAVOUR_NOT_NULL_MESSAGE);
        }
        if (assertions == null) {
            throw new NullPointerException(ASSERTIONS_NOT_NULL_MESSAGE);
        }
        return ValidationResultImpl.fromValues(flavour, assertions, isCompliant, totalAssertions);
    }

    public static ValidationResult resultFromValues(PDFAFlavour flavour, Set<TestAssertion> assertions) {
        if (flavour == null) {
            throw new NullPointerException(FLAVOUR_NOT_NULL_MESSAGE);
        }
        if (assertions == null) {
            throw new NullPointerException(ASSERTIONS_NOT_NULL_MESSAGE);
        }
        boolean isCompliant = true;
        for (TestAssertion assertion : assertions) {
            if (assertion.getStatus() != TestAssertion.Status.FAILED) continue;
            isCompliant = false;
            break;
        }
        return ValidationResults.resultFromValues(flavour, assertions, isCompliant);
    }

    public static ValidationResult defaultResult() {
        return ValidationResultImpl.defaultInstance();
    }

    public static TestAssertion assertionFromValues(int ordinal, RuleId ruleId, TestAssertion.Status status, String message, Location location) {
        return TestAssertionImpl.fromValues(ordinal, ruleId, status, message, location);
    }

    public static TestAssertion defaultAssertion() {
        return TestAssertionImpl.defaultInstance();
    }

    public static Location locationFromValues(String level, String context) {
        return LocationImpl.fromValues(level, context);
    }

    public static Location defaultLocation() {
        return LocationImpl.defaultInstance();
    }

    public static String resultToXml(ValidationResult toConvert, Boolean prettyXml) throws JAXBException, IOException {
        String retVal = "";
        try (StringWriter writer = new StringWriter();){
            ValidationResults.toXml(toConvert, writer, prettyXml);
            String string = retVal = writer.toString();
            return string;
        }
    }

    public static ValidationResult fromXml(String toConvert) throws JAXBException {
        try (StringReader reader = new StringReader(toConvert);){
            ValidationResult validationResult = ValidationResults.fromXml(reader);
            return validationResult;
        }
    }

    public static void toXml(ValidationResult toConvert, OutputStream stream, Boolean prettyXml) throws JAXBException {
        ValidationResultImpl.toXml(toConvert, stream, prettyXml);
    }

    public static ValidationResult fromXml(InputStream toConvert) throws JAXBException {
        return ValidationResultImpl.fromXml(toConvert);
    }

    public static void toXml(ValidationResult toConvert, Writer writer, Boolean prettyXml) throws JAXBException {
        ValidationResultImpl.toXml(toConvert, writer, prettyXml);
    }

    public static ValidationResult fromXml(Reader toConvert) throws JAXBException {
        return ValidationResultImpl.fromXml(toConvert);
    }

    public static String getValidationResultSchema() throws JAXBException, IOException {
        return ValidationResultImpl.getSchema();
    }

    public static ValidationResult stripPassedTests(ValidationResult toStrip) {
        if (toStrip == null) {
            throw new NullPointerException("toStrip can not be null.");
        }
        return ValidationResultImpl.stripPassedTests(toStrip);
    }
}

