/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.pdfa.validation;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import javax.xml.bind.JAXBException;
import org.verapdf.pdfa.flavours.PDFAFlavour;
import org.verapdf.pdfa.validation.ErrorDetails;
import org.verapdf.pdfa.validation.ErrorDetailsImpl;
import org.verapdf.pdfa.validation.ProfileDetails;
import org.verapdf.pdfa.validation.ProfileDetailsImpl;
import org.verapdf.pdfa.validation.ProfileDirectory;
import org.verapdf.pdfa.validation.ProfileDirectoryImpl;
import org.verapdf.pdfa.validation.Reference;
import org.verapdf.pdfa.validation.ReferenceImpl;
import org.verapdf.pdfa.validation.Rule;
import org.verapdf.pdfa.validation.RuleId;
import org.verapdf.pdfa.validation.RuleIdImpl;
import org.verapdf.pdfa.validation.RuleImpl;
import org.verapdf.pdfa.validation.ValidationProfile;
import org.verapdf.pdfa.validation.ValidationProfileImpl;
import org.verapdf.pdfa.validation.Variable;
import org.verapdf.pdfa.validation.VariableImpl;

public final class Profiles {
    public static ValidationProfile profileFromValues(PDFAFlavour flavour, ProfileDetails details, String hash, Set<Rule> rules, Set<Variable> variables) {
        if (flavour == null) {
            throw new IllegalArgumentException("Parameter flavour can not be null.");
        }
        if (details == null) {
            throw new IllegalArgumentException("Parameter name can not be null.");
        }
        if (hash == null) {
            throw new IllegalArgumentException("Parameter hash can not be null.");
        }
        if (rules == null) {
            throw new IllegalArgumentException("Parameter rules can not be null.");
        }
        if (variables == null) {
            throw new IllegalArgumentException("Parameter variables can not be null.");
        }
        return ValidationProfileImpl.fromValues(flavour, details, hash, rules, variables);
    }

    public static ValidationProfile profileFromSortedValues(PDFAFlavour flavour, ProfileDetails details, String hash, SortedSet<Rule> rules, Set<Variable> variables) {
        if (flavour == null) {
            throw new IllegalArgumentException("Parameter flavour can not be null.");
        }
        if (details == null) {
            throw new IllegalArgumentException("Parameter name can not be null.");
        }
        if (hash == null) {
            throw new IllegalArgumentException("Parameter hash can not be null.");
        }
        if (rules == null) {
            throw new IllegalArgumentException("Parameter rules can not be null.");
        }
        if (variables == null) {
            throw new IllegalArgumentException("Parameter variables can not be null.");
        }
        return ValidationProfileImpl.fromSortedValues(flavour, details, hash, rules, variables);
    }

    public static ValidationProfile defaultProfile() {
        return ValidationProfileImpl.defaultInstance();
    }

    public static ProfileDetails profileDetailsFromValues(String name, String description, String creator, Date created) {
        return ProfileDetailsImpl.fromValues(name, description, creator, created);
    }

    public static Reference defaultReference() {
        return ReferenceImpl.defaultInstance();
    }

    public static Reference referenceFromValues(String specification, String clause) {
        if (specification == null) {
            throw new IllegalArgumentException("Parameter specification can not be null.");
        }
        if (specification.isEmpty()) {
            throw new IllegalArgumentException("Parameter specification can not be empty.");
        }
        if (clause == null) {
            throw new IllegalArgumentException("Parameter clause can not be null.");
        }
        return ReferenceImpl.fromValues(specification, clause);
    }

    public static RuleId defaultRuleId() {
        return RuleIdImpl.defaultInstance();
    }

    public static RuleId ruleIdFromValues(PDFAFlavour.Specification specification, String clause, int testNumber) {
        if (specification == null) {
            throw new IllegalArgumentException("Parameter specification can not be null.");
        }
        if (clause == null) {
            throw new IllegalArgumentException("Parameter clause can not be null.");
        }
        if (clause.isEmpty()) {
            throw new IllegalArgumentException("Parameter clause can not be empty.");
        }
        return RuleIdImpl.fromValues(specification, clause, testNumber);
    }

    public static Rule defaultRule() {
        return RuleImpl.defaultInstance();
    }

    public static ErrorDetails defaultError() {
        return ErrorDetailsImpl.defaultInstance();
    }

    public static ErrorDetails errorFromValues(String message, List<String> arguments) {
        if (message == null) {
            throw new IllegalArgumentException("Parameter message can not be null.");
        }
        if (message.isEmpty()) {
            throw new IllegalArgumentException("Parameter message can not be empty.");
        }
        if (arguments == null) {
            throw new IllegalArgumentException("Parameter arguments can not be null.");
        }
        return ErrorDetailsImpl.fromValues(message, arguments);
    }

    public static Rule ruleFromValues(RuleId id, String object, String description, String test, ErrorDetails error, List<Reference> references) {
        if (id == null) {
            throw new IllegalArgumentException("Parameter id can not be null.");
        }
        if (object == null) {
            throw new IllegalArgumentException("Parameter object can not be null.");
        }
        if (object.isEmpty()) {
            throw new IllegalArgumentException("Parameter object can not be empty.");
        }
        if (description == null) {
            throw new IllegalArgumentException("Parameter description can not be null.");
        }
        if (description.isEmpty()) {
            throw new IllegalArgumentException("Parameter description can not be empty.");
        }
        if (test == null) {
            throw new IllegalArgumentException("Parameter test can not be null.");
        }
        if (test.isEmpty()) {
            throw new IllegalArgumentException("Parameter test can not be empty.");
        }
        if (error == null) {
            throw new IllegalArgumentException("Parameter error can not be null.");
        }
        if (references == null) {
            throw new IllegalArgumentException("Parameter references can not be null.");
        }
        return RuleImpl.fromValues(RuleIdImpl.fromRuleId(id), object, description, test, error, references);
    }

    public static Variable defaultVariable() {
        return VariableImpl.defaultInstance();
    }

    public static Variable variableFromValues(String name, String object, String defaultValue, String value) {
        if (name == null) {
            throw new IllegalArgumentException("Parameter name cannot be null");
        }
        if (name.isEmpty()) {
            throw new IllegalArgumentException("Parameter name cannot be empty");
        }
        if (object == null) {
            throw new IllegalArgumentException("Parameter object cannot be null");
        }
        if (object.isEmpty()) {
            throw new IllegalArgumentException("Parameter object cannot be empty");
        }
        if (defaultValue == null) {
            throw new IllegalArgumentException("Parameter defaultValue cannot be null");
        }
        if (defaultValue.isEmpty()) {
            throw new IllegalArgumentException("Parameter defaultValue cannot be empty");
        }
        if (value == null) {
            throw new IllegalArgumentException("Parameter value cannot be null");
        }
        if (value.isEmpty()) {
            throw new IllegalArgumentException("Parameter value cannot be empty");
        }
        return VariableImpl.fromValues(name, object, defaultValue, value);
    }

    public static String profileToXml(ValidationProfile toConvert, Boolean prettyXml) throws JAXBException, IOException {
        if (toConvert == null) {
            throw new IllegalArgumentException("Parameter toConvert cannot be null");
        }
        return ValidationProfileImpl.toXml(toConvert, prettyXml);
    }

    public static void profileToXml(ValidationProfile toConvert, OutputStream forXmlOutput, Boolean prettyXml) throws JAXBException {
        if (toConvert == null) {
            throw new IllegalArgumentException("Parameter toConvert cannot be null");
        }
        ValidationProfileImpl.toXml(toConvert, forXmlOutput, prettyXml);
    }

    public static ValidationProfile profileFromXml(InputStream toConvert) throws JAXBException {
        if (toConvert == null) {
            throw new IllegalArgumentException("Parameter toConvert cannot be null");
        }
        return ValidationProfileImpl.fromXml(toConvert);
    }

    public static void profileToXml(ValidationProfile toConvert, Writer forXmlOutput, Boolean prettyXml) throws JAXBException {
        if (toConvert == null) {
            throw new IllegalArgumentException("Parameter toConvert cannot be null");
        }
        ValidationProfileImpl.toXml(toConvert, forXmlOutput, prettyXml);
    }

    public static ProfileDirectory directoryFromProfiles(Set<ValidationProfile> profiles) {
        if (profiles == null) {
            throw new IllegalArgumentException("Parameter profiles cannot be null.");
        }
        if (profiles.isEmpty()) {
            throw new IllegalArgumentException("Parameter profiles cannot be empty.");
        }
        return ProfileDirectoryImpl.fromProfileSet(profiles);
    }

    public static ProfileDirectory getVeraProfileDirectory() {
        return ProfileDirectoryImpl.getVeraProfileDirectory();
    }

    public static String getValidationProfileSchema() throws JAXBException, IOException {
        return ValidationProfileImpl.getSchema();
    }

    public static class RuleComparator
    implements Comparator<Rule> {
        @Override
        public int compare(Rule firstRule, Rule secondRule) {
            return new RuleIdComparator().compare(firstRule.getRuleId(), secondRule.getRuleId());
        }
    }

    public static class RuleIdComparator
    implements Comparator<RuleId> {
        @Override
        public int compare(RuleId firstId, RuleId secondId) {
            if (firstId.getClause().equals(secondId.getClause())) {
                return firstId.getTestNumber() - secondId.getTestNumber();
            }
            String[] o1StrArr = firstId.getClause().split("\\.");
            String[] o2StrArr = secondId.getClause().split("\\.");
            int min = Math.min(o1StrArr.length, o2StrArr.length);
            for (int i = 0; i < min; ++i) {
                if (o1StrArr[i].equals(o2StrArr[i])) continue;
                return Integer.parseInt(o1StrArr[i]) - Integer.parseInt(o2StrArr[i]);
            }
            return o1StrArr.length - o2StrArr.length;
        }
    }
}

