/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.pdfa.validation;

import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.verapdf.pdfa.validation.Reference;

@XmlRootElement(name="reference")
final class ReferenceImpl
implements Reference {
    private static final ReferenceImpl DEFAULT = new ReferenceImpl();
    @XmlAttribute
    private final String specification;
    @XmlAttribute
    private final String clause;

    private ReferenceImpl() {
        this("specification", "clause");
    }

    private ReferenceImpl(String specification, String clause) {
        this.specification = specification;
        this.clause = clause;
    }

    @Override
    public String getSpecification() {
        return this.specification;
    }

    @Override
    public String getClause() {
        return this.clause;
    }

    public final int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.clause == null ? 0 : this.clause.hashCode());
        result = 31 * result + (this.specification == null ? 0 : this.specification.hashCode());
        return result;
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Reference)) {
            return false;
        }
        Reference other = (Reference)obj;
        if (this.clause == null ? other.getClause() != null : !this.clause.equals(other.getClause())) {
            return false;
        }
        return !(this.specification == null ? other.getSpecification() != null : !this.specification.equals(other.getSpecification()));
    }

    public final String toString() {
        return "Reference [specification=" + this.specification + ", clause=" + this.clause + "]";
    }

    static ReferenceImpl defaultInstance() {
        return DEFAULT;
    }

    static ReferenceImpl fromValues(String specification, String clause) {
        return new ReferenceImpl(specification, clause);
    }

    static ReferenceImpl fromReference(Reference toConvert) {
        return new ReferenceImpl(toConvert.getSpecification(), toConvert.getClause());
    }

    static String toXml(Reference toConvert) throws JAXBException {
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{ReferenceImpl.class});
        Marshaller varMarshaller = context.createMarshaller();
        varMarshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        StringWriter writer = new StringWriter();
        varMarshaller.marshal((Object)toConvert, (Writer)writer);
        return writer.toString();
    }

    static ReferenceImpl fromXml(String toConvert) throws JAXBException {
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{ReferenceImpl.class});
        Unmarshaller stringUnmarshaller = context.createUnmarshaller();
        StringReader reader = new StringReader(toConvert);
        return (ReferenceImpl)stringUnmarshaller.unmarshal((Reader)reader);
    }

    static class Adapter
    extends XmlAdapter<ReferenceImpl, Reference> {
        Adapter() {
        }

        public Reference unmarshal(ReferenceImpl refImpl) {
            return refImpl;
        }

        public ReferenceImpl marshal(Reference ref) {
            return (ReferenceImpl)ref;
        }
    }
}

