/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.pdfa.validators;

import org.verapdf.pdfa.PDFAValidator;
import org.verapdf.pdfa.flavours.PDFAFlavour;
import org.verapdf.pdfa.validation.Profiles;
import org.verapdf.pdfa.validation.ValidationProfile;
import org.verapdf.pdfa.validators.BaseValidator;
import org.verapdf.pdfa.validators.FastFailValidator;

public final class Validators {
    private Validators() {
    }

    public static PDFAValidator createValidator(PDFAFlavour flavour, boolean logPassedChecks) {
        if (flavour == null) {
            throw new IllegalArgumentException("Parameter (PDFAFlavour flavour) cannot be null.");
        }
        return Validators.createValidator(Profiles.getVeraProfileDirectory().getValidationProfileByFlavour(flavour), logPassedChecks);
    }

    public static PDFAValidator createValidator(PDFAFlavour flavour, boolean logPassedChecks, int maxFailures) {
        if (flavour == null) {
            throw new IllegalArgumentException("Parameter (PDFAFlavour flavour) cannot be null.");
        }
        return Validators.createValidator(Profiles.getVeraProfileDirectory().getValidationProfileByFlavour(flavour), logPassedChecks, maxFailures);
    }

    public static PDFAValidator createValidator(ValidationProfile profile) {
        return Validators.createValidator(profile, false);
    }

    public static PDFAValidator createValidator(ValidationProfile profile, boolean logPassedChecks) {
        if (profile == null) {
            throw new IllegalArgumentException("Parameter (ValidationProfile profile) cannot be null.");
        }
        return new BaseValidator(profile, logPassedChecks);
    }

    public static PDFAValidator createValidator(ValidationProfile profile, int maxFailures) {
        return Validators.createValidator(profile, false, maxFailures);
    }

    public static PDFAValidator createValidator(ValidationProfile profile, boolean logPassedChecks, int maxFailures) {
        if (profile == null) {
            throw new IllegalArgumentException("Parameter (ValidationProfile profile) cannot be null.");
        }
        if (maxFailures > 0) {
            return new FastFailValidator(profile, logPassedChecks, maxFailures);
        }
        return Validators.createValidator(profile, logPassedChecks);
    }
}

