/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.processor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.verapdf.processor.config.Config;

public class ProcessingResult {
    private ValidationSummary validationSummary;
    private MetadataFixingSummary metadataFixerSummary;
    private FeaturesSummary featuresSummary;
    private ReportSummary reportSummary;
    private List<String> errorMessages = new ArrayList<String>();

    ProcessingResult(Config config) {
        this.validationSummary = config.getProcessingType().isValidating() ? ValidationSummary.FILE_VALID : ValidationSummary.VALIDATION_DISABLED;
        this.metadataFixerSummary = config.isFixMetadata() ? MetadataFixingSummary.FIXING_SUCCEED : MetadataFixingSummary.FIXING_DISABLED;
        this.featuresSummary = config.getProcessingType().isFeatures() ? FeaturesSummary.FEATURES_SUCCEED : FeaturesSummary.FEATURES_DISABLED;
        this.reportSummary = ReportSummary.REPORT_SUCCEED;
    }

    public ValidationSummary getValidationSummary() {
        return this.validationSummary;
    }

    public MetadataFixingSummary getMetadataFixerSummary() {
        return this.metadataFixerSummary;
    }

    public FeaturesSummary getFeaturesSummary() {
        return this.featuresSummary;
    }

    public ReportSummary getReportSummary() {
        return this.reportSummary;
    }

    public List<String> getErrorMessages() {
        return Collections.unmodifiableList(this.errorMessages);
    }

    void setValidationSummary(ValidationSummary validationSummary) {
        this.validationSummary = validationSummary;
    }

    void setReportSummary(ReportSummary reportSummary) {
        this.reportSummary = reportSummary;
    }

    void setMetadataFixerSummary(MetadataFixingSummary metadataFixerSummary) {
        this.metadataFixerSummary = metadataFixerSummary;
    }

    void setFeaturesSummary(FeaturesSummary featuresSummary) {
        this.featuresSummary = featuresSummary;
    }

    void addErrorMessage(String message) {
        this.errorMessages.add(message);
    }

    public static enum ReportSummary {
        REPORT_SUCCEED,
        ERROR_IN_REPORT;

    }

    public static enum FeaturesSummary {
        FEATURES_SUCCEED,
        ERROR_IN_FEATURES,
        FEATURES_DISABLED;

    }

    public static enum MetadataFixingSummary {
        FIXING_SUCCEED,
        ERROR_IN_FIXING,
        FIXING_DISABLED;

    }

    public static enum ValidationSummary {
        FILE_VALID,
        FILE_NOT_VALID,
        ERROR_IN_VALIDATION,
        VALIDATION_DISABLED;

    }
}

