/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.processor.config;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.log4j.Logger;
import org.verapdf.pdfa.flavours.PDFAFlavour;
import org.verapdf.processor.config.FormatOption;
import org.verapdf.processor.config.ProcessingType;

@XmlRootElement(name="config")
public final class Config {
    private static final char[] FORBIDDEN_SYMBOLS_IN_FILE_NAME = new char[]{'\\', '/', ':', '*', '?', '\"', '<', '>', '|', '+', '\u0000', '%'};
    public static final int DEFAULT_MAX_NUMBER_OF_FAILED_CHECKS = -1;
    public static final boolean DEFAULT_SHOW_PASSED_RULES = false;
    public static final int DEFAULT_MAX_NUMBER_OF_DISPLAYED_FAILED_CHECKS = 100;
    public static final String DEFAULT_METADATA_FIXER_PREFIX = "veraPDF_";
    public static final Path DEFAULT_FIX_METADATA_PATH_FOLDER = FileSystems.getDefault().getPath("", new String[0]);
    public static final String DEFAULT_PROFILES_WIKI_PATH = "https://github.com/veraPDF/veraPDF-validation-profiles/wiki";
    public static final boolean DEFAULT_IS_FIX_METADATA = false;
    public static final ProcessingType DEFAULT_PROCESSING_TYPE = ProcessingType.VALIDATING_AND_FEATURES;
    public static final FormatOption DEFAULT_REPORT_TYPE = FormatOption.MRR;
    public static final Path DEFAULT_VALIDATION_PROFILE_PATH = FileSystems.getDefault().getPath("", new String[0]);
    public static final PDFAFlavour DEFAULT_FLAVOUR = PDFAFlavour.PDFA_1_B;
    public static final boolean DEFAULT_VERBOSE_CLI = false;
    public static final boolean DEFAULT_PLUGINS_ENABLED = false;
    private boolean showPassedRules = false;
    private int maxNumberOfFailedChecks = -1;
    private int maxNumberOfDisplayedFailedChecks = 100;
    private String metadataFixerPrefix = "veraPDF_";
    private Path fixMetadataPathFolder = DEFAULT_FIX_METADATA_PATH_FOLDER;
    private String profileWikiPath = "https://github.com/veraPDF/veraPDF-validation-profiles/wiki";
    private ProcessingType processingType = DEFAULT_PROCESSING_TYPE;
    private boolean isFixMetadata = false;
    private FormatOption reportType = DEFAULT_REPORT_TYPE;
    private Path validationProfilePath = DEFAULT_VALIDATION_PROFILE_PATH;
    private PDFAFlavour flavour = DEFAULT_FLAVOUR;
    private boolean verboseCli = false;
    private boolean pluginsEnabled = false;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Config config = (Config)o;
        if (this.showPassedRules != config.showPassedRules) {
            return false;
        }
        if (this.maxNumberOfFailedChecks != config.maxNumberOfFailedChecks) {
            return false;
        }
        if (this.maxNumberOfDisplayedFailedChecks != config.maxNumberOfDisplayedFailedChecks) {
            return false;
        }
        if (this.isFixMetadata != config.isFixMetadata) {
            return false;
        }
        if (this.verboseCli != config.verboseCli) {
            return false;
        }
        if (this.pluginsEnabled != config.pluginsEnabled) {
            return false;
        }
        if (this.metadataFixerPrefix != null ? !this.metadataFixerPrefix.equals(config.metadataFixerPrefix) : config.metadataFixerPrefix != null) {
            return false;
        }
        if (this.fixMetadataPathFolder != null ? !this.fixMetadataPathFolder.equals(config.fixMetadataPathFolder) : config.fixMetadataPathFolder != null) {
            return false;
        }
        if (this.profileWikiPath != null ? !this.profileWikiPath.equals(config.profileWikiPath) : config.profileWikiPath != null) {
            return false;
        }
        if (this.processingType != config.processingType) {
            return false;
        }
        if (this.reportType != config.reportType) {
            return false;
        }
        if (this.validationProfilePath != null ? !this.validationProfilePath.equals(config.validationProfilePath) : config.validationProfilePath != null) {
            return false;
        }
        return this.flavour == config.flavour;
    }

    public int hashCode() {
        int result = this.showPassedRules ? 1 : 0;
        result = 31 * result + this.maxNumberOfFailedChecks;
        result = 31 * result + this.maxNumberOfDisplayedFailedChecks;
        result = 31 * result + (this.metadataFixerPrefix != null ? this.metadataFixerPrefix.hashCode() : 0);
        result = 31 * result + (this.fixMetadataPathFolder != null ? this.fixMetadataPathFolder.hashCode() : 0);
        result = 31 * result + (this.profileWikiPath != null ? this.profileWikiPath.hashCode() : 0);
        result = 31 * result + (this.processingType != null ? this.processingType.hashCode() : 0);
        result = 31 * result + (this.isFixMetadata ? 1 : 0);
        result = 31 * result + (this.reportType != null ? this.reportType.hashCode() : 0);
        result = 31 * result + (this.validationProfilePath != null ? this.validationProfilePath.hashCode() : 0);
        result = 31 * result + (this.flavour != null ? this.flavour.hashCode() : 0);
        result = 31 * result + (this.verboseCli ? 1 : 0);
        result = 31 * result + (this.pluginsEnabled ? 1 : 0);
        return result;
    }

    @XmlElement
    public int getMaxNumberOfDisplayedFailedChecks() {
        return this.maxNumberOfDisplayedFailedChecks;
    }

    @XmlElement
    public int getMaxNumberOfFailedChecks() {
        return this.maxNumberOfFailedChecks;
    }

    @XmlElement
    public boolean isShowPassedRules() {
        return this.showPassedRules;
    }

    @XmlElement
    public String getMetadataFixerPrefix() {
        return this.metadataFixerPrefix;
    }

    @XmlElement
    @XmlJavaTypeAdapter(value=PathAdapter.class)
    private Path getFixMetadataPathFolder() {
        return this.fixMetadataPathFolder.toString().equals("") ? null : this.fixMetadataPathFolder;
    }

    public Path getFixMetadataFolder() {
        return this.fixMetadataPathFolder;
    }

    @XmlElement
    @XmlJavaTypeAdapter(value=ProcessingTypeAdapter.class)
    public ProcessingType getProcessingType() {
        return this.processingType;
    }

    @XmlElement
    public boolean isFixMetadata() {
        return this.isFixMetadata;
    }

    @XmlElement
    public String getProfileWikiPath() {
        return this.profileWikiPath;
    }

    @XmlElement
    @XmlJavaTypeAdapter(value=FormatOptionAdapter.class)
    public FormatOption getReportType() {
        return this.reportType;
    }

    @XmlElement
    @XmlJavaTypeAdapter(value=PathAdapter.class)
    private Path getValidationProfilePath() {
        return this.validationProfilePath.toString().equals("") ? null : this.validationProfilePath;
    }

    public Path getValidationProfile() {
        return this.validationProfilePath;
    }

    @XmlElement
    @XmlJavaTypeAdapter(value=FlavourAdapter.class)
    public PDFAFlavour getFlavour() {
        return this.flavour;
    }

    @XmlElement
    public boolean isVerboseCli() {
        return this.verboseCli;
    }

    @XmlElement
    public boolean isPluginsEnabled() {
        return this.pluginsEnabled;
    }

    public static String toXml(Config toConvert, Boolean prettyXml) throws JAXBException, IOException {
        String retVal = "";
        try (StringWriter writer = new StringWriter();){
            Config.toXml(toConvert, writer, prettyXml);
            String string = retVal = writer.toString();
            return string;
        }
    }

    public static Config fromXml(String toConvert) throws JAXBException {
        try (StringReader reader = new StringReader(toConvert);){
            Config config = Config.fromXml(reader);
            return config;
        }
    }

    public static void toXml(Config toConvert, OutputStream stream, Boolean prettyXml) throws JAXBException {
        Marshaller varMarshaller = Config.getMarshaller(prettyXml);
        varMarshaller.marshal((Object)toConvert, stream);
    }

    public static Config fromXml(InputStream toConvert) throws JAXBException {
        Unmarshaller stringUnmarshaller = Config.getUnmarshaller();
        return (Config)stringUnmarshaller.unmarshal(toConvert);
    }

    static void toXml(Config toConvert, Writer writer, Boolean prettyXml) throws JAXBException {
        Marshaller varMarshaller = Config.getMarshaller(prettyXml);
        varMarshaller.marshal((Object)toConvert, writer);
    }

    static Config fromXml(Reader toConvert) throws JAXBException {
        Unmarshaller stringUnmarshaller = Config.getUnmarshaller();
        return (Config)stringUnmarshaller.unmarshal(toConvert);
    }

    private static Unmarshaller getUnmarshaller() throws JAXBException {
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{Config.class});
        Unmarshaller unmarshaller = context.createUnmarshaller();
        return unmarshaller;
    }

    private static Marshaller getMarshaller(Boolean setPretty) throws JAXBException {
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{Config.class});
        Marshaller marshaller = context.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)setPretty);
        return marshaller;
    }

    public void setMetadataFixerPrefix(String metadataFixerPrefix) {
        if (metadataFixerPrefix == null) {
            throw new IllegalArgumentException("Prefix for metadata fixer can not be null");
        }
        for (char c : metadataFixerPrefix.toCharArray()) {
            if (Config.isValidFileNameCharacter(c)) continue;
            throw new IllegalArgumentException("Prefix for metadata fixer contains forbidden symbols");
        }
        this.metadataFixerPrefix = metadataFixerPrefix;
    }

    public void setShowPassedRules(boolean showPassedRules) {
        this.showPassedRules = showPassedRules;
    }

    public void setMaxNumberOfFailedChecks(int maxNumberOfFailedChecks) {
        if (maxNumberOfFailedChecks <= 0 && maxNumberOfFailedChecks != -1) {
            throw new IllegalArgumentException("Max number of failed checks for rule for setter method is not a natural or -1");
        }
        this.maxNumberOfFailedChecks = maxNumberOfFailedChecks;
    }

    public void setMaxNumberOfDisplayedFailedChecks(int maxNumberOfDisplayedFailedChecks) {
        if (maxNumberOfDisplayedFailedChecks < -1) {
            throw new IllegalArgumentException("Max number of displayed failed checks for rule for setter method is less than -1");
        }
        this.maxNumberOfDisplayedFailedChecks = maxNumberOfDisplayedFailedChecks;
    }

    public void setFixMetadataPathFolder(Path fixMetadataPathFolder) {
        if (!Config.isValidFolderPath(fixMetadataPathFolder)) {
            throw new IllegalArgumentException("Path should be an empty path or a path to an existing and write acceptable directory");
        }
        this.fixMetadataPathFolder = fixMetadataPathFolder;
    }

    public void setProfileWikiPath(String profileWikiPath) {
        this.profileWikiPath = profileWikiPath;
    }

    public void setFixMetadata(boolean fixMetadata) {
        this.isFixMetadata = fixMetadata;
    }

    public void setProcessingType(ProcessingType processingType) {
        this.processingType = processingType;
    }

    public void setReportType(FormatOption reportType) {
        this.reportType = reportType;
    }

    public void setValidationProfilePath(Path validationProfilePath) {
        if (!Config.isValidProfilePath(validationProfilePath)) {
            throw new IllegalArgumentException("Path should be path to an existing and read acceptable file");
        }
        this.validationProfilePath = validationProfilePath;
    }

    public void setFlavour(PDFAFlavour flavour) {
        this.flavour = flavour;
    }

    public void setVerboseCli(boolean verboseCli) {
        this.verboseCli = verboseCli;
    }

    public void setPluginsEnabled(boolean pluginsEnabled) {
        this.pluginsEnabled = pluginsEnabled;
    }

    public static boolean isValidFolderPath(Path path) {
        if (path == null) {
            return false;
        }
        File f = path.toFile();
        return path.toString().isEmpty() || f.isDirectory() && f.canWrite();
    }

    public static boolean isValidProfilePath(Path path) {
        if (path == null) {
            return true;
        }
        File f = path.toFile();
        return path.toString().isEmpty() || f.isFile() && f.canRead();
    }

    public static boolean isValidFileNameCharacter(char c) {
        for (char ch : FORBIDDEN_SYMBOLS_IN_FILE_NAME) {
            if (ch != c) continue;
            return false;
        }
        return true;
    }

    private static class FlavourAdapter
    extends XmlAdapter<String, PDFAFlavour> {
        private FlavourAdapter() {
        }

        public PDFAFlavour unmarshal(String v) throws Exception {
            return PDFAFlavour.fromString(v);
        }

        public String marshal(PDFAFlavour v) throws Exception {
            return v.toString();
        }
    }

    private static class FormatOptionAdapter
    extends XmlAdapter<String, FormatOption> {
        private FormatOptionAdapter() {
        }

        public FormatOption unmarshal(String v) throws Exception {
            return FormatOption.fromOption(v);
        }

        public String marshal(FormatOption v) throws Exception {
            return v.toString();
        }
    }

    private static class ProcessingTypeAdapter
    extends XmlAdapter<String, ProcessingType> {
        private final Logger LOGGER = Logger.getLogger(ProcessingTypeAdapter.class);

        private ProcessingTypeAdapter() {
        }

        public ProcessingType unmarshal(String v) throws Exception {
            try {
                return ProcessingType.fromString(v);
            }
            catch (IllegalArgumentException e) {
                this.LOGGER.error("Can't construct ProcessingType from string \"" + v + "\", setting ProcessingType to default", e);
                return DEFAULT_PROCESSING_TYPE;
            }
        }

        public String marshal(ProcessingType v) throws Exception {
            return v.toString();
        }
    }

    private static class PathAdapter
    extends XmlAdapter<String, Path> {
        private PathAdapter() {
        }

        public Path unmarshal(String v) throws Exception {
            Path path = Paths.get(new URI(v));
            return path.toAbsolutePath();
        }

        public String marshal(Path v) throws Exception {
            return v.toAbsolutePath().toUri().toString();
        }
    }
}

