/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.processor.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import javax.xml.bind.JAXBException;
import org.apache.log4j.Logger;
import org.verapdf.processor.config.Config;

public class ConfigIO {
    private static Path configPath;
    private static final Logger LOGGER;

    private ConfigIO() {
    }

    public static Config readConfig() throws IOException, JAXBException, IllegalArgumentException {
        if (configPath.equals(FileSystems.getDefault().getPath("", new String[0]))) {
            return new Config();
        }
        File configFile = configPath.toFile();
        if (!configFile.exists()) {
            return new Config();
        }
        if (!configFile.canRead()) {
            throw new IllegalArgumentException("Path should specify read accessible file");
        }
        FileInputStream inputStream = new FileInputStream(configFile);
        return Config.fromXml(inputStream);
    }

    public static boolean writeConfig(Config config) {
        if (!configPath.equals(FileSystems.getDefault().getPath("", new String[0]))) {
            try {
                FileOutputStream outputStream = new FileOutputStream(configPath.toFile());
                Config.toXml(config, outputStream, (Boolean)true);
                return true;
            }
            catch (IOException e1) {
                LOGGER.error("Can not save config", e1);
            }
            catch (JAXBException e1) {
                LOGGER.error("Can not convert config to XML", e1);
            }
        }
        return false;
    }

    public static Config readConfig(Path configPath) throws IOException, JAXBException, IllegalArgumentException {
        if (configPath == null) {
            throw new IllegalArgumentException("Path should specify a file");
        }
        File configFile = configPath.toFile();
        if (!configFile.exists() || !configFile.canRead()) {
            throw new IllegalArgumentException("Path should specify existing read accessible file");
        }
        FileInputStream inputStream = new FileInputStream(configFile);
        return Config.fromXml(inputStream);
    }

    public static void writeConfig(Config config, Path configPath) throws IOException, JAXBException, IllegalArgumentException {
        if (configPath == null) {
            throw new IllegalArgumentException("Path should specify a file");
        }
        File configFile = configPath.toFile();
        if (!configFile.exists() || !configFile.canRead()) {
            throw new IllegalArgumentException("Path should specify existing read accessible file");
        }
        FileOutputStream outputStream = new FileOutputStream(configFile);
        Config.toXml(config, outputStream, (Boolean)true);
    }

    static {
        File user;
        File f;
        configPath = FileSystems.getDefault().getPath("", new String[0]);
        String appHome = System.getProperty("app.home");
        if (appHome != null && ((f = new File(user = new File(appHome), "config")).exists() || f.mkdir())) {
            configPath = FileSystems.getDefault().getPath(f.getAbsolutePath(), "config.xml");
        }
        LOGGER = Logger.getLogger(ConfigIO.class);
    }
}

