/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.report;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.verapdf.pdfa.results.TestAssertion;
import org.verapdf.pdfa.validation.Profiles;
import org.verapdf.pdfa.validation.RuleId;
import org.verapdf.report.Check;

@XmlRootElement
public class RuleSummary {
    private final TestAssertion.Status ruleStatus;
    @XmlAttribute
    private final String specification;
    @XmlAttribute
    private final String clause;
    @XmlAttribute
    private final int testNumber;
    @XmlAttribute
    private String status;
    @XmlAttribute
    private final int passedChecks;
    @XmlAttribute
    private final int failedChecks;
    @XmlElement
    private final String description;
    @XmlElement
    private final String object;
    @XmlElement
    private final String test;
    @XmlElement(name="check")
    private final Set<Check> checks;

    private RuleSummary(RuleId ruleId, TestAssertion.Status status, int passedChecks, int failedChecks, String description, String object, String test, Set<Check> checks) {
        this.specification = ruleId.getSpecification().getId();
        this.clause = ruleId.getClause();
        this.testNumber = ruleId.getTestNumber();
        this.ruleStatus = status;
        this.status = status.toString();
        this.passedChecks = passedChecks;
        this.failedChecks = failedChecks;
        this.description = description;
        this.object = object;
        this.test = test;
        this.checks = checks != null && !checks.isEmpty() ? new HashSet<Check>(checks) : null;
    }

    private RuleSummary(RuleId ruleId, TestAssertion.Status status, String description, String object, String test) {
        this(ruleId, status, 0, 0, description, object, test, Collections.emptySet());
    }

    private RuleSummary() {
        this(Profiles.defaultRuleId(), TestAssertion.Status.UNKNOWN, "", "", "");
    }

    public TestAssertion.Status getRuleStatus() {
        return this.ruleStatus;
    }

    public int getPassedChecks() {
        return this.passedChecks;
    }

    public int getFailedChecks() {
        return this.failedChecks;
    }

    static RuleSummary fromValues(RuleId id, String description, String object, String test, Set<TestAssertion> assertions, boolean logPassedChecks, int maxNumberOfDisplayedFailedChecks) {
        if (id == null) {
            throw new NullPointerException("Argument id can not be null");
        }
        if (description == null) {
            throw new NullPointerException("Argument description can not be null");
        }
        if (assertions == null) {
            throw new NullPointerException("Argument assertions can not be null");
        }
        HashSet<Check> checks = new HashSet<Check>();
        TestAssertion.Status status = TestAssertion.Status.PASSED;
        int passedChecks = 0;
        int failedChecks = 0;
        for (TestAssertion assertion : assertions) {
            if (assertion.getStatus() == TestAssertion.Status.PASSED) {
                ++passedChecks;
                if (!logPassedChecks) continue;
                checks.add(Check.fromValue(assertion));
                continue;
            }
            status = assertion.getStatus();
            if (maxNumberOfDisplayedFailedChecks != -1 && ++failedChecks > maxNumberOfDisplayedFailedChecks) continue;
            checks.add(Check.fromValue(assertion));
        }
        return new RuleSummary(id, status, passedChecks, failedChecks, description, object, test, checks);
    }

    static RuleSummary uncheckedInstance(RuleId id, String description, String object, String test) {
        if (id == null) {
            throw new NullPointerException("Argument id can not be null");
        }
        if (description == null) {
            throw new NullPointerException("Argument description can not be null");
        }
        return new RuleSummary(id, TestAssertion.Status.PASSED, description, object, test);
    }
}

