/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.report;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.verapdf.pdfa.flavours.PDFAFlavour;
import org.verapdf.pdfa.results.ValidationResult;
import org.verapdf.pdfa.results.ValidationResults;
import org.verapdf.pdfa.validation.Profiles;
import org.verapdf.pdfa.validation.ValidationProfile;
import org.verapdf.report.ValidationDetails;

@XmlRootElement(name="result")
public class ValidationReport {
    private static final String STATEMENT_PREFIX = "PDF file is ";
    private static final String NOT_INSERT = "not ";
    private static final String STATEMENT_SUFFIX = "compliant with Validation Profile requirements.";
    private static final String COMPLIANT_STATEMENT = "PDF file is compliant with Validation Profile requirements.";
    private static final String NONCOMPLIANT_STATEMENT = "PDF file is not compliant with Validation Profile requirements.";
    @XmlAttribute
    private final String profile;
    @XmlAttribute
    private final boolean compliant;
    @XmlElement
    private final String statement;
    @XmlElement
    private final ValidationDetails details;

    private ValidationReport(String profile, boolean compliant, String statement, ValidationDetails details) {
        this.profile = profile;
        this.compliant = compliant;
        this.statement = statement;
        this.details = details;
    }

    private ValidationReport() {
        this(PDFAFlavour.NO_FLAVOUR.getId(), false, "", ValidationDetails.fromValues(Profiles.defaultProfile(), ValidationResults.defaultResult(), false, 0));
    }

    public static ValidationReport fromValues(ValidationProfile profile, ValidationResult result, boolean logPassedChecks, int maxNumberOfDisplayedFailedChecks) {
        if (result == null) {
            return null;
        }
        return new ValidationReport(profile.getDetails().getName(), result.isCompliant(), ValidationReport.getStatement(result.isCompliant()), ValidationDetails.fromValues(profile, result, logPassedChecks, maxNumberOfDisplayedFailedChecks));
    }

    private static String getStatement(boolean status) {
        return status ? COMPLIANT_STATEMENT : NONCOMPLIANT_STATEMENT;
    }
}

