/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.runner;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.bind.JAXBException;
import org.verapdf.core.ValidationException;
import org.verapdf.core.VeraPDFException;
import org.verapdf.model.ModelParser;
import org.verapdf.pdfa.PDFAValidator;
import org.verapdf.pdfa.flavours.PDFAFlavour;
import org.verapdf.pdfa.results.ValidationResult;
import org.verapdf.pdfa.results.ValidationResults;
import org.verapdf.pdfa.validators.Validators;

public class ValidationRunner {
    private ValidationRunner() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ValidationResult runValidation(InputStream toValidate) throws VeraPDFException, IOException {
        try (ModelParser loader = ModelParser.createModelWithFlavour(toValidate, PDFAFlavour.PDFA_1_B);){
            try {
                loader.getRoot();
            }
            catch (IOException e) {
                throw new VeraPDFException("IOException when parsing Validation Model.", e);
            }
            PDFAValidator validator = Validators.createValidator(PDFAFlavour.PDFA_1_B, false);
            ValidationResult result = validator.validate(loader);
            ValidationResults.toXml(result, System.out, Boolean.TRUE);
            ValidationResult validationResult = result;
            return validationResult;
        }
        catch (FileNotFoundException | JAXBException | ValidationException e) {
            throw new VeraPDFException("Exception when validating.", e);
        }
    }
}

