/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.features.pb.objects;

import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.verapdf.core.FeatureParsingException;
import org.verapdf.features.FeatureExtractionResult;
import org.verapdf.features.FeatureObjectType;
import org.verapdf.features.FeaturesData;
import org.verapdf.features.IFeaturesObject;
import org.verapdf.features.pb.tools.PBCreateNodeHelper;
import org.verapdf.features.tools.FeatureTreeNode;

public class PBPropertiesDictFeaturesObject
implements IFeaturesObject {
    private COSDictionary properties;
    private String id;

    public PBPropertiesDictFeaturesObject(COSDictionary properties, String id) {
        this.properties = properties;
        this.id = id;
    }

    @Override
    public FeatureObjectType getType() {
        return FeatureObjectType.PROPERTIES;
    }

    @Override
    public FeatureTreeNode reportFeatures(FeatureExtractionResult collection) throws FeatureParsingException {
        if (this.properties != null) {
            COSBase type;
            FeatureTreeNode root = FeatureTreeNode.createRootNode("propertiesDict");
            if (this.id != null) {
                root.setAttribute("id", this.id);
            }
            if ((type = this.properties.getDictionaryObject(COSName.TYPE)) instanceof COSName) {
                PBCreateNodeHelper.addNotEmptyNode("type", ((COSName)type).getName(), root);
            }
            collection.addNewFeatureTree(FeatureObjectType.PROPERTIES, root);
            return root;
        }
        return null;
    }

    @Override
    public FeaturesData getData() {
        return null;
    }
}

