/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.features.pb.objects;

import java.io.ByteArrayInputStream;
import javax.xml.bind.DatatypeConverter;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.PDSignature;
import org.verapdf.core.FeatureParsingException;
import org.verapdf.features.FeatureExtractionResult;
import org.verapdf.features.FeatureObjectType;
import org.verapdf.features.FeaturesData;
import org.verapdf.features.IFeaturesObject;
import org.verapdf.features.SignatureFeaturesData;
import org.verapdf.features.pb.tools.PBCreateNodeHelper;
import org.verapdf.features.tools.FeatureTreeNode;

public class PBSignatureFeaturesObject
implements IFeaturesObject {
    private PDSignature signature;

    public PBSignatureFeaturesObject(PDSignature signature) {
        this.signature = signature;
    }

    @Override
    public FeatureObjectType getType() {
        return FeatureObjectType.SIGNATURE;
    }

    @Override
    public FeatureTreeNode reportFeatures(FeatureExtractionResult collection) throws FeatureParsingException {
        if (this.signature != null) {
            FeatureTreeNode root = FeatureTreeNode.createRootNode("signature");
            PBCreateNodeHelper.addNotEmptyNode("filter", this.signature.getFilter(), root);
            PBCreateNodeHelper.addNotEmptyNode("subFilter", this.signature.getSubFilter(), root);
            byte[] contents = this.signature.getContents();
            if (contents != null) {
                PBCreateNodeHelper.addNotEmptyNode("contents", DatatypeConverter.printHexBinary((byte[])contents), root);
            }
            PBCreateNodeHelper.addNotEmptyNode("name", this.signature.getName(), root);
            PBCreateNodeHelper.createDateNode("signDate", root, this.signature.getSignDate(), collection);
            PBCreateNodeHelper.addNotEmptyNode("location", this.signature.getLocation(), root);
            PBCreateNodeHelper.addNotEmptyNode("reason", this.signature.getReason(), root);
            PBCreateNodeHelper.addNotEmptyNode("contactInfo", this.signature.getContactInfo(), root);
            collection.addNewFeatureTree(FeatureObjectType.SIGNATURE, root);
            return root;
        }
        return null;
    }

    @Override
    public FeaturesData getData() {
        byte[] contents = this.signature.getContents();
        ByteArrayInputStream stream = contents == null ? null : new ByteArrayInputStream(contents);
        return SignatureFeaturesData.newInstance(stream, this.signature.getFilter(), this.signature.getSubFilter(), this.signature.getName(), this.signature.getSignDate(), this.signature.getLocation(), this.signature.getReason(), this.signature.getContactInfo());
    }
}

