/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.pdfa.results;

import java.util.Set;
import org.verapdf.pdfa.flavours.PDFAFlavour;
import org.verapdf.pdfa.results.Location;
import org.verapdf.pdfa.results.LocationImpl;
import org.verapdf.pdfa.results.TestAssertion;
import org.verapdf.pdfa.results.TestAssertionImpl;
import org.verapdf.pdfa.results.ValidationResult;
import org.verapdf.pdfa.results.ValidationResultImpl;
import org.verapdf.pdfa.validation.profiles.ProfileDetails;
import org.verapdf.pdfa.validation.profiles.RuleId;

public class ValidationResults {
    private static final String NOT_NULL_MESSAGE = " cannot be null.";
    private static final String FLAVOUR_NOT_NULL_MESSAGE = "Flavour  cannot be null.";
    private static final String ASSERTIONS_NOT_NULL_MESSAGE = "Assertions  cannot be null.";

    private ValidationResults() {
        throw new AssertionError((Object)"Should never enter ValidationResults().");
    }

    public static ValidationResult resultFromValues(PDFAFlavour flavour, ProfileDetails profileDetails, Set<TestAssertion> assertions, boolean isCompliant) {
        if (flavour == null) {
            throw new NullPointerException(FLAVOUR_NOT_NULL_MESSAGE);
        }
        if (assertions == null) {
            throw new NullPointerException(ASSERTIONS_NOT_NULL_MESSAGE);
        }
        return ValidationResultImpl.fromValues(flavour, profileDetails, assertions, isCompliant, assertions.size());
    }

    public static ValidationResult resultFromValues(PDFAFlavour flavour, ProfileDetails profileDetails, Set<TestAssertion> assertions, boolean isCompliant, int totalAssertions) {
        if (flavour == null) {
            throw new NullPointerException(FLAVOUR_NOT_NULL_MESSAGE);
        }
        if (assertions == null) {
            throw new NullPointerException(ASSERTIONS_NOT_NULL_MESSAGE);
        }
        return ValidationResultImpl.fromValues(flavour, profileDetails, assertions, isCompliant, totalAssertions);
    }

    public static ValidationResult resultFromValues(PDFAFlavour flavour, ProfileDetails profileDetails, Set<TestAssertion> assertions) {
        if (flavour == null) {
            throw new NullPointerException(FLAVOUR_NOT_NULL_MESSAGE);
        }
        if (assertions == null) {
            throw new NullPointerException(ASSERTIONS_NOT_NULL_MESSAGE);
        }
        boolean isCompliant = true;
        for (TestAssertion assertion : assertions) {
            if (assertion.getStatus() != TestAssertion.Status.FAILED) continue;
            isCompliant = false;
            break;
        }
        return ValidationResults.resultFromValues(flavour, profileDetails, assertions, isCompliant);
    }

    public static ValidationResult defaultResult() {
        return ValidationResultImpl.defaultInstance();
    }

    public static TestAssertion assertionFromValues(int ordinal, RuleId ruleId, TestAssertion.Status status, String message, Location location) {
        return TestAssertionImpl.fromValues(ordinal, ruleId, status, message, location);
    }

    public static TestAssertion defaultAssertion() {
        return TestAssertionImpl.defaultInstance();
    }

    public static Location locationFromValues(String level, String context) {
        return LocationImpl.fromValues(level, context);
    }

    public static Location defaultLocation() {
        return LocationImpl.defaultInstance();
    }

    public static ValidationResult stripPassedTests(ValidationResult toStrip) {
        if (toStrip == null) {
            throw new NullPointerException("toStrip can not be null.");
        }
        return ValidationResultImpl.stripPassedTests(toStrip);
    }
}

