/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.pdfa.validation.validators;

import org.verapdf.pdfa.validation.profiles.Rule;
import org.verapdf.pdfa.validation.profiles.ValidationProfile;
import org.verapdf.pdfa.validation.validators.BaseValidator;

class FastFailValidator
extends BaseValidator {
    private final int maxFailedTests;
    protected int failureCount = 0;

    protected FastFailValidator(ValidationProfile profile, boolean logPassedTests) {
        this(profile, logPassedTests, 0);
    }

    protected FastFailValidator(ValidationProfile profile, boolean logPassedTests, int maxFailedTests) {
        super(profile, logPassedTests);
        this.maxFailedTests = maxFailedTests;
    }

    @Override
    protected void processAssertionResult(boolean assertionResult, String locationContext, Rule rule) {
        if (!assertionResult) {
            ++this.failureCount;
            if (this.maxFailedTests > 0 && this.failureCount >= this.maxFailedTests) {
                this.abortProcessing = true;
            }
        }
        super.processAssertionResult(assertionResult, locationContext, rule);
    }
}

