/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.features.pb.objects;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDocument;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.cos.COSStream;
import org.verapdf.features.objects.LowLvlInfoFeaturesObjectAdapter;
import org.verapdf.features.pb.tools.PBAdapterHelper;

public class PBLowLvlInfoFeaturesObjectAdapter
implements LowLvlInfoFeaturesObjectAdapter {
    private static final Logger LOGGER = Logger.getLogger(PBLowLvlInfoFeaturesObjectAdapter.class);
    private boolean isPresent;
    private int objectsNumber;
    private String creationId;
    private String modId;
    private Set<String> filters;
    private List<String> errors;
    private static final Map<String, String> filtersAbbreviations;

    public PBLowLvlInfoFeaturesObjectAdapter(COSDocument document) {
        boolean bl = this.isPresent = document != null;
        if (document != null) {
            List<COSObject> objects = document.getObjects();
            this.errors = new ArrayList<String>();
            if (objects != null) {
                this.objectsNumber = objects.size();
            }
            this.addDocumentId(document.getDocumentID());
            this.filters = this.getAllFilters(document);
        }
    }

    /*
     * WARNING - void declaration
     */
    private Set<String> getAllFilters(COSDocument document) {
        HashSet<String> res = new HashSet<String>();
        for (COSBase cOSBase : document.getObjects()) {
            void var4_4;
            while (var4_4 instanceof COSObject) {
                COSBase cOSBase2 = ((COSObject)var4_4).getObject();
            }
            if (!(var4_4 instanceof COSStream)) continue;
            try {
                COSStream stream = (COSStream)var4_4;
                Throwable throwable = null;
                try {
                    COSBase baseFilter = stream.getFilters();
                    if (baseFilter == null) continue;
                    PBLowLvlInfoFeaturesObjectAdapter.addFiltersFromBase(res, baseFilter);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (stream == null) continue;
                    if (throwable != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    stream.close();
                }
            }
            catch (IOException excep) {
                LOGGER.debug(excep);
                this.errors.add(excep.getMessage());
            }
        }
        return res;
    }

    private void addDocumentId(COSArray ids) {
        if (ids != null) {
            this.creationId = PBAdapterHelper.getStringFromBase(ids.get(0));
            this.modId = PBAdapterHelper.getStringFromBase(ids.get(1));
            if (ids.size() != 2 || this.creationId == null || this.modId == null) {
                this.errors.add("Document's ID must be an array of two not null elements");
            }
        }
    }

    private static void addFiltersFromBase(Set<String> res, COSBase base) {
        if (base instanceof COSName) {
            String name = ((COSName)base).getName();
            if (filtersAbbreviations.keySet().contains(name)) {
                name = filtersAbbreviations.get(name);
            }
            res.add(name);
        } else if (base instanceof COSArray) {
            for (COSBase baseElement : (COSArray)base) {
                if (!(baseElement instanceof COSName)) continue;
                String name = ((COSName)baseElement).getName();
                if (filtersAbbreviations.keySet().contains(name)) {
                    name = filtersAbbreviations.get(name);
                }
                res.add(name);
            }
        }
    }

    @Override
    public int getIndirectObjectsNumber() {
        return this.objectsNumber;
    }

    @Override
    public String getCreationId() {
        return this.creationId;
    }

    @Override
    public String getModificationId() {
        return this.modId;
    }

    @Override
    public Set<String> getFilters() {
        return this.filters == null ? Collections.emptySet() : Collections.unmodifiableSet(this.filters);
    }

    @Override
    public boolean isPDFObjectPresent() {
        return this.isPresent;
    }

    @Override
    public List<String> getErrors() {
        return this.errors == null ? Collections.emptyList() : Collections.unmodifiableList(this.errors);
    }

    static {
        HashMap<String, String> filtersAbbreviationsTemp = new HashMap<String, String>();
        filtersAbbreviationsTemp.put("AHx", "ASCIIHexDecode");
        filtersAbbreviationsTemp.put("A85", "ASCII85Decode");
        filtersAbbreviationsTemp.put("LZW", "LZWDecode");
        filtersAbbreviationsTemp.put("Fl", "FlateDecode");
        filtersAbbreviationsTemp.put("RL", "RunLengthDecode");
        filtersAbbreviationsTemp.put("CCF", "CCITTFaxDecode");
        filtersAbbreviationsTemp.put("DCT", "DCTDecode");
        filtersAbbreviations = Collections.unmodifiableMap(filtersAbbreviationsTemp);
    }
}

