/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.model.impl.pb.external;

import java.io.IOException;
import org.apache.fontbox.cmap.CMap;
import org.apache.fontbox.cmap.CMapParser;
import org.apache.log4j.Logger;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSStream;
import org.verapdf.model.external.CMapFile;
import org.verapdf.model.impl.pb.external.PBoxExternal;

public class PBoxCMapFile
extends PBoxExternal
implements CMapFile {
    private static final Logger LOGGER = Logger.getLogger(PBoxCMapFile.class);
    public static final String CMAP_FILE_TYPE = "CMapFile";
    private final COSStream fileStream;

    public PBoxCMapFile(COSStream fileStream) {
        super(CMAP_FILE_TYPE);
        this.fileStream = fileStream;
    }

    @Override
    public Long getWMode() {
        try {
            CMap map = new CMapParser().parse(this.fileStream.getUnfilteredStream());
            return map.getWMode();
        }
        catch (IOException e) {
            LOGGER.debug("Could not parse CMap", e);
            return null;
        }
    }

    @Override
    public Long getdictWMode() {
        return this.fileStream.getInt(COSName.getPDFName("WMode"), 0);
    }
}

