/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.cli;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBException;
import org.verapdf.apps.ConfigManager;
import org.verapdf.apps.VeraAppConfig;
import org.verapdf.cli.commands.VeraCliArgParser;
import org.verapdf.core.VeraPDFException;
import org.verapdf.policy.PolicyChecker;
import org.verapdf.processor.BatchProcessor;
import org.verapdf.processor.ItemProcessor;
import org.verapdf.processor.ProcessorConfig;
import org.verapdf.processor.ProcessorFactory;
import org.verapdf.processor.ProcessorResult;
import org.verapdf.processor.reports.ItemDetails;

final class VeraPdfCliProcessor {
    private static final Logger logger = Logger.getLogger(VeraPdfCliProcessor.class.getCanonicalName());
    private final ConfigManager configManager;
    private final ProcessorConfig processorConfig;
    private final VeraAppConfig appConfig;
    private final boolean isPolicy;
    private final File tempMrrFile;
    private final File policyFile;
    private boolean isStdOut = true;
    private boolean appendData = true;
    private String baseDirectory = "";

    private VeraPdfCliProcessor(VeraCliArgParser args, ConfigManager configManager) throws VeraPDFException {
        File file;
        this.configManager = configManager;
        this.isPolicy = args.isPolicy();
        try {
            this.tempMrrFile = this.isPolicy ? File.createTempFile("mrr", "veraPDF") : null;
        }
        catch (IOException excep) {
            throw new VeraPDFException("Failed to create temporary MRR file", excep);
        }
        this.policyFile = args.getPolicyFile();
        this.appConfig = args.appConfig(configManager.getApplicationConfig());
        this.processorConfig = args.processorConfig(this.appConfig.getProcessType(), this.configManager.getFeaturesConfig(), this.configManager.getPluginsCollectionConfig());
        if (this.configManager.getApplicationConfig().isOverwriteReport() && (file = new File(this.configManager.getApplicationConfig().getReportFile())).exists()) {
            try {
                file.delete();
            }
            catch (SecurityException ex) {
                logger.log(Level.WARNING, "Cannot delete older report file.", ex);
            }
        }
    }

    VeraAppConfig getConfig() {
        return this.appConfig;
    }

    ProcessorConfig getProcessorConfig() {
        return this.processorConfig;
    }

    void processPaths(List<String> pdfPaths) throws VeraPDFException {
        if (pdfPaths.isEmpty()) {
            System.out.println("veraPDF is processing STDIN and is expecting an EOF marker.");
            System.out.println("If this isn't your intention you can terminate by typing an EOF equivalent:");
            System.out.println(" - Linux or Mac users should type CTRL-D");
            System.out.println(" - Windows users should type CTRL-Z");
            ItemDetails item = ItemDetails.fromValues("STDIN");
            this.processStream(item, System.in);
        }
        ArrayList<File> toProcess = new ArrayList<File>();
        for (String pdfPath : pdfPaths) {
            File file = new File(pdfPath);
            if (!VeraPdfCliProcessor.isFileProcessable(file)) {
                throw new VeraPDFException("Could not process file " + pdfPath);
            }
            if (file.isDirectory()) {
                this.baseDirectory = file.getAbsolutePath();
                this.processDir(file);
                continue;
            }
            if (!VeraPdfCliProcessor.isFileProcessable(file)) continue;
            toProcess.add(file);
        }
        if (!toProcess.isEmpty()) {
            this.processFiles(toProcess);
        }
        if (this.isPolicy) {
            this.applyPolicy();
        }
    }

    static VeraPdfCliProcessor createProcessorFromArgs(VeraCliArgParser args, ConfigManager config) throws VeraPDFException {
        return new VeraPdfCliProcessor(args, config);
    }

    private void processDir(File dir) {
        try {
            this.processBatch(dir);
        }
        catch (VeraPDFException excep) {
            excep.printStackTrace();
        }
    }

    private void processFiles(List<File> files) {
        try (BatchProcessor processor = ProcessorFactory.fileBatchProcessor(this.processorConfig);
             OutputStream reportStream = this.getReportStream();){
            processor.process(files, ProcessorFactory.getHandler(this.appConfig.getFormat(), this.appConfig.isVerbose(), reportStream, this.appConfig.getMaxFailsDisplayed(), this.processorConfig.getValidatorConfig().isRecordPasses()));
        }
        catch (VeraPDFException e) {
            System.err.println("Exception raised while processing batch");
            e.printStackTrace();
        }
        catch (IOException excep) {
            logger.log(Level.FINE, "Exception raised closing MRR temp file.", excep);
        }
    }

    private static boolean isFileProcessable(File file) {
        if (!file.exists()) {
            System.err.println("Path " + file.getAbsolutePath() + " cannot be found.");
            return false;
        }
        if (!file.canRead()) {
            System.err.println("Path " + file.getAbsolutePath() + " is not readable.");
            return false;
        }
        return true;
    }

    private void processBatch(File dir) throws VeraPDFException {
        String reportPath = this.appConfig.getReportFile();
        try (BatchProcessor processor = ProcessorFactory.fileBatchProcessor(this.processorConfig);
             OutputStream reportStream = this.getReportStream();){
            processor.process(dir, true, ProcessorFactory.getHandler(this.appConfig.getFormat(), this.appConfig.isVerbose(), reportStream, this.appConfig.getMaxFailsDisplayed(), this.processorConfig.getValidatorConfig().isRecordPasses()));
        }
        catch (IOException excep) {
            logger.log(Level.FINE, "Exception raised closing MRR temp file.", excep);
        }
    }

    private void processStream(ItemDetails item, InputStream toProcess) {
        ItemProcessor processor = ProcessorFactory.createProcessor(this.processorConfig);
        ProcessorResult result = processor.process(item, toProcess);
        OutputStream outputReportStream = this.getReportStream();
        try {
            if (result.isPdf() && !result.isEncryptedPdf()) {
                ProcessorFactory.resultToXml(result, outputReportStream, true);
            } else {
                String message = result.isPdf() ? item.getName() + " is and encrypted PDF." : item.getName() + " is not a valid PDF.";
                outputReportStream.write(message.getBytes());
            }
        }
        catch (IOException | JAXBException excep) {
            excep.printStackTrace();
        }
        if (!this.isStdOut) {
            try {
                outputReportStream.close();
            }
            catch (IOException ex) {
                logger.log(Level.SEVERE, "Cannot close the report file: " + ex.toString() + "\n");
            }
        }
    }

    private OutputStream getReportStream() {
        if (this.isPolicy) {
            if (this.tempMrrFile == null) {
                throw new IllegalStateException("Policy enabled BUT no temp destination");
            }
            try {
                this.isStdOut = false;
                return new FileOutputStream(this.tempMrrFile);
            }
            catch (FileNotFoundException excep) {
                throw new IllegalStateException("Policy enabled BUT no temp destination", excep);
            }
        }
        return System.out;
    }

    private void applyPolicy() throws VeraPDFException {
        File tempPolicyResult = null;
        try {
            tempPolicyResult = File.createTempFile("policyResult", "veraPDF");
        }
        catch (IOException excep) {
            throw new VeraPDFException("Could not create temporary policy result file.", excep);
        }
        try (FileInputStream mrrIs = new FileInputStream(this.tempMrrFile);
             FileOutputStream policyResultOs = new FileOutputStream(tempPolicyResult);){
            PolicyChecker.applyPolicy(this.policyFile, mrrIs, policyResultOs);
            PolicyChecker.insertPolicyReport(tempPolicyResult, this.tempMrrFile, System.out);
        }
        catch (FileNotFoundException excep) {
            throw new VeraPDFException("Could not find temporary policy result file.", excep);
        }
        catch (IOException excep) {
            logger.log(Level.FINE, "Exception raised closing temporary policy file.", excep);
        }
    }

    private String constructReportPath(String itemName) {
        String reportPath = "";
        if (!this.configManager.getApplicationConfig().getReportFolder().isEmpty()) {
            Path fileAbsolutePath = Paths.get(itemName, new String[0]);
            String pdfFileName = fileAbsolutePath.getFileName().toString();
            String pdfFileDirectory = fileAbsolutePath.getParent().toString();
            String extension = "." + this.configManager.getApplicationConfig().getFormat().toString();
            String outputFileName = pdfFileName.replace(".pdf", extension);
            String reportFolder = this.configManager.getApplicationConfig().getReportFolder();
            if (pdfFileDirectory.length() > this.baseDirectory.length()) {
                StringBuilder reportFolderBuilder = new StringBuilder();
                reportFolderBuilder.append(reportFolder);
                String subDirectory = pdfFileDirectory.substring(this.baseDirectory.length());
                reportFolderBuilder.append(subDirectory);
                reportFolder = reportFolderBuilder.toString();
                File dir = new File(reportFolder);
                if (!dir.exists()) {
                    try {
                        dir.mkdirs();
                    }
                    catch (SecurityException ex) {
                        logger.log(Level.SEVERE, "Cannot create subdirectories the: " + ex.toString() + "\n");
                        reportFolder = this.configManager.getApplicationConfig().getReportFolder();
                    }
                }
            }
            File reportFile = new File(reportFolder, outputFileName);
            reportPath = reportFile.getAbsolutePath();
            this.appendData = false;
        } else if (!this.configManager.getApplicationConfig().getReportFile().isEmpty()) {
            File reportFile = new File(this.configManager.getApplicationConfig().getReportFile());
            reportPath = reportFile.getAbsolutePath();
            this.appendData = true;
        }
        return reportPath;
    }
}

