/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.cos;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.verapdf.as.ASAtom;
import org.verapdf.as.io.ASInputStream;
import org.verapdf.as.io.ASMemoryInStream;
import org.verapdf.as.io.ASOutputStream;
import org.verapdf.cos.COSBase;
import org.verapdf.cos.COSBasePair;
import org.verapdf.cos.COSDictionary;
import org.verapdf.cos.COSFilters;
import org.verapdf.cos.COSIndirect;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.cos.visitor.ICOSVisitor;
import org.verapdf.cos.visitor.IVisitor;
import org.verapdf.io.InternalInputStream;
import org.verapdf.io.InternalOutputStream;
import org.verapdf.io.SeekableInputStream;

public class COSStream
extends COSDictionary {
    private static final Logger LOGGER = Logger.getLogger(COSStream.class.getCanonicalName());
    private ASInputStream stream;
    private FilterFlags flags;
    private boolean streamKeywordCRLFCompliant = true;
    private boolean endstreamKeywordCRLFCompliant = true;
    private long realStreamSize;

    protected COSStream() {
        this.flags = FilterFlags.RAW_DATA;
        this.setIndirectLength(0L);
    }

    protected COSStream(ASInputStream stream) {
        this.stream = stream;
        this.flags = FilterFlags.RAW_DATA;
        this.setIndirectLength(0L);
    }

    protected COSStream(String string) {
        this.stream = new ASMemoryInStream(string.getBytes());
        this.flags = FilterFlags.RAW_DATA;
    }

    protected COSStream(COSDictionary dictionary) {
        super(dictionary);
    }

    protected COSStream(COSDictionary dictionary, ASInputStream stream, FilterFlags flags) {
        super(dictionary);
        this.stream = stream;
        this.flags = flags;
    }

    protected COSStream(COSDictionary dictionary, String string, FilterFlags flags) {
        super(dictionary);
        this.stream = new ASMemoryInStream(string.getBytes());
        this.flags = flags;
    }

    public static COSObject construct() {
        return new COSObject(new COSStream());
    }

    public static COSObject construct(ASInputStream stream) {
        return new COSObject(new COSStream(stream));
    }

    public static COSObject construct(String string) {
        return new COSObject(new COSStream(string));
    }

    public static COSObject construct(COSDictionary dictionary) {
        return new COSObject(new COSStream(dictionary));
    }

    public static COSObject construct(COSDictionary dictionary, ASInputStream stream) {
        return COSStream.construct(dictionary, stream, FilterFlags.RAW_DATA);
    }

    public static COSObject construct(COSDictionary dictionary, ASInputStream stream, FilterFlags flags) {
        return new COSObject(new COSStream(dictionary, stream, flags));
    }

    public static COSObject construct(COSDictionary dictionary, String string) {
        return COSStream.construct(dictionary, string, FilterFlags.RAW_DATA);
    }

    public static COSObject construct(COSDictionary dictionary, String string, FilterFlags flags) {
        return new COSObject(new COSStream(dictionary, string, flags));
    }

    @Override
    public COSObjType getType() {
        return COSObjType.COS_STREAM;
    }

    @Override
    public void accept(IVisitor visitor) {
        visitor.visitFromStream(this);
    }

    @Override
    public Object accept(ICOSVisitor visitor) {
        return visitor.visitFromStream(this);
    }

    @Override
    public ASInputStream getData() {
        return this.getData(FilterFlags.RAW_DATA);
    }

    @Override
    public ASInputStream getData(FilterFlags filterFlags) {
        try {
            if (filterFlags == FilterFlags.RAW_DATA || this.flags != FilterFlags.RAW_DATA) {
                this.stream.reset();
                return this.stream;
            }
            ASInputStream result = this.getFilters().getInputStream(ASInputStream.createStreamFromStream(this.stream), this.getKey(ASAtom.DECODE_PARMS));
            result.reset();
            return result;
        }
        catch (IOException e) {
            LOGGER.log(Level.FINE, "Can't get stream data", e);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean setData(ASInputStream stream) {
        COSFilters filters = this.getFilters();
        if (filters.empty()) {
            return this.setData(stream, FilterFlags.RAW_DATA);
        }
        try (InternalOutputStream fileWithData = InternalOutputStream.getInternalOutputStream();){
            ASOutputStream encoder = filters.getOutputStream(fileWithData);
            encoder.write(stream);
            File encodedDataFile = fileWithData.getFile();
            boolean bl = this.setData(new InternalInputStream(encodedDataFile), FilterFlags.RAW_DATA);
            return bl;
        }
        catch (IOException e) {
            LOGGER.log(Level.FINE, "Can not set data", e);
            return false;
        }
    }

    @Override
    public boolean setData(ASInputStream stream, FilterFlags flags) {
        this.stream = stream;
        this.flags = flags;
        return true;
    }

    @Override
    public Boolean isStreamKeywordCRLFCompliant() {
        return this.streamKeywordCRLFCompliant;
    }

    @Override
    public boolean setStreamKeywordCRLFCompliant(boolean streamKeywordCRLFCompliant) {
        this.streamKeywordCRLFCompliant = streamKeywordCRLFCompliant;
        return true;
    }

    @Override
    public Boolean isEndstreamKeywordCRLFCompliant() {
        return this.endstreamKeywordCRLFCompliant;
    }

    @Override
    public boolean setEndstreamKeywordCRLFCompliant(boolean endstreamKeywordCRLFCompliant) {
        this.endstreamKeywordCRLFCompliant = endstreamKeywordCRLFCompliant;
        return true;
    }

    @Override
    public Long getRealStreamSize() {
        return this.realStreamSize;
    }

    @Override
    public boolean setRealStreamSize(long realStreamSize) {
        this.realStreamSize = realStreamSize;
        return true;
    }

    public COSFilters getFilters() {
        return new COSFilters(this.getKey(ASAtom.FILTER));
    }

    public void setFilters(COSFilters filters) throws IOException {
        try (ASInputStream decoded = this.getData(FilterFlags.DECODE);){
            SeekableInputStream unfilteredData = SeekableInputStream.getSeekableStream(decoded);
            InternalOutputStream fileWithData = InternalOutputStream.getInternalOutputStream();
            this.setKey(ASAtom.FILTER, filters.getObject());
            ASOutputStream encoder = filters.getOutputStream(fileWithData);
            encoder.write(unfilteredData);
            File encodedDataFile = fileWithData.getFile();
            fileWithData.close();
            this.setData(new InternalInputStream(encodedDataFile), FilterFlags.RAW_DATA);
        }
    }

    public FilterFlags getFilterFlags() {
        return this.flags;
    }

    public void setFilterFlags(FilterFlags flags) {
        this.flags = flags;
    }

    public long getLength() {
        return this.getIntegerKey(ASAtom.LENGTH);
    }

    public void setLength(long length) {
        this.setIntegerKey(ASAtom.LENGTH, length);
    }

    public void setIndirectLength(long length) {
        COSObject obj = this.getKey(ASAtom.LENGTH);
        obj.setInteger(length);
        if (obj.isIndirect().booleanValue()) {
            obj = COSIndirect.construct(obj);
            this.setKey(ASAtom.LENGTH, obj);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof COSObject) {
            return this.equals(((COSObject)obj).get());
        }
        LinkedList<COSBasePair> checkedObjects = new LinkedList<COSBasePair>();
        return this.equals(obj, checkedObjects);
    }

    @Override
    boolean equals(Object obj, List<COSBasePair> checkedObjects) {
        COSBase cosBase;
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof COSObject) {
            return this.equals(((COSObject)obj).get());
        }
        if (COSBasePair.listContainsPair(checkedObjects, this, (COSBase)obj)) {
            return true;
        }
        COSBasePair.addPairToList(checkedObjects, this, (COSBase)obj);
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        COSStream that = (COSStream)obj;
        for (Map.Entry<ASAtom, COSObject> entry : this.getEntrySet()) {
            if (entry.getKey() == ASAtom.FILTER || entry.getKey() == ASAtom.DECODE_PARMS || entry.getKey() == ASAtom.LENGTH) continue;
            cosBase = that.getKey(entry.getKey()).get();
            if (entry.getValue().get().equals(cosBase, checkedObjects)) continue;
            return false;
        }
        for (Map.Entry<ASAtom, COSObject> entry : that.getEntrySet()) {
            if (entry.getKey() == ASAtom.FILTER || entry.getKey() == ASAtom.DECODE_PARMS || entry.getKey() == ASAtom.LENGTH) continue;
            cosBase = this.getKey(entry.getKey()).get();
            if (entry.getValue().get().equals(cosBase, checkedObjects)) continue;
            return false;
        }
        try {
            if (this.stream != null ? !COSStream.equalsStreams(this.stream, that.stream) : that.stream != null) {
                return false;
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.FINE, "Exception during comparing streams", e);
            return false;
        }
        return this.flags == that.flags;
    }

    private static boolean equalsStreams(ASInputStream first, ASInputStream second) throws IOException {
        int readFromOne;
        first.reset();
        second.reset();
        byte[] tempOne = new byte[1024];
        byte[] tempTwo = new byte[1024];
        do {
            int readFromTwo;
            if ((readFromOne = first.read(tempOne, tempOne.length)) == (readFromTwo = second.read(tempTwo, tempTwo.length)) && Arrays.equals(tempOne, tempTwo)) continue;
            return false;
        } while (readFromOne != -1);
        return true;
    }

    public static enum FilterFlags {
        RAW_DATA,
        DECODE,
        DECRYPT,
        DECRYPT_AND_DECODE;

    }
}

