/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.cos.visitor;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.verapdf.as.ASAtom;
import org.verapdf.as.ASCharsets;
import org.verapdf.as.io.ASInputStream;
import org.verapdf.cos.COSArray;
import org.verapdf.cos.COSBoolean;
import org.verapdf.cos.COSDictionary;
import org.verapdf.cos.COSDocument;
import org.verapdf.cos.COSIndirect;
import org.verapdf.cos.COSInteger;
import org.verapdf.cos.COSKey;
import org.verapdf.cos.COSName;
import org.verapdf.cos.COSNull;
import org.verapdf.cos.COSObject;
import org.verapdf.cos.COSReal;
import org.verapdf.cos.COSStream;
import org.verapdf.cos.COSString;
import org.verapdf.cos.COSTrailer;
import org.verapdf.cos.visitor.COSCopier;
import org.verapdf.cos.visitor.IVisitor;
import org.verapdf.cos.xref.COSXRefEntry;
import org.verapdf.cos.xref.COSXRefInfo;
import org.verapdf.cos.xref.COSXRefRange;
import org.verapdf.cos.xref.COSXRefSection;
import org.verapdf.io.InternalOutputStream;
import org.verapdf.io.SeekableInputStream;

public class Writer
implements IVisitor {
    private static final Logger LOGGER = Logger.getLogger(Writer.class.getCanonicalName());
    protected InternalOutputStream os;
    private long incrementalOffset;
    protected COSXRefInfo info;
    protected COSDocument document;
    protected List<COSKey> toWrite;
    protected List<COSKey> written;
    private final NumberFormat formatXrefOffset = new DecimalFormat("0000000000");
    private final NumberFormat formatXrefGeneration = new DecimalFormat("00000");
    public static final String EOL = "\r\n";

    public Writer(COSDocument document, String filename, long incrementalOffset) throws IOException {
        this(document, filename, true, incrementalOffset);
    }

    public Writer(COSDocument document, String filename, boolean append, long incrementalOffset) throws IOException {
        this.document = document;
        this.os = new InternalOutputStream(filename);
        this.info = new COSXRefInfo();
        this.toWrite = new ArrayList<COSKey>();
        this.written = new ArrayList<COSKey>();
        this.incrementalOffset = incrementalOffset;
        if (append) {
            this.os.seekEnd();
        }
    }

    public void writeIncrementalUpdate(List<COSObject> changedObjects, List<COSObject> addedObjects) {
        ArrayList<COSKey> objectsToWrite = new ArrayList<COSKey>();
        for (COSObject obj : changedObjects) {
            COSKey key = obj.getObjectKey();
            if (key == null) continue;
            objectsToWrite.add(obj.getObjectKey());
        }
        changedObjects.clear();
        objectsToWrite.addAll(this.prepareAddedObjects(addedObjects));
        this.addToWrite(objectsToWrite);
        this.writeBody();
        COSTrailer trailer = this.document.getTrailer();
        this.setTrailer(trailer, this.document.getLastTrailerOffset());
        this.writeXRefInfo();
        this.clear();
    }

    private List<COSKey> prepareAddedObjects(List<COSObject> addedObjects) {
        int cosKeyNumber = this.document.getLastKeyNumber() + 1;
        ArrayList<COSKey> res = new ArrayList<COSKey>();
        for (COSObject obj : addedObjects) {
            if (!obj.isIndirect().booleanValue()) {
                COSObject indirect = COSIndirect.construct(obj, this.document);
                res.add(indirect.getObjectKey());
                continue;
            }
            res.add(obj.getObjectKey());
        }
        addedObjects.clear();
        return res;
    }

    @Override
    public void visitFromBoolean(COSBoolean obj) {
        try {
            this.write(String.valueOf(obj.get()));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void visitFromInteger(COSInteger obj) {
        try {
            this.write(obj.toString());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void visitFromReal(COSReal obj) {
        try {
            this.write(obj.toString());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void visitFromString(COSString obj) {
        try {
            this.write(obj.getPrintableString());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void visitFromName(COSName obj) {
        try {
            this.write(obj.toString());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void visitFromArray(COSArray obj) {
        try {
            this.write("[");
            for (int i = 0; i < obj.size(); ++i) {
                this.write(obj.at(i));
                this.write(" ");
            }
            this.write("]");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void visitFromDictionary(COSDictionary obj) {
        try {
            this.write("<<");
            for (Map.Entry<ASAtom, COSObject> entry : obj.getEntrySet()) {
                this.write(entry.getKey());
                this.write(" ");
                this.write(entry.getValue());
                this.write(" ");
            }
            this.write(">>");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void visitFromStream(COSStream obj) {
        long length = 0L;
        ASInputStream in = obj.getData();
        if (obj.getFilterFlags() == COSStream.FilterFlags.DECODE || obj.getFilterFlags() == COSStream.FilterFlags.DECRYPT_AND_DECODE) {
            // empty if block
        }
        try {
            obj.setIntegerKey(ASAtom.LENGTH, Writer.getASInputStreamLength(in));
        }
        catch (IOException e) {
            LOGGER.log(Level.FINE, "Can't calculate length of ASInputStream", e);
        }
        this.visitFromDictionary(obj);
        try {
            this.write(EOL);
            this.write("stream");
            this.write(EOL);
            length = this.getOffset();
            byte[] buffer = new byte[1024];
            long count = 0L;
            in.reset();
            while ((count = (long)in.read(buffer, 1024)) != -1L) {
                this.os.write(buffer, (int)count);
            }
            length = this.getOffset() - length;
            obj.setLength(length);
            this.write(EOL);
            this.write("endstream");
        }
        catch (IOException e) {
            throw new RuntimeException("Error writing document");
        }
    }

    private static long getASInputStreamLength(ASInputStream stream) throws IOException {
        if (stream instanceof SeekableInputStream) {
            return ((SeekableInputStream)stream).getStreamLength();
        }
        stream.reset();
        byte[] buf = new byte[2048];
        long res = 0L;
        int read = stream.read(buf);
        while (read != -1) {
            res += (long)read;
            read = stream.read(buf);
        }
        return res;
    }

    @Override
    public void visitFromNull(COSNull obj) {
        try {
            this.write("null");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void visitFromIndirect(COSIndirect obj) {
        try {
            COSKey key = obj.getKey();
            if (key.equals(new COSKey())) {
                COSObject direct = obj.getDirect();
                key = this.document.setObject(direct);
                obj.setKey(key, this.document);
                this.addToWrite(key);
            }
            this.write(key);
            this.write(" R");
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public void writeHeader(String header) {
        try {
            this.write(header);
            this.write(EOL);
            String comment = new String(new char[]{'%', '\u00e2', '\u00e3', '\u00cf', '\u00d3'});
            this.write(comment);
            this.write(EOL);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void addToWrite(COSKey key) {
        this.toWrite.add(key);
    }

    public void addToWrite(List<COSKey> keys) {
        this.toWrite.addAll(keys);
    }

    public void writeBody() {
        try {
            while (!this.toWrite.isEmpty()) {
                COSKey key = this.toWrite.get(0);
                this.toWrite.remove(0);
                this.written.add(key);
                this.write(key, this.document.getObject(key));
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Error writing document");
        }
    }

    public void freeObjects(Map<COSKey, Long> keys) {
        for (Map.Entry<COSKey, Long> entry : keys.entrySet()) {
            this.addXRef(entry.getKey(), entry.getValue(), 'f');
        }
    }

    public void setTrailer(COSTrailer trailer) {
        this.setTrailer(trailer, 0L);
    }

    public void setTrailer(COSTrailer trailer, long prev) {
        COSObject element = new COSObject();
        COSCopier copier = new COSCopier(element);
        trailer.getObject().accept(copier);
        this.info.getTrailer().setObject(element);
        this.info.getTrailer().setPrev(prev);
        if (prev == 0L) {
            this.info.getTrailer().removeKey(ASAtom.ID);
        }
    }

    public void writeXRefInfo() {
        try {
            this.info.setStartXRef(this.getOffset() + this.incrementalOffset);
            this.info.getTrailer().setSize(this.info.getXRefSection().next());
            this.write("xref");
            this.write(EOL);
            this.write(this.info.getXRefSection());
            this.write("trailer");
            this.write(EOL);
            this.write(this.info.getTrailer().getObject());
            this.write(EOL);
            this.write("startxref");
            this.write(EOL);
            this.write(this.info.getStartXRef());
            this.write(EOL);
            this.write("%%EOF");
            this.write(EOL);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public COSXRefInfo getXRefInfo() {
        return this.info;
    }

    public void clear() {
        try {
            this.info = new COSXRefInfo();
            this.toWrite.clear();
            this.written.clear();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void close() {
        try {
            this.os.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected long getOffset() {
        try {
            return this.os.getOffset();
        }
        catch (IOException e) {
            e.printStackTrace();
            return 0L;
        }
    }

    protected void write(COSKey key, COSObject object) throws IOException {
        this.addXRef(key);
        this.write(key);
        this.write(" obj");
        this.write(EOL);
        this.write(object);
        this.write(EOL);
        this.write("endobj");
        this.write(EOL);
    }

    protected void generateID() {
        Long idTime = System.currentTimeMillis();
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            md5.update(Long.toString(idTime).getBytes("ISO-8859-1"));
            COSObject idString = COSString.construct(md5.digest(), true);
            this.info.getTrailer().setID(idString);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected COSKey getKeyToWrite(COSKey key) {
        return key;
    }

    protected void addXRef(COSKey key, long offset, char free) {
        this.info.getXRefSection().add(this.getKeyToWrite(key), offset, free);
    }

    public void addXRef(COSKey key) throws IOException {
        this.addXRef(key, this.getOffset() + this.incrementalOffset, 'n');
    }

    protected void write(boolean value) throws IOException {
        this.os.write(value);
    }

    protected void write(int value) throws IOException {
        this.os.write(String.valueOf(value));
    }

    protected void write(long value) throws IOException {
        this.os.write(String.valueOf(value));
    }

    protected void write(char value) throws IOException {
        this.os.write(value);
    }

    protected void write(String value) throws IOException {
        this.os.write(value);
    }

    protected void write(ASAtom value) throws IOException {
        this.os.write(value.toString());
    }

    protected void write(COSKey value) throws IOException {
        COSKey newKey = this.getKeyToWrite(value);
        this.write(newKey.getNumber());
        this.write(" ");
        this.write(newKey.getGeneration());
    }

    protected void write(COSObject value) throws IOException {
        value.accept(this);
    }

    protected void write(COSXRefRange value) throws IOException {
        this.os.write(String.valueOf(value.start)).write(" ").write(String.valueOf(value.count)).write(EOL);
    }

    protected void write(COSXRefEntry value) throws IOException {
        String offset = this.formatXrefOffset.format(value.offset);
        String generation = this.formatXrefGeneration.format(value.generation);
        this.os.write(offset.getBytes(ASCharsets.ISO_8859_1));
        this.os.write(" ");
        this.os.write(generation.getBytes(ASCharsets.ISO_8859_1));
        this.os.write(" ");
        this.os.write(String.valueOf(value.free).getBytes(ASCharsets.US_ASCII));
        this.os.write(EOL);
    }

    protected void write(COSXRefSection value) throws IOException {
        List<COSXRefRange> range = value.getRange();
        for (int i = 0; i < range.size(); ++i) {
            this.write(range.get(i));
            for (int j = range.get((int)i).start; j < range.get(i).next(); ++j) {
                this.write(value.getEntry(j));
            }
        }
    }
}

