/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.factory.operators;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.verapdf.cos.COSBase;
import org.verapdf.gf.model.factory.operators.OperatorParser;
import org.verapdf.gf.model.factory.operators.RenderingMode;
import org.verapdf.gf.model.factory.operators.TransparencyGraphicsState;
import org.verapdf.gf.model.impl.pd.util.PDResourcesHandler;
import org.verapdf.gf.model.tools.TransparencyBehaviour;
import org.verapdf.operator.Operator;

public final class OperatorFactory {
    private static final Logger LOGGER = Logger.getLogger(OperatorFactory.class.getCanonicalName());
    private static final String MSG_UNEXPECTED_OBJECT_TYPE = "Unexpected type of object in tokens: ";
    private boolean isLastParsedContainsTransparency = false;
    private static final Map<String, TransparencyBehaviour> PAINT_OPERATORS_WITHOUT_TEXT;
    private static final Set<String> PAINT_OPERATORS_TEXT;
    private static final Map<RenderingMode, TransparencyBehaviour> RENDERING_MODE;

    public boolean isLastParsedContainsTransparency() {
        return this.isLastParsedContainsTransparency;
    }

    public List<org.verapdf.model.operator.Operator> operatorsFromTokens(List<Object> rawTokens, PDResourcesHandler resourcesHandler, boolean isIsolatedContentStream) {
        ArrayList<org.verapdf.model.operator.Operator> result = new ArrayList<org.verapdf.model.operator.Operator>();
        ArrayList<COSBase> arguments = new ArrayList<COSBase>();
        this.isLastParsedContainsTransparency = false;
        OperatorParser parser = new OperatorParser(isIsolatedContentStream);
        for (Object rawToken : rawTokens) {
            if (rawToken instanceof COSBase) {
                arguments.add((COSBase)rawToken);
                continue;
            }
            if (rawToken instanceof Operator) {
                parser.parseOperator(result, (Operator)rawToken, resourcesHandler, arguments);
                String parsedOperatorType = ((Operator)rawToken).getOperator();
                TransparencyGraphicsState graphicState = parser.getTransparencyGraphicState();
                if (PAINT_OPERATORS_WITHOUT_TEXT.containsKey(parsedOperatorType)) {
                    this.isLastParsedContainsTransparency |= PAINT_OPERATORS_WITHOUT_TEXT.get(parsedOperatorType).containsTransparency(graphicState);
                } else {
                    RenderingMode renderingMode = parser.getGSRenderingMode();
                    if (PAINT_OPERATORS_TEXT.contains(parsedOperatorType) && RENDERING_MODE.containsKey((Object)renderingMode)) {
                        this.isLastParsedContainsTransparency |= RENDERING_MODE.get((Object)renderingMode).containsTransparency(graphicState);
                    }
                }
                arguments = new ArrayList();
                continue;
            }
            LOGGER.log(Level.FINE, MSG_UNEXPECTED_OBJECT_TYPE + rawToken.getClass().getName());
        }
        return result;
    }

    static {
        HashMap<Object, TransparencyBehaviour> aMap = new HashMap<Object, TransparencyBehaviour>();
        TransparencyBehaviour fill = TransparencyBehaviour.createFillInstance();
        TransparencyBehaviour fillXObject = TransparencyBehaviour.createFillXObjectInstance();
        TransparencyBehaviour fillCS = TransparencyBehaviour.createFillColorSpaceInstance();
        TransparencyBehaviour strokeCS = TransparencyBehaviour.createStrokeColorSpaceInstance();
        TransparencyBehaviour fillStrokeCS = TransparencyBehaviour.createFillStrokeColorSpaceInstance();
        aMap.put("S", strokeCS);
        aMap.put("s", strokeCS);
        aMap.put("f", fillCS);
        aMap.put("F", fillCS);
        aMap.put("f*", fillCS);
        aMap.put("B", fillStrokeCS);
        aMap.put("B*", fillStrokeCS);
        aMap.put("b", fillStrokeCS);
        aMap.put("b*", fillStrokeCS);
        aMap.put("sh", fill);
        aMap.put("Do", fillXObject);
        aMap.put("EI", fill);
        PAINT_OPERATORS_WITHOUT_TEXT = Collections.unmodifiableMap(aMap);
        PAINT_OPERATORS_TEXT = new HashSet<String>(Arrays.asList("Tj", "'", "\"", "TJ"));
        aMap = new HashMap();
        TransparencyBehaviour strokeCSFont = TransparencyBehaviour.createStrokeColorSpaceFontInstance();
        TransparencyBehaviour fillCSFont = TransparencyBehaviour.createFillColorSpaceFontInstance();
        TransparencyBehaviour fillStrokeCSFont = TransparencyBehaviour.createFillStrokeColorSpaceFontInstance();
        aMap.put((Object)RenderingMode.FILL, fillCSFont);
        aMap.put((Object)RenderingMode.STROKE, strokeCSFont);
        aMap.put((Object)RenderingMode.FILL_STROKE, fillStrokeCSFont);
        aMap.put((Object)RenderingMode.FILL_CLIP, fillCSFont);
        aMap.put((Object)RenderingMode.STROKE_CLIP, strokeCSFont);
        aMap.put((Object)RenderingMode.FILL_STROKE_CLIP, fillStrokeCSFont);
        RENDERING_MODE = Collections.unmodifiableMap(aMap);
    }
}

