/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.pd;

import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSName;
import org.verapdf.cos.COSNumber;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.factory.fonts.PDFontFactory;
import org.verapdf.pd.PDHalftone;
import org.verapdf.pd.PDResource;
import org.verapdf.pd.font.PDFont;

public class PDExtGState
extends PDResource {
    public PDExtGState(COSObject obj) {
        super(obj);
    }

    public Boolean getAlphaSourceFlag() {
        return this.getObject().getBooleanKey(ASAtom.AIS);
    }

    public Boolean getAutomaticStrokeAdjustment() {
        return this.getObject().getBooleanKey(ASAtom.SA);
    }

    public Boolean getStrokingOverprintControl() {
        return this.getObject().getBooleanKey(ASAtom.OP);
    }

    public Boolean getNonStrokingOverprintControl() {
        return this.getObject().getBooleanKey(ASAtom.OP_NS);
    }

    public Long getOverprintMode() {
        return this.getObject().getIntegerKey(ASAtom.OPM);
    }

    public COSObject getCOSTR() {
        return this.getKey(ASAtom.TR);
    }

    public COSObject getCOSTR2() {
        return this.getKey(ASAtom.TR2);
    }

    public COSObject getCOSSMask() {
        return this.getKey(ASAtom.SMASK);
    }

    public COSObject getCOSBM() {
        return this.getKey(ASAtom.BM);
    }

    public Double getCA() {
        return this.getObject().getRealKey(ASAtom.CA);
    }

    public Double getCA_NS() {
        return this.getObject().getRealKey(ASAtom.CA_NS);
    }

    public COSName getCOSRenderingIntentName() {
        COSObject name = this.getKey(ASAtom.RI);
        if (name != null && name.getType() == COSObjType.COS_NAME) {
            return (COSName)name.getDirectBase();
        }
        return null;
    }

    public COSNumber getCOSFontSize() {
        COSObject res;
        COSObject fontArray = this.getKey(ASAtom.FONT);
        if (fontArray != null && fontArray.getType() == COSObjType.COS_ARRAY && (res = fontArray.at(1)) != null && res.getType().isNumber()) {
            return (COSNumber)res.getDirectBase();
        }
        return null;
    }

    public PDHalftone getHalftone() {
        COSObject obj = this.getKey(ASAtom.HT);
        if (obj != null && (obj.getType() == COSObjType.COS_NAME || obj.getType() == COSObjType.COS_DICT || obj.getType() == COSObjType.COS_STREAM)) {
            return new PDHalftone(obj);
        }
        return null;
    }

    public COSObject getHalftonePhase() {
        return this.getKey(ASAtom.HTP);
    }

    public PDFont getFont() {
        COSObject res;
        COSObject fontArray = this.getKey(ASAtom.FONT);
        if (fontArray != null && fontArray.getType() == COSObjType.COS_ARRAY && (res = fontArray.at(0)) != null && res.getType().isDictionaryBased()) {
            return PDFontFactory.getPDFont(res);
        }
        return null;
    }
}

